/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.channel;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.lifecycle.WebLifecycle;
import org.exoplatform.commons.notification.net.WebNotificationSender;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebChannel
extends AbstractChannel {
    public static final String ID = "WEB_CHANNEL";
    private final ChannelKey key = ChannelKey.key((String)"WEB_CHANNEL");
    private static final Log LOG = ExoLogger.getLogger(WebChannel.class);
    private final Map<PluginKey, String> templateFilePaths = new HashMap<PluginKey, String>();
    private final Map<PluginKey, AbstractTemplateBuilder> templateBuilders = new HashMap<PluginKey, AbstractTemplateBuilder>();
    public static final ArgumentLiteral<MessageInfo> MESSAGE_INFO = new ArgumentLiteral(MessageInfo.class, "messageInfo");

    public WebChannel() {
        super((AbstractNotificationLifecycle)new WebLifecycle());
    }

    public String getId() {
        return ID;
    }

    public ChannelKey getKey() {
        return this.key;
    }

    public void registerTemplateProvider(TemplateProvider provider) {
        this.templateFilePaths.putAll(provider.getTemplateFilePathConfigs());
        this.templateBuilders.putAll(provider.getTemplateBuilder());
    }

    public void dispatch(NotificationContext ctx, String userId) {
        try {
            MessageInfo msg = (MessageInfo)ctx.value(MESSAGE_INFO);
            if (msg != null) {
                NotificationInfo notification = ctx.getNotificationInfo();
                int badgeNumber = CommonsUtils.getService(WebNotificationStorage.class).getNumberOnBadge(notification.getTo());
                msg.setNumberOnBadge(badgeNumber);
                WebNotificationSender.sendJsonMessage(notification.getTo(), msg);
                notification.setTitle(msg.getBody());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to connect with server :", (Throwable)e);
        }
    }

    public String getTemplateFilePath(PluginKey key) {
        return this.templateFilePaths.get(key);
    }

    public boolean hasTemplateBuilder(PluginKey key) {
        AbstractTemplateBuilder builder = this.templateBuilders.get(key);
        return builder != null;
    }

    protected AbstractTemplateBuilder getTemplateBuilderInChannel(PluginKey key) {
        return this.templateBuilders.get(key);
    }
}

