/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.channel;

import java.io.Writer;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.lifecycle.SimpleLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ConsoleChannel
extends AbstractChannel {
    private static final Log LOG = ExoLogger.getLogger(ConsoleChannel.class);
    private static final String ID = "CONSOLE_CHANNEL";
    private final ChannelKey key = ChannelKey.key((String)"CONSOLE_CHANNEL");

    public ConsoleChannel() {
        super((AbstractNotificationLifecycle)new SimpleLifecycle());
    }

    public String getId() {
        return ID;
    }

    public ChannelKey getKey() {
        return this.key;
    }

    public void dispatch(NotificationContext ctx, String userId) {
        LOG.info((Object)String.format("CONSOLE:: %s will be received the message from pluginId: %s", userId, ctx.getNotificationInfo().getKey().getId()));
    }

    public void registerTemplateProvider(TemplateProvider provider) {
    }

    protected AbstractTemplateBuilder getTemplateBuilderInChannel(PluginKey key) {
        return new AbstractTemplateBuilder(){

            protected MessageInfo makeMessage(NotificationContext ctx) {
                NotificationInfo notification = ctx.getNotificationInfo();
                MessageInfo messageInfo = new MessageInfo();
                return messageInfo.from(notification.getFrom()).to(notification.getTo()).body(notification.getKey().getId() + " raised notification: " + notification.getTitle()).end();
            }

            protected boolean makeDigest(NotificationContext ctx, Writer writer) {
                return false;
            }
        };
    }
}

