/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.account.setup.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/welcomeScreen")
public class WelcomeScreenRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WelcomeScreenRestService.class);

    @GET
    @Path(value="/checkUsername")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response checkUsername(@QueryParam(value="username") String username) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        boolean userExists = false;
        JSONObject jsonObject = new JSONObject();
        OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        UserHandler userHandler = orgService.getUserHandler();
        try {
            if (userHandler.findUserByName(username) != null) {
                userExists = true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while checking if username exists.", (Throwable)e);
        }
        try {
            jsonObject.put("userExists", userExists);
        }
        catch (JSONException e) {
            LOG.error((Object)"An error occurred while creating JSONObject that will be returned to identify if username exists.", (Throwable)e);
        }
        return Response.ok((Object)jsonObject.toString()).cacheControl(cacheControl).build();
    }
}

