/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.info.test;

import javax.ws.rs.core.Response;
import org.exoplatform.commons.info.PlatformInformationRESTService;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.commons.testing.BaseResourceTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.wadl.research.HTTPMethods;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/commons-component-product-configuration.xml")})
public class PlatformInformationRESTServiceTEST
extends BaseResourceTestCase {
    public void tearDown() throws Exception {
        super.tearDown();
        this.endSession();
    }

    public void setUp() throws Exception {
        super.setUp();
        PlatformInformationRESTServiceTEST.assertNotNull((Object)this.getContainer().getComponentInstanceOfType(PlatformInformationRESTService.class));
        this.registry(new PlatformInformationRESTService((ProductInformations)this.getService(ProductInformations.class), (UserACL)this.getService(UserACL.class)));
    }

    public void testGetPlatformInformationAnonymous() throws Exception {
        ContainerResponse response = this.service(HTTPMethods.GET.toString(), "/platform/info", "", null, null);
        PlatformInformationRESTServiceTEST.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        PlatformInformationRESTService.JsonPlatformInfo jsonPlatformInfo = (PlatformInformationRESTService.JsonPlatformInfo)response.getEntity();
        PlatformInformationRESTServiceTEST.assertNotNull((Object)jsonPlatformInfo);
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getBuildNumber());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getDateOfKeyGeneration());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getDuration());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getIsMobileCompliant());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getNbUsers());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getPlatformBuildNumber());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getPlatformEdition());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getPlatformRevision());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getProductCode());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getRunningProfile());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getUnlockKey());
        PlatformInformationRESTServiceTEST.assertEquals((String)"4.3.0+", (String)jsonPlatformInfo.getPlatformVersion());
    }

    public void testGetPlatformInformationAuthenticatedUser() throws Exception {
        this.startSessionAs("mary");
        ContainerResponse response = this.service(HTTPMethods.GET.toString(), "/platform/info", "", null, null);
        PlatformInformationRESTServiceTEST.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        PlatformInformationRESTService.JsonPlatformInfo jsonPlatformInfo = (PlatformInformationRESTService.JsonPlatformInfo)response.getEntity();
        PlatformInformationRESTServiceTEST.assertNotNull((Object)jsonPlatformInfo);
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getBuildNumber());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getDateOfKeyGeneration());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getDuration());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getIsMobileCompliant());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getNbUsers());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getPlatformBuildNumber());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getPlatformEdition());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getPlatformRevision());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getProductCode());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getRunningProfile());
        PlatformInformationRESTServiceTEST.assertNull((Object)jsonPlatformInfo.getUnlockKey());
        PlatformInformationRESTServiceTEST.assertEquals((String)"4.3.0+", (String)jsonPlatformInfo.getPlatformVersion());
    }

    public void testGetPlatformInformationAuthenticatedAdminUser() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service(HTTPMethods.GET.toString(), "/platform/info", "", null, null);
        PlatformInformationRESTServiceTEST.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        PlatformInformationRESTService.JsonPlatformInfo jsonPlatformInfo = (PlatformInformationRESTService.JsonPlatformInfo)response.getEntity();
        PlatformInformationRESTServiceTEST.assertNotNull((Object)jsonPlatformInfo);
        PlatformInformationRESTServiceTEST.assertNotNull((Object)jsonPlatformInfo.getPlatformBuildNumber());
        PlatformInformationRESTServiceTEST.assertNotNull((Object)jsonPlatformInfo.getPlatformEdition());
        PlatformInformationRESTServiceTEST.assertNotNull((Object)jsonPlatformInfo.getPlatformRevision());
        PlatformInformationRESTServiceTEST.assertNotNull((Object)jsonPlatformInfo.getPlatformVersion());
        Assert.assertNotEquals((Object)"4.3.0+", (Object)jsonPlatformInfo.getPlatformVersion());
    }

    private void startSessionAs(String user) {
        try {
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            Identity userIdentity = authenticator.createIdentity(user);
            ConversationState.setCurrent((ConversationState)new ConversationState(userIdentity));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void endSession() {
        ConversationState.setCurrent(null);
    }

    private void registry(Object resource) {
        this.resourceBinder.addResource(resource, null);
    }
}

