/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.upgrade;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class UpgradeProductPlugin
extends BaseComponentPlugin {
    public static final String UPGRADE_COMPLETED_STATUS = "Completed";
    public static final String PRODUCT_GROUP_ID = "product.group.id";
    public static final String OLD_PRODUCT_GROUP_ID = "old.product.group.id";
    public static final String UPGRADE_PLUGIN_ASYNC = "plugin.upgrade.async.execution";
    public static final String UPGRADE_PLUGIN_TARGET_PARAMETER = "plugin.upgrade.target.version";
    public static final String UPGRADE_PLUGIN_EXECUTE_ONCE_PARAMETER = "plugin.upgrade.execute.once";
    public static final String UPGRADE_PLUGIN_EXECUTION_ORDER = "plugin.execution.order";
    public static final String UPGRADE_PLUGIN_ENABLE = "commons.upgrade.{$0}.enable";
    private static final Log LOG = ExoLogger.getLogger(UpgradeProductPlugin.class);
    private SettingService settingService = null;
    private int pluginExecutionOrder = 0;
    protected String productGroupId = null;
    protected String oldProductGroupId = null;
    protected String targetVersion = null;
    protected boolean asyncUpgradeExecution = false;
    protected boolean executeOnlyOnce = false;

    public UpgradeProductPlugin(SettingService settingService, InitParams initParams) {
        this(initParams);
        this.settingService = settingService;
    }

    public UpgradeProductPlugin(InitParams initParams) {
        if (!initParams.containsKey((Object)PRODUCT_GROUP_ID)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Couldn't find the init value param: product.group.id");
            }
            return;
        }
        this.productGroupId = initParams.getValueParam(PRODUCT_GROUP_ID).getValue();
        ValueParam vp = initParams.getValueParam(OLD_PRODUCT_GROUP_ID);
        this.oldProductGroupId = vp != null ? vp.getValue() : this.productGroupId;
        this.pluginExecutionOrder = !initParams.containsKey((Object)UPGRADE_PLUGIN_EXECUTION_ORDER) ? 0 : Integer.parseInt(initParams.getValueParam(UPGRADE_PLUGIN_EXECUTION_ORDER).getValue());
        if (initParams.containsKey((Object)UPGRADE_PLUGIN_TARGET_PARAMETER)) {
            this.targetVersion = initParams.getValueParam(UPGRADE_PLUGIN_TARGET_PARAMETER).getValue();
        }
        if (initParams.containsKey((Object)UPGRADE_PLUGIN_ASYNC)) {
            this.asyncUpgradeExecution = Boolean.parseBoolean(initParams.getValueParam(UPGRADE_PLUGIN_ASYNC).getValue());
        }
        if (initParams.containsKey((Object)UPGRADE_PLUGIN_EXECUTE_ONCE_PARAMETER)) {
            this.executeOnlyOnce = Boolean.parseBoolean(initParams.getValueParam(UPGRADE_PLUGIN_EXECUTE_ONCE_PARAMETER).getValue());
        }
    }

    public String getProductGroupId() {
        return this.productGroupId;
    }

    public String getOldProductGroupId() {
        return this.oldProductGroupId;
    }

    public void beforeUpgrade() {
    }

    public void afterUpgrade() {
    }

    public boolean isAsyncUpgradeExecution() {
        return this.asyncUpgradeExecution;
    }

    public boolean isExecuteOnlyOnce() {
        return this.executeOnlyOnce;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public boolean isEnabled() {
        String isEnabledProperty = PropertyManager.getProperty((String)UPGRADE_PLUGIN_ENABLE.replace("{$0}", this.getName()));
        return isEnabledProperty == null || isEnabledProperty.equals("true");
    }

    public void addNodeVersion(Node nodeToAddVersion, String versionLabel) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, ItemExistsException, InvalidItemStateException, ReferentialIntegrityException, RepositoryException {
        if (!nodeToAddVersion.isNodeType("mix:versionable")) {
            nodeToAddVersion.addMixin("mix:versionable");
            nodeToAddVersion.save();
            nodeToAddVersion.getSession().save();
            nodeToAddVersion.getSession().refresh(true);
        }
        if (nodeToAddVersion.isCheckedOut()) {
            Version version = nodeToAddVersion.checkin();
            nodeToAddVersion.getVersionHistory().addVersionLabel(version.getName(), versionLabel, true);
        }
        nodeToAddVersion.checkout();
    }

    public abstract void processUpgrade(String var1, String var2);

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return true;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        String previousVersion;
        int executionCount;
        String previousArtifactVersion = previousUpgradePluginExecution == null ? null : previousUpgradePluginExecution.getVersion();
        int n = executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        if (StringUtils.isBlank((String)previousGroupVersion) && StringUtils.isBlank((String)previousArtifactVersion)) {
            throw new IllegalArgumentException("At least one previous version (artifact or group versions) shouldn't be null (equals to '0') for plugin " + ((Object)((Object)this)).getClass().getName());
        }
        if (StringUtils.isBlank((String)newVersion)) {
            throw new IllegalArgumentException("No declared version for Upgrade plugin " + ((Object)((Object)this)).getClass().getName());
        }
        if (this.isExecuteOnlyOnce() && executionCount > 0) {
            return false;
        }
        String string = previousVersion = StringUtils.isBlank((String)previousArtifactVersion) ? previousGroupVersion : previousArtifactVersion;
        if (VersionComparator.isBefore(newVersion, previousVersion) || StringUtils.isNotBlank((String)previousArtifactVersion) && (VersionComparator.isBefore(newVersion, previousArtifactVersion) || VersionComparator.isSame(newVersion, previousArtifactVersion))) {
            return false;
        }
        if (StringUtils.isNotBlank((String)this.getTargetVersion()) && (VersionComparator.isBefore(this.getTargetVersion(), previousVersion) || VersionComparator.isSame(this.getTargetVersion(), previousVersion))) {
            return false;
        }
        return this.shouldProceedToUpgrade(newVersion, previousVersion);
    }

    public final boolean equals(Object obj) {
        if (obj != null && obj instanceof UpgradeProductPlugin) {
            return this.getName().equals(((UpgradeProductPlugin)((Object)obj)).getName());
        }
        return false;
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public int getPluginExecutionOrder() {
        return this.pluginExecutionOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String paramName) {
        if (this.settingService == null) {
            throw new IllegalStateException("SettingService Service is not set");
        }
        try {
            Scope appId = Scope.APPLICATION.id(this.getName());
            SettingValue paramValue = this.settingService.get(Context.GLOBAL, appId, paramName);
            if (paramValue != null && paramValue.getValue() != null) {
                String string = paramValue.getValue().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            Scope.APPLICATION.id(null);
        }
    }

    public void storeValueForPlugin(String paramName, String paramValue) {
        if (this.settingService == null) {
            throw new IllegalStateException("SettingService Service is not set");
        }
        try {
            this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id(this.getName()), paramName, SettingValue.create((String)paramValue));
        }
        finally {
            Scope.APPLICATION.id(null);
        }
    }
}

