/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.cluster.StartableClusterAware;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class UpgradeProductService
implements StartableClusterAware {
    public static final Context UPGRADE_PRODUCT_CONTEXT = Context.GLOBAL.id("UPGRADE_PRODUCT_CONTEXT");
    private static final Log LOG = ExoLogger.getLogger(UpgradeProductService.class);
    private static final String UPGRADE_PLUGIN_VERSION_KEY = "UPGRADE_PLUGIN_VERSION";
    private static final String PLUGINS_ORDER = "commons.upgrade.plugins.order";
    private static final String PROCEED_UPGRADE_FIRST_RUN_KEY = "proceedUpgradeWhenFirstRun";
    private static final String PRODUCT_VERSION_ZERO = "0";
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private PortalContainer portalContainer;
    private List<UpgradeProductPlugin> upgradePlugins = new ArrayList<UpgradeProductPlugin>();
    private Set<UpgradeProductPlugin> allUpgradePlugins = new HashSet<UpgradeProductPlugin>();
    private ProductInformations productInformations = null;
    private SettingService settingService = null;
    private NodeHierarchyCreator nodeHierarchyCreator = null;
    private boolean proceedUpgradeFirstRun = false;
    private Comparator<UpgradeProductPlugin> pluginsComparator = null;

    public UpgradeProductService(PortalContainer portalContainer, NodeHierarchyCreator nodeHierarchyCreator, SettingService settingService, ProductInformations productInformations, InitParams initParams) {
        this.productInformations = productInformations;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.settingService = settingService;
        this.portalContainer = portalContainer;
        if (!initParams.containsKey((Object)PROCEED_UPGRADE_FIRST_RUN_KEY)) {
            LOG.warn((Object)("init param 'proceedUpgradeWhenFirstRun' isn't set, use default value (" + this.proceedUpgradeFirstRun + "). Don't proceed upgrade when this service will run for the first time."));
        } else {
            this.proceedUpgradeFirstRun = Boolean.parseBoolean(initParams.getValueParam(PROCEED_UPGRADE_FIRST_RUN_KEY).getValue());
        }
        String pluginsOrder = PropertyManager.getProperty((String)PLUGINS_ORDER);
        if (StringUtils.isBlank((String)pluginsOrder)) {
            LOG.info("Property '{}' wasn't set, use execution order of each plugin.", new Object[]{PLUGINS_ORDER});
            this.pluginsComparator = new Comparator<UpgradeProductPlugin>(){

                @Override
                public int compare(UpgradeProductPlugin o1, UpgradeProductPlugin o2) {
                    int index1 = o1.getPluginExecutionOrder();
                    index1 = index1 <= 0 ? UpgradeProductService.this.upgradePlugins.size() : index1;
                    int index2 = o2.getPluginExecutionOrder();
                    index2 = index2 <= 0 ? UpgradeProductService.this.upgradePlugins.size() : index2;
                    return index1 - index2;
                }
            };
        } else {
            final List<String> pluginsOrderList = Arrays.asList(pluginsOrder.split(","));
            this.pluginsComparator = new Comparator<UpgradeProductPlugin>(){

                @Override
                public int compare(UpgradeProductPlugin o1, UpgradeProductPlugin o2) {
                    int index1 = pluginsOrderList.indexOf(o1.getName());
                    index1 = index1 < 0 ? UpgradeProductService.this.upgradePlugins.size() : index1;
                    int index2 = pluginsOrderList.indexOf(o2.getName());
                    index2 = index2 < 0 ? UpgradeProductService.this.upgradePlugins.size() : index2;
                    return index1 - index2;
                }
            };
        }
    }

    public void addUpgradePlugin(UpgradeProductPlugin upgradeProductPlugin) {
        if (upgradeProductPlugin.isEnabled()) {
            if (this.upgradePlugins.contains((Object)upgradeProductPlugin)) {
                LOG.warn("Duplicated upgrade plugin '{}'.", new Object[]{upgradeProductPlugin.getName()});
            } else {
                LOG.info("Add Product UpgradePlugin '{}'", new Object[]{upgradeProductPlugin.getName()});
                this.upgradePlugins.add(upgradeProductPlugin);
                this.allUpgradePlugins.add(upgradeProductPlugin);
            }
        } else {
            LOG.info("UpgradePlugin: name = '{}' is disabled.", new Object[]{upgradeProductPlugin.getName()});
        }
    }

    public void start() {
        if (this.nodeHierarchyCreator instanceof Startable) {
            ((Startable)this.nodeHierarchyCreator).start();
        }
        this.productInformations.start();
        if (this.productInformations.isFirstRun()) {
            LOG.info("Proceed upgrade on first run = {}", new Object[]{this.proceedUpgradeFirstRun});
            if (!this.proceedUpgradeFirstRun) {
                LOG.info((Object)"Ignore all upgrade plugins");
                for (UpgradeProductPlugin upgradeProductPlugin : this.allUpgradePlugins) {
                    String currentProductPluginVersion = this.getCurrentVersion(upgradeProductPlugin);
                    UpgradePluginExecutionContext currenUpgradePluginExecutionContext = new UpgradePluginExecutionContext(currentProductPluginVersion, 0);
                    this.storeUpgradePluginVersion(upgradeProductPlugin, currenUpgradePluginExecutionContext);
                }
                return;
            }
            this.productInformations.setPreviousVersionsIfFirstRun(PRODUCT_VERSION_ZERO);
        }
        Collections.sort(this.upgradePlugins, this.pluginsComparator);
        LOG.info((Object)"Start transparent upgrade framework");
        try {
            for (UpgradeProductPlugin upgradeProductPlugin : this.upgradePlugins) {
                UpgradePluginExecutionContext previousUpgradePluginExecutionContext = this.getPreviousUpgradePluginVersion(upgradeProductPlugin);
                String previousUpgradePluginVersion = previousUpgradePluginExecutionContext == null ? null : previousUpgradePluginExecutionContext.getVersion();
                String previousGroupVersion = this.getPreviousVersionByGroupId(upgradeProductPlugin);
                String previousVersion = StringUtils.isBlank((String)previousUpgradePluginVersion) ? previousGroupVersion : previousUpgradePluginVersion;
                String currentVersion = this.getCurrentVersion(upgradeProductPlugin);
                try {
                    if (upgradeProductPlugin.shouldProceedToUpgrade(currentVersion, previousGroupVersion, previousUpgradePluginExecutionContext)) {
                        if (StringUtils.isBlank((String)previousUpgradePluginVersion)) {
                            previousUpgradePluginExecutionContext = new UpgradePluginExecutionContext(previousGroupVersion, 0);
                            this.storeUpgradePluginVersion(upgradeProductPlugin, previousUpgradePluginExecutionContext);
                        }
                        LOG.info("Proceed upgrade the plugin (async = {}): name = {} from version {} to {}", new Object[]{upgradeProductPlugin.isAsyncUpgradeExecution(), upgradeProductPlugin.getName(), previousVersion, currentVersion});
                        if (upgradeProductPlugin.isAsyncUpgradeExecution()) {
                            UpgradePluginExecutionContext previousUpgradePluginExecutionContextFinal = previousUpgradePluginExecutionContext;
                            Runnable task = () -> {
                                ExoContainerContext.setCurrentContainer((ExoContainer)this.portalContainer);
                                RequestLifeCycle.begin((ExoContainer)this.portalContainer);
                                try {
                                    this.proceedToUpgrade(upgradeProductPlugin, currentVersion, previousVersion, previousUpgradePluginExecutionContextFinal);
                                }
                                finally {
                                    RequestLifeCycle.end();
                                }
                            };
                            this.executorService.execute(task);
                            continue;
                        }
                        this.proceedToUpgrade(upgradeProductPlugin, currentVersion, previousVersion, previousUpgradePluginExecutionContext);
                        continue;
                    }
                    LOG.info("Ignore upgrade plugin {} from version {} to {}", new Object[]{upgradeProductPlugin.getName(), previousVersion, currentVersion});
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while upgrading plugin with name '" + upgradeProductPlugin.getName() + "'. The upgrade plugin will attempt again next startup."), (Throwable)e);
                }
            }
            this.productInformations.storeProductsInformationsInJCR();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing upgrade plugins", (Throwable)e);
        }
    }

    public void stop() {
        this.executorService.shutdown();
    }

    public boolean isDone() {
        return false;
    }

    public void resetService() {
        this.productInformations.start();
        this.upgradePlugins.clear();
        for (UpgradeProductPlugin upgradeProductPlugin : this.allUpgradePlugins) {
            this.upgradePlugins.add(upgradeProductPlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedToUpgrade(UpgradeProductPlugin upgradeProductPlugin, String currentVersion, String previousVersion, UpgradePluginExecutionContext upgradePluginExecutionContext) {
        upgradeProductPlugin.beforeUpgrade();
        try {
            upgradeProductPlugin.processUpgrade(previousVersion, currentVersion);
            upgradePluginExecutionContext.setExecutionCount(upgradePluginExecutionContext.getExecutionCount() + 1);
            upgradePluginExecutionContext.setVersion(currentVersion);
            this.storeUpgradePluginVersion(upgradeProductPlugin, upgradePluginExecutionContext);
            LOG.info("Upgrade of plugin {} completed.", new Object[]{upgradeProductPlugin.getName()});
        }
        catch (Exception e) {
            LOG.error((Object)("Error while upgrading plugin with name '" + upgradeProductPlugin.getName() + "'. The upgrade plugin will attempt again next startup."), (Throwable)e);
        }
        finally {
            upgradeProductPlugin.afterUpgrade();
        }
    }

    private String getCurrentVersion(UpgradeProductPlugin upgradeProductPlugin) {
        String currentUpgradePluginVersion = null;
        try {
            currentUpgradePluginVersion = this.productInformations.getVersion(upgradeProductPlugin.getName());
        }
        catch (MissingProductInformationException e) {
            try {
                currentUpgradePluginVersion = this.productInformations.getVersion(upgradeProductPlugin.getProductGroupId());
            }
            catch (MissingProductInformationException e1) {
                currentUpgradePluginVersion = PRODUCT_VERSION_ZERO;
            }
        }
        return currentUpgradePluginVersion;
    }

    private String getPreviousVersionByGroupId(UpgradeProductPlugin upgradeProductPlugin) {
        String previousUpgradePluginVersion;
        try {
            previousUpgradePluginVersion = this.productInformations.getPreviousVersion(upgradeProductPlugin.getName());
        }
        catch (MissingProductInformationException e) {
            try {
                previousUpgradePluginVersion = this.productInformations.getPreviousVersion(upgradeProductPlugin.getProductGroupId());
            }
            catch (MissingProductInformationException e1) {
                previousUpgradePluginVersion = PRODUCT_VERSION_ZERO;
            }
        }
        if (StringUtils.isBlank((String)previousUpgradePluginVersion)) {
            previousUpgradePluginVersion = PRODUCT_VERSION_ZERO;
        }
        return previousUpgradePluginVersion;
    }

    private void storeUpgradePluginVersion(UpgradeProductPlugin upgradeProductPlugin, UpgradePluginExecutionContext upgradePluginExecution) {
        if (upgradePluginExecution == null) {
            throw new IllegalArgumentException("UpgradePluginExecution is null");
        }
        Scope upgradePluginScope = this.getUpgradePluginScope(upgradeProductPlugin);
        this.settingService.set(UPGRADE_PRODUCT_CONTEXT, upgradePluginScope, UPGRADE_PLUGIN_VERSION_KEY, SettingValue.create((String)upgradePluginExecution.toString()));
    }

    private UpgradePluginExecutionContext getPreviousUpgradePluginVersion(UpgradeProductPlugin upgradeProductPlugin) {
        Scope upgradePluginScope = this.getUpgradePluginScope(upgradeProductPlugin);
        SettingValue upgradePluginVersion = this.settingService.get(UPGRADE_PRODUCT_CONTEXT, upgradePluginScope, UPGRADE_PLUGIN_VERSION_KEY);
        return upgradePluginVersion == null ? null : new UpgradePluginExecutionContext(upgradePluginVersion.getValue().toString());
    }

    private Scope getUpgradePluginScope(UpgradeProductPlugin upgradeProductPlugin) {
        return Scope.APPLICATION.id(upgradeProductPlugin.getName());
    }
}

