/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.dlp.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/dlp")
@Api(value="/dlp", description="Manages Dlp features")
public class DlpRestServices
implements ResourceContainer {
    public static final String DLP_FEATURE = "dlp";
    private static final Log LOG = ExoLogger.getLogger(DlpRestServices.class);

    @Path(value="/changeFeatureActivation/{isActive}")
    @PUT
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Change a feature activation.", httpMethod="GET", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response changeFeatureActivation(@ApiParam(value="Is active feature", required=true) @PathParam(value="isActive") String isActive) {
        try {
            if (!this.isDlpAdmin()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ExoFeatureService featureService = (ExoFeatureService)CommonsUtils.getService(ExoFeatureService.class);
            boolean isActiveBool = Boolean.parseBoolean(isActive);
            featureService.saveActiveFeature(DLP_FEATURE, isActiveBool);
            return Response.ok().type("text/plain").build();
        }
        catch (Exception e) {
            LOG.warn("Error when changing feature activation with name '{}'", new Object[]{DLP_FEATURE, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private boolean isDlpAdmin() {
        UserACL userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        return userACL.isSuperUser() || userACL.isUserInGroup(userACL.getDlpGroups());
    }
}

