/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.portlet.juzu.notificationsAdmin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.request.ApplicationContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.platform.portlet.juzu.notificationsAdmin.NotificationsAdministration;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;

public class NotificationsAdministration {
    private static final Log LOG = ExoLogger.getLogger(NotificationsAdministration.class);
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    ResourceBundle bundle;
    @Inject
    PluginSettingService pluginSettingService;
    @Inject
    SettingService settingService;
    @Inject
    ChannelManager channelManager;
    private Locale locale = Locale.ENGLISH;

    @View
    public Response index(ApplicationContext applicationContext, UserContext userContext) {
        if (!CommonsUtils.isFeatureActive((String)"notification")) {
            return this.redirectToHomePage();
        }
        this.locale = userContext.getLocale();
        ResourceBundle rs = applicationContext.resolveBundle(this.locale);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("_ctx", new Context(this, rs));
        List groups = this.pluginSettingService.getGroupPlugins();
        parameters.put("groups", groups);
        parameters.put("channels", this.getChannels());
        parameters.put("senderName", MailUtils.getSenderName());
        parameters.put("senderEmail", MailUtils.getSenderEmail());
        return this.index.ok(parameters);
    }

    private List<String> getChannels() {
        ArrayList<String> channels = new ArrayList<String>();
        for (AbstractChannel channel : this.channelManager.getChannels()) {
            channels.add(channel.getId());
        }
        return channels;
    }

    private Response redirectToHomePage() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest currentServletRequest = portalRequestContext.getRequest();
        StringBuilder sb = new StringBuilder();
        sb.append(currentServletRequest.getScheme()).append("://").append(currentServletRequest.getServerName()).append(":").append(currentServletRequest.getServerPort()).append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(Util.getPortalRequestContext().getPortalOwner());
        WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jsManager = ctx.getJavascriptManager();
        jsManager.addJavascript((CharSequence)("try { window.location.href='" + sb.toString() + "' } catch(e) {window.location.href('" + sb.toString() + "') }"));
        return Response.redirect((String)sb.toString());
    }

    @Ajax
    @Resource
    public Response saveActivePlugin(String pluginId, String inputs) {
        JSON data = new JSON();
        try {
            Map datas = this.parserParams(inputs);
            for (String channelId : datas.keySet()) {
                this.pluginSettingService.saveActivePlugin(channelId, pluginId, Boolean.valueOf((String)datas.get(channelId)).booleanValue());
            }
            data.set("status", (Object)"ok");
            data.set("result", (Object)datas);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save settings", (Throwable)e);
            data.set("status", (Object)"false");
            data.set("error", (Object)("Exception: " + e.getMessage()));
        }
        return Response.ok((CharSequence)data.toString()).withMimeType("application/json");
    }

    @Ajax
    @Resource
    public Response saveSender(String name, String email) {
        JSON data = new JSON();
        data.set("name", (Object)name);
        data.set("email", (Object)email);
        if (name != null && name.length() > 0 && NotificationUtils.isValidNotificationSenderName((String)name) && NotificationUtils.isValidEmailAddresses((String)email)) {
            this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, "exo:notificationSenderName", SettingValue.create((String)name));
            this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, "exo:notificationSenderEmail", SettingValue.create((String)email));
            data.set("status", (Object)"OK");
        } else if (!NotificationUtils.isValidNotificationSenderName((String)name)) {
            data.set("status", (Object)"NameNOK");
        } else if (!NotificationUtils.isValidEmailAddresses((String)email)) {
            data.set("status", (Object)"EmailNOK");
        } else {
            data.set("status", (Object)"NOK");
        }
        return Response.ok((CharSequence)data.toString()).withMimeType("application/json");
    }

    private Map<String, String> parserParams(String params) {
        HashMap<String, String> datas = new HashMap<String, String>();
        String[] arrays = params.split("&");
        for (int i = 0; i < arrays.length; ++i) {
            String[] data = arrays[i].split("=");
            datas.put(data[0], data[1]);
        }
        return datas;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ Locale access$100(NotificationsAdministration x0) {
        return x0.locale;
    }
}

