/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.resource.ResourceProviderPlugin;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class BinaryProviderDelegate
implements BinaryProvider,
Startable {
    private static final Log LOG = ExoLogger.getLogger(BinaryProviderDelegate.class);
    private static final String STORAGE_TYPE = "storageType";
    private static final String DEFAULT_PROVIDER_CLASS = "org.exoplatform.commons.file.resource.FileSystemResourceProvider";
    private Class<? extends BinaryProvider> binaryProviderClass;
    private BinaryProvider delegate;
    private InitParams initParams;
    private List<ResourceProviderPlugin> plugins = new ArrayList<ResourceProviderPlugin>();

    public BinaryProviderDelegate(InitParams initParams) {
        this.initParams = initParams;
    }

    @Override
    public void put(String name, InputStream data) throws IOException {
        this.delegate.put(name, data);
    }

    @Override
    public void put(FileItem fileItem) throws IOException {
        this.delegate.put(fileItem);
    }

    @Override
    public void put(String name, byte[] data) throws IOException {
        this.delegate.put(name, data);
    }

    @Override
    public InputStream getStream(String name) {
        return this.delegate.getStream(name);
    }

    @Override
    public String getFilePath(FileInfo fileInfo) throws IOException {
        return this.delegate.getFilePath(fileInfo);
    }

    @Override
    public String getFilePath(String name) throws IOException {
        return this.delegate.getFilePath(name);
    }

    @Override
    public byte[] getBytes(String name) {
        return this.delegate.getBytes(name);
    }

    @Override
    public void remove(String name) throws IOException {
        this.delegate.remove(name);
    }

    @Override
    public boolean remove(FileInfo fileInfo) throws IOException {
        return this.delegate.remove(fileInfo);
    }

    @Override
    public boolean exists(String name) throws IOException {
        return this.delegate.exists(name);
    }

    @Override
    public long lastModified(String name) throws IOException {
        return this.delegate.lastModified(name);
    }

    @Override
    public URL getURL(String name) {
        return this.delegate.getURL(name);
    }

    @Override
    public String getLocation() {
        return this.delegate.getLocation();
    }

    private void initBinaryProviderClass(String className) {
        try {
            Class clazz = ClassLoading.forName((String)className, (Object)this);
            if (BinaryProvider.class.isAssignableFrom(clazz)) {
                this.binaryProviderClass = clazz;
            } else {
                LOG.error("Invalid value for binaryProviderClass, {} does not implement BinaryProvider interface.", new Object[]{className});
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Invalid value for binaryProviderClass, class {} not found.", new Object[]{className});
        }
    }

    public void addResourceProviderPlugin(ResourceProviderPlugin resourceProviderPlugin) {
        this.plugins.add(resourceProviderPlugin);
    }

    public void start() {
        String provider = null;
        String storageType = null;
        ValueParam valueParam = this.initParams.getValueParam(STORAGE_TYPE);
        if (valueParam != null) {
            storageType = valueParam.getValue();
        }
        if (storageType != null && !storageType.isEmpty()) {
            ResourceProviderPlugin resource;
            Iterator<ResourceProviderPlugin> iterator = this.plugins.iterator();
            while (iterator.hasNext() && ((provider = (resource = iterator.next()).getResourceProviderData().get(storageType)) == null || provider.isEmpty())) {
            }
        }
        if (provider == null || provider.isEmpty()) {
            provider = DEFAULT_PROVIDER_CLASS;
        }
        this.initBinaryProviderClass(provider);
        LOG.info((Object)("Binary provider used " + provider));
        this.delegate = (BinaryProvider)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(this.binaryProviderClass);
    }

    public void stop() {
        this.plugins.clear();
    }
}

