/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.resource.FileUtils;
import org.exoplatform.commons.file.storage.dao.FileBinaryDAO;
import org.exoplatform.commons.file.storage.entity.FileBinaryEntity;

public class RdbmsResourceProvider
implements BinaryProvider {
    private FileBinaryDAO fileBinaryDAO;

    public RdbmsResourceProvider(FileBinaryDAO fileBinaryDAO) {
        this.fileBinaryDAO = fileBinaryDAO;
    }

    @Override
    public void put(String name, InputStream data) throws IOException {
        Date now = Calendar.getInstance().getTime();
        FileBinaryEntity fileBinaryEntity = new FileBinaryEntity();
        fileBinaryEntity.setData(FileUtils.readBytes(data));
        fileBinaryEntity.setName(name);
        fileBinaryEntity.setUpdatedDate(now);
        this.fileBinaryDAO.create(fileBinaryEntity);
    }

    @Override
    public void put(FileItem fileItem) throws IOException {
        Date now = Calendar.getInstance().getTime();
        FileBinaryEntity fileBinaryEntity = new FileBinaryEntity();
        fileBinaryEntity.setData(FileUtils.readBytes(fileItem.getAsStream()));
        fileBinaryEntity.setName(fileItem.getFileInfo().getChecksum());
        fileBinaryEntity.setUpdatedDate(now);
        this.fileBinaryDAO.create(fileBinaryEntity);
    }

    @Override
    public void put(String name, byte[] data) throws IOException {
        Date now = Calendar.getInstance().getTime();
        FileBinaryEntity fileBinaryEntity = new FileBinaryEntity();
        fileBinaryEntity.setData(data);
        fileBinaryEntity.setName(name);
        fileBinaryEntity.setUpdatedDate(now);
        this.fileBinaryDAO.create(fileBinaryEntity);
    }

    @Override
    public InputStream getStream(String name) {
        ByteArrayInputStream stream = null;
        byte[] bytes = this.fileBinaryDAO.findFileBinaryByName(name).getData();
        if (bytes != null) {
            stream = new ByteArrayInputStream(bytes);
        }
        return stream;
    }

    @Override
    public String getFilePath(FileInfo fileInfo) {
        FileBinaryEntity fileBinaryEntity = this.fileBinaryDAO.findFileBinaryByName(fileInfo.getChecksum());
        return fileBinaryEntity != null ? "rdbms:" + fileBinaryEntity.getId() : null;
    }

    @Override
    public String getFilePath(String name) {
        FileBinaryEntity fileBinaryEntity = this.fileBinaryDAO.findFileBinaryByName(name);
        return fileBinaryEntity != null ? "rdbms:" + fileBinaryEntity.getId() : null;
    }

    @Override
    public byte[] getBytes(String name) {
        return this.fileBinaryDAO.findFileBinaryByName(name).getData();
    }

    @Override
    public void remove(String name) throws IOException {
        FileBinaryEntity fileBinaryEntity = this.fileBinaryDAO.findFileBinaryByName(name);
        if (fileBinaryEntity != null) {
            this.fileBinaryDAO.delete(fileBinaryEntity);
        }
    }

    @Override
    public boolean remove(FileInfo fileInfo) throws IOException {
        FileBinaryEntity fileBinaryEntity = this.fileBinaryDAO.findFileBinaryByName(fileInfo.getChecksum());
        if (fileBinaryEntity != null) {
            this.fileBinaryDAO.delete(fileBinaryEntity);
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(String name) throws IOException {
        FileBinaryEntity fileBinaryEntity = this.fileBinaryDAO.findFileBinaryByName(name);
        return fileBinaryEntity != null;
    }

    @Override
    public long lastModified(String name) throws IOException {
        FileBinaryEntity fileBinaryEntity = this.fileBinaryDAO.findFileBinaryByName(name);
        return fileBinaryEntity.getUpdatedDate().getTime();
    }

    @Override
    public URL getURL(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLocation() {
        return "rdbms";
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public String toString() {
        return this.getLocation();
    }
}

