/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.juzu.ajax;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import org.exoplatform.commons.juzu.ajax.Ajax;

public class AjaxMetaModelPlugin
extends ApplicationMetaModelPlugin {
    private static final Name AJAX = Name.create(Ajax.class);
    private final HashMap<ElementHandle.Package, Boolean> enabledMap = new HashMap();

    public AjaxMetaModelPlugin() {
        super("plf4-ajax");
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Ajax.class);
    }

    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (key.getType().equals((Object)AJAX)) {
            ElementHandle.Package handle = metaModel.getHandle();
            this.enabledMap.put(handle, true);
        }
    }

    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (key.getType().equals((Object)AJAX)) {
            ElementHandle.Package handle = metaModel.getHandle();
            this.enabledMap.remove(handle);
        }
    }

    public void init(ApplicationMetaModel application) {
    }

    public void destroy(ApplicationMetaModel application) {
        this.enabledMap.remove(application.getHandle());
    }

    public JSON getDescriptor(ApplicationMetaModel application) {
        ElementHandle.Package handle = application.getHandle();
        Boolean enabled = this.enabledMap.get(handle);
        return enabled != null && enabled != false ? new JSON() : null;
    }
}

