/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.exoplatform.commons.search.es.client.ElasticClientAuthenticationException;
import org.exoplatform.commons.search.es.client.ElasticClientException;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class ElasticClient {
    private static final String ES_INDEX_CLIENT_DEFAULT = "http://127.0.0.1:9200";
    private static final Log LOG = ExoLogger.getExoLogger(ElasticClient.class);
    protected String urlClient = "http://127.0.0.1:9200";
    protected HttpClient client = this.getHttpClient();
    protected ElasticIndexingAuditTrail auditTrail;

    public ElasticClient(ElasticIndexingAuditTrail auditTrail) {
        if (auditTrail == null) {
            throw new IllegalArgumentException("AuditTrail is null");
        }
        this.auditTrail = auditTrail;
    }

    protected ElasticResponse sendHttpPostRequest(String url, String content) {
        ElasticResponse response;
        try {
            HttpPost httpTypeRequest = new HttpPost(url);
            httpTypeRequest.setEntity((HttpEntity)new StringEntity(content, "UTF-8"));
            response = this.handleHttpResponse(this.client.execute((HttpUriRequest)httpTypeRequest));
            LOG.debug("Sent request to ES:\n Method = POST \nURI =  {} \nContent = {}", new Object[]{url, content});
            this.logResultDependingOnStatusCode(url, response);
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
        return response;
    }

    protected ElasticResponse sendHttpDeleteRequest(String url) {
        ElasticResponse response;
        try {
            HttpDelete httpDeleteRequest = new HttpDelete(url);
            response = this.handleHttpResponse(this.client.execute((HttpUriRequest)httpDeleteRequest));
            LOG.debug("Sent request to ES:\n Method = DELETE \nURI =  {}", new Object[]{url});
            this.logResultDependingOnStatusCode(url, response);
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
        return response;
    }

    protected ElasticResponse sendHttpGetRequest(String url) {
        ElasticResponse response;
        try {
            HttpGet httpGetRequest = new HttpGet(url);
            response = this.handleHttpResponse(this.client.execute((HttpUriRequest)httpGetRequest));
            LOG.debug("Sent request to ES:\n Method = GET \nURI =  {}", new Object[]{url});
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElasticResponse handleHttpResponse(HttpResponse httpResponse) throws IOException {
        String response = null;
        InputStream is = null;
        if (httpResponse.getEntity() != null) {
            try {
                is = httpResponse.getEntity().getContent();
                response = IOUtils.toString((InputStream)is, (String)"UTF-8");
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        if (httpResponse.getStatusLine().getStatusCode() == 401) {
            throw new ElasticClientAuthenticationException();
        }
        return new ElasticResponse(response, httpResponse.getStatusLine().getStatusCode());
    }

    private void logResultDependingOnStatusCode(String url, ElasticResponse response) {
        if (ElasticIndexingAuditTrail.isError(response.getStatusCode())) {
            LOG.error("Error when trying to send request to ES. Url: {}, StatusCode: {}, Message: {}", new Object[]{url, response.getStatusCode(), response.getMessage()});
        } else {
            LOG.debug("Success request to ES. Url: {}, StatusCode: {}, Message: {}", new Object[]{url, response.getStatusCode(), response.getMessage()});
        }
    }

    private HttpClient getHttpClient() {
        if (StringUtils.isNotBlank((String)this.getEsUsernameProperty())) {
            DefaultHttpClient httpClient = new DefaultHttpClient(this.getClientConnectionManager());
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.getEsUsernameProperty(), this.getEsPasswordProperty()));
            LOG.debug("Basic authentication for ES activated with username = {} and password = {}", new Object[]{this.getEsUsernameProperty(), this.getEsPasswordProperty()});
            return httpClient;
        }
        LOG.debug((Object)"Basic authentication for ES not activated");
        return new DefaultHttpClient(this.getClientConnectionManager());
    }

    protected abstract String getEsUsernameProperty();

    protected abstract String getEsPasswordProperty();

    protected abstract ClientConnectionManager getClientConnectionManager();
}

