/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.commons.search.es.client.ElasticClient;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ElasticSearchingClient
extends ElasticClient {
    private static final Log LOG = ExoLogger.getLogger(ElasticSearchingClient.class);
    private static final String ES_SEARCH_CLIENT_PROPERTY_NAME = "exo.es.search.server.url";
    private static final String ES_SEARCH_CLIENT_PROPERTY_USERNAME = "exo.es.search.server.username";
    private static final String ES_SEARCH_CLIENT_PROPERTY_PASSWORD = "exo.es.search.server.password";

    public ElasticSearchingClient(ElasticIndexingAuditTrail auditTrail) {
        super(auditTrail);
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_NAME))) {
            this.urlClient = PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_NAME);
            LOG.info("Using {} as Searching URL", new Object[]{this.urlClient});
        } else {
            LOG.info((Object)"Using default as Searching URL");
        }
    }

    public String sendRequest(String esQuery, String index, String type) {
        long startTime = System.currentTimeMillis();
        StringBuilder url = new StringBuilder();
        url.append(this.urlClient);
        if (StringUtils.isNotBlank((String)index)) {
            url.append("/" + index);
            if (StringUtils.isNotBlank((String)type)) {
                url.append("/" + type);
            }
        }
        url.append("/_search");
        ElasticResponse elasticResponse = this.sendHttpPostRequest(url.toString(), esQuery);
        String response = elasticResponse.getMessage();
        int statusCode = elasticResponse.getStatusCode();
        if (ElasticIndexingAuditTrail.isError(statusCode)) {
            this.auditTrail.logRejectedSearchOperation("search_type", index, type, statusCode, response, System.currentTimeMillis() - startTime);
        } else if (this.auditTrail.isFullLogEnabled()) {
            this.auditTrail.logAcceptedSearchOperation("search_type", index, type, statusCode, response, System.currentTimeMillis() - startTime);
        }
        return response;
    }

    @Override
    protected String getEsUsernameProperty() {
        return PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_USERNAME);
    }

    @Override
    protected String getEsPasswordProperty() {
        return PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_PASSWORD);
    }

    @Override
    protected HttpClientConnectionManager getClientConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }
}

