/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.es.client.ElasticClientException;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONObject;

public class ElasticContentRequestBuilder {
    private static final Log LOG = ExoLogger.getExoLogger(ElasticContentRequestBuilder.class);

    public String getCreateIndexRequestContent(ElasticIndexingServiceConnector connector) {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"settings\" : {\n").append("    \"number_of_shards\" : \"").append(connector.getShards()).append("\",\n").append("    \"number_of_replicas\" : \"").append(connector.getReplicas()).append("\",\n").append("    \"analysis\" : {").append("      \"analyzer\" : {").append("        \"default\" : {").append("          \"tokenizer\" : \"standard\",").append("          \"filter\" : [\"standard\", \"lowercase\", \"asciifolding\"]").append("        },").append("        \"whitespace_lowercase_asciifolding\" : {").append("          \"tokenizer\" : \"whitespace\",").append("          \"filter\" : [\"lowercase\", \"asciifolding\"]").append("        }").append("      }").append("    }\n").append("  }\n").append("}");
        String request = mapping.toString();
        LOG.debug("Create index request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getDeleteAllDocumentsRequestContent() {
        JSONObject deleteAllRequest = new JSONObject();
        JSONObject deleteQueryRequest = new JSONObject();
        deleteQueryRequest.put((Object)"match_all", (Object)new JSONObject());
        deleteAllRequest.put((Object)"query", (Object)deleteQueryRequest);
        String request = deleteAllRequest.toJSONString();
        LOG.debug("Delete All request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getDeleteDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject cudHeaderRequest = this.createCUDHeaderRequestContent(connector, id);
        String request = null;
        if (cudHeaderRequest != null) {
            JSONObject deleteRequest = new JSONObject();
            deleteRequest.put((Object)"delete", (Object)cudHeaderRequest);
            request = deleteRequest.toJSONString() + "\n";
        }
        LOG.debug("Delete request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getCreateDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject ElasticInformation = this.createCUDHeaderRequestContent(connector, id);
        Document document = connector.create(id);
        if (document == null) {
            throw new ElasticClientException("Document generated by connector " + connector.getName() + " for the creation of entity [" + id + "] is null");
        }
        JSONObject createRequest = new JSONObject();
        createRequest.put((Object)"create", (Object)ElasticInformation);
        String request = createRequest.toJSONString() + "\n" + document.toJSON() + "\n";
        LOG.debug("Create request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getCreatePipelineDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        Document document = connector.update(id);
        String request = null;
        if (document != null) {
            request = document.toJSON();
        }
        LOG.debug("Create Pipeline document request to ES: \n {}", new Object[]{request});
        return request;
    }

    public String getUpdateDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject ElasticInformation = this.createCUDHeaderRequestContent(connector, id);
        Document document = connector.update(id);
        String request = null;
        if (document != null) {
            JSONObject updateRequest = new JSONObject();
            updateRequest.put((Object)"index", (Object)ElasticInformation);
            request = updateRequest.toJSONString() + "\n" + document.toJSON() + "\n";
        }
        LOG.debug("Update request to ES: \n {}", new Object[]{request});
        return request;
    }

    private JSONObject createCUDHeaderRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject CUDHeader = new JSONObject();
        CUDHeader.put((Object)"_index", (Object)connector.getIndex());
        CUDHeader.put((Object)"_type", (Object)connector.getType());
        CUDHeader.put((Object)"_id", (Object)id);
        return CUDHeader;
    }
}

