/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.test.BasicTestCase;

public abstract class BaseCommonsTestCase
extends BasicTestCase {
    protected final String REPO_NAME = "repository";
    protected final String WORKSPACE_NAME = "portal-test";
    protected PortalContainer container;
    protected RepositoryService repositoryService;
    protected ConfigurationManager configurationManager;
    protected Session session;
    protected Node root;

    public void setUp() throws Exception {
        this.container = PortalContainer.getInstance();
        this.repositoryService = this.getService(RepositoryService.class);
        this.configurationManager = this.getService(ConfigurationManager.class);
        this.session = this.repositoryService.getRepository("repository").getSystemSession("portal-test");
        this.root = this.session.getRootNode();
        System.setProperty("gatein.email.domain.url", "http://localhost:8080");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        NodeIterator iter = this.root.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            node.remove();
        }
        this.session.save();
        this.session.logout();
    }

    protected <T> T getService(Class<T> clazz) {
        return clazz.cast(this.container.getComponentInstanceOfType(clazz));
    }
}

