/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ContainerRequest;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.InputHeadersMap;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.tools.DummyContainerResponseWriter;

public class BaseResourceTestCase
extends BaseExoTestCase {
    protected static Log log = ExoLogger.getLogger((String)BaseResourceTestCase.class.getName());
    protected SessionProvider sessionProvider;
    protected ProviderBinder providerBinder;
    protected ResourceBinder resourceBinder;
    protected RequestHandlerImpl requestHandler;
    protected final String REPO_NAME = "repository";
    protected final String WORKSPACE_NAME = "portal-test";
    protected PortalContainer container;
    protected RepositoryService repositoryService;
    protected ConfigurationManager configurationManager;
    protected Session session;
    protected Node root;

    public void setUp() throws Exception {
        super.setUp();
        this.container = PortalContainer.getInstance();
        this.repositoryService = this.getService(RepositoryService.class);
        this.configurationManager = this.getService(ConfigurationManager.class);
        this.repositoryService.setCurrentRepositoryName("repository");
        this.session = this.repositoryService.getCurrentRepository().getSystemSession("portal-test");
        this.root = this.session.getRootNode();
        this.resourceBinder = this.getService(ResourceBinder.class);
        this.requestHandler = this.getService(RequestHandlerImpl.class);
        ProviderBinder.setInstance((ProviderBinder)new ProviderBinder());
        this.providerBinder = ProviderBinder.getInstance();
        ApplicationContextImpl.setCurrent((ApplicationContext)new ApplicationContextImpl(null, null, this.providerBinder));
        this.resourceBinder.clear();
        this.begin();
    }

    public void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, ContainerResponseWriter writer) throws Exception {
        if (headers == null) {
            headers = new MultivaluedMapImpl();
        }
        ByteArrayInputStream in = null;
        if (data != null) {
            in = new ByteArrayInputStream(data);
        }
        EnvironmentContext envctx = new EnvironmentContext();
        EnvironmentContext.setCurrent((EnvironmentContext)envctx);
        ContainerRequest request = new ContainerRequest(method, new URI(requestURI), new URI(baseURI), (InputStream)in, (MultivaluedMap)new InputHeadersMap((Map)headers));
        ContainerResponse response = new ContainerResponse(writer);
        this.requestHandler.handleRequest((GenericContainerRequest)request, (GenericContainerResponse)response);
        return response;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, MultivaluedMap<String, String> headers, byte[] data) throws Exception {
        return this.service(method, requestURI, baseURI, (Map<String, List<String>>)headers, data, (ContainerResponseWriter)new DummyContainerResponseWriter());
    }

    public void addResource(Class<?> resourceClass, MultivaluedMap<String, String> properties) {
        this.resourceBinder.addResource(resourceClass, properties);
    }

    public void addResource(Object resource, MultivaluedMap<String, String> properties) {
        this.resourceBinder.addResource(resource, properties);
    }

    public void removeResource(Class clazz) {
        this.resourceBinder.removeResource(clazz);
    }

    protected <T> T getService(Class<T> clazz) {
        return clazz.cast(this.container.getComponentInstanceOfType(clazz));
    }
}

