/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.commons;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.commons.UIUploadArea;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/webui/commons/UIDocumentSelector.gtmpl", events={@EventConfig(listeners={SelectFileActionListener.class}), @EventConfig(listeners={SelectFolderActionListener.class})})
public class UIDocumentSelector
extends UIContainer {
    protected static final String UPLOAD_AREA = "UPLOAD_AREA";
    protected static final String SELECT_FILE = "SelectFile";
    protected static final String SELECT_FOLDER = "SelectFolder";
    protected static final String REST_PREFIX = "/managedocument";
    protected static final String GET_DRIVES = "/managedocument/getDrives";
    protected static final String GET_FOLDERS_AND_FILES = "/managedocument/getFoldersAndFiles";
    protected static final String DELETE_FOLDER_OR_FILE = "/managedocument/deleteFolderOrFile";
    protected static final String CREATE_FOLDER = "/managedocument/createFolder";
    protected static final String PARAM_DRIVE_TYPE = "driveType";
    protected static final String PARAM_DRIVE_NAME = "driveName";
    protected static final String PARAM_WORKSPACE_NAME = "workspaceName";
    protected static final String PARAM_CURRENT_FOLDER = "currentFolder";
    protected static final String PARAM_IS_FOLDER_ONLY = "isFolderOnly";
    protected static final String PARAM_FOLDER_NAME = "folderName";
    protected static final String PARAM_ITEM_PATH = "itemPath";
    protected static final String DATA_ID = "dataId";
    protected String seletedFile = "";
    protected String seletedFolder = "";
    private boolean isShowUpload = true;

    public UIDocumentSelector() throws Exception {
        this.addChild(UIUploadArea.class, null, UPLOAD_AREA);
    }

    public boolean isShowUpload() {
        return this.isShowUpload;
    }

    public void setShowUpload(boolean isShowUpload) {
        this.isShowUpload = isShowUpload;
    }

    public String getSeletedFile() {
        return this.seletedFile;
    }

    public void setSeletedFile(String seletedFile) {
        this.seletedFile = seletedFile;
    }

    public String getSeletedFolder() {
        return this.seletedFolder;
    }

    public void setSeletedFolder(String seletedFolder) {
        this.seletedFolder = seletedFolder;
    }

    protected String getRestContext() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (!(context instanceof PortalRequestContext)) {
            context = (WebuiRequestContext)context.getParentAppRequestContext();
        }
        String requestURL = ((PortalRequestContext)context).getRequest().getRequestURL().toString();
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        StringBuilder sb = new StringBuilder();
        sb.append(requestURL.substring(0, requestURL.indexOf(portalName))).append(portalName).append("/").append(restContextName);
        return sb.toString();
    }

    public static class SelectFolderActionListener
    extends EventListener<UIDocumentSelector> {
        public void execute(Event<UIDocumentSelector> event) throws Exception {
            UIDocumentSelector component = (UIDocumentSelector)((Object)event.getSource());
            component.seletedFolder = event.getRequestContext().getRequestParameter(UIDocumentSelector.DATA_ID);
            component.seletedFile = "";
            ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
        }
    }

    public static class SelectFileActionListener
    extends EventListener<UIDocumentSelector> {
        public void execute(Event<UIDocumentSelector> event) throws Exception {
            UIDocumentSelector component = (UIDocumentSelector)((Object)event.getSource());
            component.seletedFile = event.getRequestContext().getRequestParameter(UIDocumentSelector.DATA_ID);
            component.seletedFolder = "";
            ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
        }
    }
}

