/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class UIFormRichtextInput
extends UIFormInputBase<String> {
    public static final String FULL_TOOLBAR = "CompleteWCM";
    public static final String BASIC_TOOLBAR = "Basic";
    public static final String SUPER_BASIC_TOOLBAR = "SuperBasicWCM";
    public static final String INLINE_TOOLBAR = "InlineEdit";
    public static final String COMMENT_TOOLBAR = "Comment";
    public static final String FORUM_TOOLBAR = "Forum";
    public static final String FAQ_TOOLBAR = "FAQ";
    public static final String ENTER_P = "1";
    public static final String ENTER_BR = "2";
    public static final String ENTER_DIV = "3";
    private static final String CKEDITOR_ENTER_P = "CKEDITOR.ENTER_P";
    private static final String CKEDITOR_ENTER_BR = "CKEDITOR.ENTER_BR";
    private static final String CKEDITOR_ENTER_DIV = "CKEDITOR.ENTER_DIV";
    private String width;
    private String height;
    private String toolbar;
    private String enterMode;
    private String shiftEnterMode;
    private boolean forceEnterMode = false;
    private String css;
    private boolean isPasteAsPlainText = false;
    private boolean isIgnoreParserHTML = false;

    public UIFormRichtextInput(String name, String bindingField, String value) {
        super(name, bindingField, String.class);
        this.value_ = value;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode, String toolbar) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
        this.toolbar = toolbar;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode, String toolbar, String css) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
        this.toolbar = toolbar;
        this.css = css;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getToolbar() {
        return this.toolbar;
    }

    public String getEnterMode() {
        return this.enterMode;
    }

    public String getShiftEnterMode() {
        return this.shiftEnterMode;
    }

    public void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    public void setEnterMode(String enterMode) {
        this.enterMode = enterMode;
    }

    public void setShiftEnterMode(String shiftEnterMode) {
        this.shiftEnterMode = shiftEnterMode;
    }

    public UIFormRichtextInput setIsPasteAsPlainText(boolean isPasteAsPlainText) {
        this.isPasteAsPlainText = isPasteAsPlainText;
        return this;
    }

    public boolean getIsPasteAsPlainText() {
        return this.isPasteAsPlainText;
    }

    public boolean isIgnoreParserHTML() {
        return this.isIgnoreParserHTML;
    }

    public UIFormRichtextInput setIgnoreParserHTML(boolean isIgnoreParserHTML) {
        this.isIgnoreParserHTML = isIgnoreParserHTML;
        return this;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getCss() {
        return this.css;
    }

    private static String encodeURLComponent(String s) {
        String result = null;
        try {
            result = URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    private String buildEditorLayout(WebuiRequestContext context) throws Exception {
        if (this.toolbar == null) {
            this.toolbar = BASIC_TOOLBAR;
        }
        if (this.width == null) {
            this.width = "98%";
        }
        if (this.height == null) {
            this.height = "'200px'";
        }
        if (this.enterMode == null) {
            this.enterMode = CKEDITOR_ENTER_P;
        }
        if (this.shiftEnterMode == null) {
            this.shiftEnterMode = CKEDITOR_ENTER_BR;
        }
        if (CKEDITOR_ENTER_P.equals(this.enterMode) && CKEDITOR_ENTER_DIV.equals(this.shiftEnterMode) || CKEDITOR_ENTER_DIV.equals(this.enterMode) && CKEDITOR_ENTER_P.equals(this.shiftEnterMode)) {
            this.forceEnterMode = true;
        }
        if (this.css == null) {
            this.css = "\"/commons-extension/ckeditor/contents.css\"";
        }
        if (this.value_ == null) {
            this.value_ = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"clearfix\">");
        builder.append("  <span style=\"float:left; width:").append(this.width).append(";\">");
        builder.append("  <textarea style=\"width:1px;height:1px;\" id=\"").append(this.name).append("\" name=\"").append(this.name).append("\">").append((String)this.value_).append("</textarea>\n");
        builder.append("  </span>");
        if (this.isMandatory()) {
            builder.append("  <span style=\"float:left\"> &nbsp;*</span>");
        }
        builder.append("</div>");
        StringBuilder jsBuilder = new StringBuilder();
        String str = this.name;
        String variableName = TimeConvertUtils.santializeJavaVariable(str);
        String textArea = "textarea" + variableName;
        String textArea1 = "textarea" + variableName;
        String instance = "instance" + variableName;
        String form = "form" + variableName;
        String functionName = "ckeditorGenerate" + variableName;
        jsBuilder.append("function " + functionName + "() {");
        jsBuilder.append(" var " + textArea + " = document.getElementById('").append(this.name).append("'); ");
        if (this.isIgnoreParserHTML() && StringUtils.isNotEmpty((String)((String)this.value_))) {
            String value = UIFormRichtextInput.encodeURLComponent((String)this.value_);
            jsBuilder.append(" if(" + textArea + ") {").append("   var isFirefox = typeof InstallTrigger !== 'undefined';").append("   var value = decodeURIComponent('").append(value).append("');").append("   if(isFirefox) { " + textArea + ".value = value; } else { " + textArea + ".innerText = value;}").append(" }");
        }
        jsBuilder.append("var " + instance + " = CKEDITOR.instances['").append(this.name).append("'];\n").append("if (" + instance + ") { ").append("   CKEDITOR.remove(" + instance + "); " + instance + " = null;\n").append("}\n").append(" CKEDITOR.replace('").append(this.name).append("', {toolbar:'").append(this.toolbar).append("', height:").append(this.height).append(", contentsCss:").append(this.css).append(", enterMode:").append(this.enterMode).append(this.isPasteAsPlainText ? ", forcePasteAsPlainText: true" : "").append(", forceEnterMode:").append(this.forceEnterMode).append(", shiftEnterMode:").append(this.shiftEnterMode).append("});\n").append(instance + " = CKEDITOR.instances['").append(this.name).append("'];\n").append(instance + ".on( 'change', function(e) { \n").append("   document.getElementById('").append(this.name).append("').value = " + instance + ".getData(); \n").append("});\n").append("var " + form + " = " + textArea + "; \n").append("while (" + form + " && (" + form + ".nodeName.toLowerCase() != 'form')) { \n").append("   " + form + " = " + form + ".parentNode;\n").append("} \n").append("if (" + form + ") {\n").append("   " + form + ".textareaName = '").append(this.name).append("'; \n").append("   " + form + ".onmouseover=function() { \n").append("     this.onmouseover=''; \n").append("     var " + textArea1 + " = document.getElementById('").append(this.name).append("');  \n").append("     " + textArea1 + ".style.display='block'; \n").append("     " + textArea1 + ".style.visibility='visible'; \n").append("     " + textArea1 + ".focus(); \n").append("     " + textArea1 + ".style.display='none'; \n").append("   } \n").append("} \n");
        jsBuilder.append("}\n");
        jsBuilder.append(functionName + "();\n");
        context.getJavascriptManager().require("/commons-extension/ckeditor/ckeditor.js").addScripts(jsBuilder.toString());
        return builder.toString();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getWriter().write(this.buildEditorLayout(context));
    }

    public void decode(Object input, WebuiRequestContext context) {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }
}

