/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelUtils {
    private KernelUtils() {
    }

    public static <T> T getService(Class<? extends T> clazz) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return (T)container.getComponentInstanceOfType(clazz);
    }

    public static void addValueParam(InitParams params, String name, String value) {
        ValueParam param = new ValueParam();
        param.setName(name);
        param.setValue(value);
        params.addParameter((Parameter)param);
    }

    public static void addObjectParam(InitParams params, String name, Object value) {
        ObjectParameter param = new ObjectParameter();
        param.setName(name);
        param.setObject(value);
        params.addParameter((Parameter)param);
    }

    public static void addPropertiesParam(InitParams params, String name, Map<String, String> map) {
        PropertiesParam param = new PropertiesParam();
        param.setName(name);
        for (String key : map.keySet()) {
            Property prop = new Property(key, map.get(key));
            param.addProperty((Object)prop);
        }
        params.addParameter((Parameter)param);
    }

    public static void addValuesParam(InitParams params, String name, String ... values) {
        ValuesParam param = new ValuesParam();
        param.setName(name);
        param.setValues(new ArrayList<String>(Arrays.asList(values)));
        params.addParameter((Parameter)param);
    }
}

