/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing.webui;

import org.exoplatform.commons.testing.webui.AbstractWebuiTestCase;
import org.exoplatform.web.application.AbstractApplicationMessage;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUIComponentTestCase<T extends UIComponent>
extends AbstractWebuiTestCase {
    protected T component;

    @Override
    public void doSetUp() {
        try {
            this.initComponent();
        }
        catch (Exception e) {
            AbstractUIComponentTestCase.fail((String)("failed to initialize UIComponent: " + e.getMessage()));
        }
    }

    private void initComponent() throws Exception {
        this.component = this.createComponent();
        this.component.setParent((UIComponent)new MockUIApplication());
    }

    protected abstract T createComponent() throws Exception;

    protected void assertApplicationMessage(String key) {
        UIApplication app = (UIApplication)this.component.getAncestorOfType(UIApplication.class);
        boolean found = false;
        for (AbstractApplicationMessage message : app.getUIPopupMessages().getWarnings()) {
            if (!key.equals(message.getMessageKey())) continue;
            found = true;
        }
        for (AbstractApplicationMessage message : app.getUIPopupMessages().getInfos()) {
            if (!key.equals(message.getMessageKey())) continue;
            found = true;
        }
        for (AbstractApplicationMessage message : app.getUIPopupMessages().getErrors()) {
            if (!key.equals(message.getMessageKey())) continue;
            found = true;
        }
        AbstractUIComponentTestCase.assertTrue((String)("Message not found <" + key + ">"), (boolean)found);
    }

    class MockUIApplication
    extends UIApplication {
    }
}

