/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.company.component.web;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.rss.parser.DefaultRSSChannel;
import org.exoplatform.services.rss.parser.DefaultRSSItem;
import org.exoplatform.services.rss.parser.RSSDocument;
import org.exoplatform.services.rss.parser.RSSParser;
import org.picocontainer.Startable;
/**
 * Created by The eXo Platform SAS
 * Author : Nam Phung <phunghainam@gmail.com>
 */

public class RssReaderCompanyService implements Startable {
  
  private String uriParam_;
  private ExoCache exoCache_;
  private InitParams initParams_;
  
  public RssReaderCompanyService(InitParams initParams, CacheService cacheSevice) throws Exception {
    initParams_ = initParams ;   
    uriParam_ = initParams_.getValueParam("uri").getValue() ;
    exoCache_=cacheSevice.getCacheInstance(RssReaderCompanyService.class.getName());    
  }

  public void start() {
  }

  @SuppressWarnings("unchecked")
  public List<DefaultRSSItem> getRssListItems() throws Exception{   
    Object cachedList = exoCache_.get(uriParam_) ;
    if(cachedList != null ) {
      return (List<DefaultRSSItem>)cachedList ;
    }   
    RSSParser rssPar = new RSSParser();
    List<DefaultRSSItem> lstItem = new ArrayList<DefaultRSSItem>() ;
    try{    
      RSSDocument<DefaultRSSChannel, DefaultRSSItem> rssDoc = rssPar.createDocument(
          new URI(uriParam_), "utf-8");
      lstItem = rssDoc.getItems();
    }catch(Exception allEx){
      return new ArrayList<DefaultRSSItem>();
    }
    exoCache_.put(uriParam_, lstItem); 
    exoCache_.setLiveTime(3600);
    return lstItem;
  }

  public void stop() {
  }
}
