package com.naftogaz.listeners;


import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.IdentityStorage;


import java.util.ArrayList;
import java.util.List;


public class SocialUserProfileEventListenerImpl extends UserProfileEventListener {

    @Override
    public void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        RequestLifeCycle.begin(PortalContainer.getInstance());
        try{
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            //
            IdentityManager idm = (IdentityManager) container.getComponentInstanceOfType(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity(OrganizationIdentityProvider.NAME, userProfile.getUserName());

            //
            Profile profile = identity.getProfile();

            //
            String uEmployer = null;
            String uBirthday = null;
            String uMobile = null;
            String uHome_Phone= null;

            if (userProfile != null) {
                uEmployer = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]);//"user.jobtitle"
                uBirthday = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[3]);//"user.bdate"
                uMobile = userProfile.getAttribute(UserProfile.BUSINESE_INFO_KEYS[5]);//"user.business-info.telecom.mobile.number"
                uHome_Phone = userProfile.getAttribute(UserProfile.BUSINESE_INFO_KEYS[6]);//"user.business-info.telecom.telephone.number"
            }

            //
            String pEmployer = (String) profile.getProperty(UserProfile.PERSONAL_INFO_KEYS[7]);
            String pBirthday = (String) profile.getProperty(UserProfile.PERSONAL_INFO_KEYS[3]);
            String pMobile = (String) profile.getProperty(UserProfile.BUSINESE_INFO_KEYS[5]);
            String pHome_Phone = (String) profile.getProperty(UserProfile.BUSINESE_INFO_KEYS[6]);
            //
            boolean hasUpdated = false;

            //
            if (uEmployer != null && !uEmployer.equals(pEmployer)) {
                profile.setProperty(UserProfile.PERSONAL_INFO_KEYS[7], uEmployer);
                List<Profile.UpdateType> list = new ArrayList<Profile.UpdateType>();
                list.add(Profile.UpdateType.CONTACT);
                profile.setListUpdateTypes(list);
                hasUpdated = true;
            }
            if (uBirthday != null && !uBirthday.equals(pBirthday)) {
                profile.setProperty(UserProfile.PERSONAL_INFO_KEYS[3], uBirthday);
                List<Profile.UpdateType> list = new ArrayList<Profile.UpdateType>();
                list.add(Profile.UpdateType.CONTACT);
                profile.setListUpdateTypes(list);
                hasUpdated = true;
            }
            if (uMobile != null && !uMobile.equals(pMobile)) {
                profile.setProperty(UserProfile.BUSINESE_INFO_KEYS[5], uMobile);
                List<Profile.UpdateType> list = new ArrayList<Profile.UpdateType>();
                list.add(Profile.UpdateType.CONTACT);
                profile.setListUpdateTypes(list);
                hasUpdated = true;
            }
            if (uHome_Phone != null && !uHome_Phone.equals(pHome_Phone)) {
                profile.setProperty(UserProfile.BUSINESE_INFO_KEYS[6], uHome_Phone);
                List<Profile.UpdateType> list = new ArrayList<Profile.UpdateType>();
                list.add(Profile.UpdateType.CONTACT);
                profile.setListUpdateTypes(list);
                hasUpdated = true;
            }

            if (hasUpdated && !isNew) {
                IdentityManager identityManager = CommonsUtils.getService(IdentityManager.class);
                identityManager.updateProfile(profile);
            }

            if (isNew) {
                IdentityStorage identityStorage = CommonsUtils.getService(IdentityStorage.class);
                identityStorage.updateProfile(profile);
            }

        }finally{
            RequestLifeCycle.end();
        }
    }
}
