/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.ServerConfiguration;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ReminderJob
implements Job {
    private static final String CALENDAR_REMINDER = "reminders".intern();
    private static final String CALENDAR_APP = "CalendarApplication".intern();
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        ArrayList<Message> messageList = new ArrayList<Message>();
        ArrayList reminders = new ArrayList();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        try {
            MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"Calendar reminder service");
            }
            Calendar fromCalendar = GregorianCalendar.getInstance();
            fromCalendar.setLenient(false);
            int gmtoffset = fromCalendar.get(16) + fromCalendar.get(15);
            fromCalendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
            long tmpTime = fromCalendar.getTimeInMillis();
            fromCalendar.setTimeInMillis(tmpTime += 25200000L);
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            ServerConfiguration config = new ServerConfiguration();
            config.setUserName(jdatamap.getString("account"));
            config.setPassword(jdatamap.getString("password"));
            config.setSsl(true);
            config.setOutgoingHost(jdatamap.getString("outgoing"));
            config.setOutgoingPort(jdatamap.getString("port"));
            Node calendarHome = this.getPublicServiceHome();
            if (calendarHome == null) {
                return;
            }
            StringBuffer path = new StringBuffer(this.getReminderPath(fromCalendar));
            path.append("//element(*,exo:reminder)");
            path.append("[@exo:remindDateTime <= xs:dateTime('" + ISO8601.format((Calendar)fromCalendar) + "') and @exo:reminderType = 'email' and @exo:isOver = 'false']");
            QueryManager queryManager = calendarHome.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(path.toString(), "xpath");
            QueryResult results = query.execute();
            NodeIterator iter = results.getNodes();
            while (iter.hasNext()) {
                String to;
                Node reminder = iter.nextNode();
                if (!Reminder.TYPE_EMAIL.equals(reminder.getProperty("exo:reminderType").getString()) || (to = reminder.getProperty("exo:email").getString()) == null || to.length() <= 0) continue;
                Message message = new Message();
                message.setContentType(Utils.MIMETYPE_TEXTHTML);
                message.setMessageTo(to);
                message.setSubject("[reminder] eXo calendar notify mail !");
                message.setMessageBody(reminder.getProperty("exo:eventSummary").getString());
                message.setFrom(jdatamap.getString("account"));
                if (reminder.getProperty("exo:isRepeat").getBoolean()) {
                    long fromTime = reminder.getProperty("exo:fromDateTime").getDate().getTimeInMillis();
                    long remindTime = reminder.getProperty("exo:remindDateTime").getDate().getTimeInMillis();
                    long interval = reminder.getProperty("exo:repeatInterval").getLong() * 60L * 1000L;
                    if (fromCalendar.getTimeInMillis() >= fromTime) {
                        reminder.setProperty("exo:isOver", true);
                    } else if (remindTime + interval > fromTime) {
                        reminder.setProperty("exo:isOver", true);
                    } else {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeInMillis(remindTime + interval);
                        reminder.setProperty("exo:remindDateTime", (Calendar)cal);
                        reminder.setProperty("exo:isOver", false);
                    }
                } else {
                    reminder.setProperty("exo:isOver", true);
                }
                messageList.add(message);
                reminder.save();
            }
            if (!messageList.isEmpty()) {
                mailService.sendMessages(messageList, config);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (log_.isDebugEnabled()) {
            log_.debug((Object)"File plan job done");
        }
    }

    private String getReminderPath(Calendar fromCalendar) throws Exception {
        String year = "Y" + String.valueOf(fromCalendar.get(1));
        String month = "M" + String.valueOf(fromCalendar.get(2) + 1);
        String day = "D" + String.valueOf(fromCalendar.get(5));
        StringBuffer path = new StringBuffer("/jcr:root");
        path.append(this.getPublicServiceHome().getPath());
        path.append("/").append(year).append("/").append(month).append("/").append(day);
        path.append("/").append(CALENDAR_REMINDER);
        return path.toString();
    }

    private Node getPublicServiceHome() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
        Node publicApp = nodeHierarchyCreator.getPublicApplicationNode(SessionProvider.createSystemProvider());
        if (publicApp.hasNode(CALENDAR_APP)) {
            return publicApp.getNode(CALENDAR_APP);
        }
        return null;
    }
}

