/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage {
    private static final String CALENDARS = "calendars".intern();
    private static final String SHARED_CALENDAR = "sharedCalendars".intern();
    private static final String EVENTS = "events".intern();
    private static final String TASKS = "tasks".intern();
    private static final String CALENDAR_CATEGORIES = "categories".intern();
    private static final String FEED = "eXoCalendarFeed".intern();
    private static final String CALENDAR_GROUPS = "groups".intern();
    private static final String CALENDAR_REMINDER = "reminders".intern();
    private static final String CALENDAR_EVENT = "events".intern();
    private static final String CALENDAR_SETTING = "calendarSetting".intern();
    private static final String EVENT_CATEGORIES = "eventCategories".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String CALENDAR_APP = "CalendarApplication".intern();
    private static final String SHARED_MIXIN = "exo:calendarShared".intern();
    private static final String SHARED_PROP = "exo:sharedId".intern();
    private static final String VALUE = "value".intern();
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    private Node getPublicCalendarServiceHome(SessionProvider sProvider) throws Exception {
        Node publicApp = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        try {
            return publicApp.getNode(CALENDAR_APP);
        }
        catch (Exception e) {
            Node calendarApp = publicApp.addNode(CALENDAR_APP, NT_UNSTRUCTURED);
            publicApp.getSession().save();
            return calendarApp;
        }
    }

    private Node getSharedCalendarHome(SessionProvider sProvider) throws Exception {
        Node calendarServiceHome = this.getPublicCalendarServiceHome(sProvider);
        try {
            return calendarServiceHome.getNode(SHARED_CALENDAR);
        }
        catch (Exception e) {
            Node sharedCal = calendarServiceHome.addNode(SHARED_CALENDAR, NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return sharedCal;
        }
    }

    private Node getPublicRoot(SessionProvider sysProvider) throws Exception {
        return this.nodeHierarchyCreator_.getPublicApplicationNode(sysProvider);
    }

    private Node getUserCalendarServiceHome(SessionProvider sProvider, String username) throws Exception {
        Node userApp = this.nodeHierarchyCreator_.getUserApplicationNode(sProvider, username);
        try {
            return userApp.getNode(CALENDAR_APP);
        }
        catch (Exception e) {
            Node calendarRoot = userApp.addNode(CALENDAR_APP, NT_UNSTRUCTURED);
            if (!calendarRoot.hasNode(CALENDAR_SETTING)) {
                this.addCalendarSetting(calendarRoot, new CalendarSetting());
            }
            userApp.getSession().save();
            return calendarRoot;
        }
    }

    private Node getPublicCalendarHome(SessionProvider sProvider) throws Exception {
        Node calendarServiceHome = this.getPublicCalendarServiceHome(sProvider);
        try {
            return calendarServiceHome.getNode(CALENDARS);
        }
        catch (Exception e) {
            Node cal = calendarServiceHome.addNode(CALENDARS, NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return cal;
        }
    }

    private Node getUserCalendarHome(SessionProvider sProvider, String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(sProvider, username);
        try {
            return calendarServiceHome.getNode(CALENDARS);
        }
        catch (Exception e) {
            Node calendars = calendarServiceHome.addNode(CALENDARS, NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return calendars;
        }
    }

    public Node getRssHome(SessionProvider sProvider, String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(sProvider, username);
        try {
            return calendarServiceHome.getNode(FEED);
        }
        catch (Exception e) {
            Node feed = calendarServiceHome.addNode(FEED, NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return feed;
        }
    }

    protected Node getCalendarCategoryHome(SessionProvider sProvider, String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(sProvider, username);
        try {
            return calendarServiceHome.getNode(CALENDAR_CATEGORIES);
        }
        catch (Exception e) {
            Node calCat = calendarServiceHome.addNode(CALENDAR_CATEGORIES, NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return calCat;
        }
    }

    protected Node getEventCategoryHome(SessionProvider sProvider, String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(sProvider, username);
        try {
            return calendarServiceHome.getNode(EVENT_CATEGORIES);
        }
        catch (Exception e) {
            Node eventCat = calendarServiceHome.addNode(EVENT_CATEGORIES, NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return eventCat;
        }
    }

    public Calendar getUserCalendar(SessionProvider sProvider, String username, String calendarId) throws Exception {
        Node calendarNode = this.getUserCalendarHome(sProvider, username).getNode(calendarId);
        return this.getCalendar(new String[]{calendarId}, username, calendarNode, true);
    }

    public List<Calendar> getUserCalendars(SessionProvider sProvider, String username, boolean isShowAll) throws Exception {
        NodeIterator iter = this.getUserCalendarHome(sProvider, username).getNodes();
        ArrayList<Calendar> calList = new ArrayList<Calendar>();
        String[] defaultCalendars = null;
        if (this.getCalendarSetting(sProvider, username) != null) {
            defaultCalendars = this.getCalendarSetting(sProvider, username).getFilterPrivateCalendars();
        }
        while (iter.hasNext()) {
            calList.add(this.getCalendar(defaultCalendars, username, iter.nextNode(), isShowAll));
        }
        return calList;
    }

    public List<Calendar> getUserCalendarsByCategory(SessionProvider sProvider, String username, String calendarCategoryId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(sProvider, username);
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + calendarHome.getPath() + "//element(*,exo:calendar)[@exo:categoryId='").append(calendarCategoryId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        ArrayList<Calendar> calendares = new ArrayList<Calendar>();
        String[] defaultCalendars = null;
        if (this.getCalendarSetting(sProvider, username) != null) {
            defaultCalendars = this.getCalendarSetting(sProvider, username).getFilterPrivateCalendars();
        }
        while (it.hasNext()) {
            calendares.add(this.getCalendar(defaultCalendars, username, it.nextNode(), true));
        }
        return calendares;
    }

    public void saveUserCalendar(SessionProvider sProvider, String username, Calendar calendar, boolean isNew) throws Exception {
        Node calendarNode;
        Node calendarHome = this.getUserCalendarHome(sProvider, username);
        if (isNew) {
            try {
                calendarNode = calendarHome.getNode(calendar.getId());
            }
            catch (Exception e) {
                calendarNode = calendarHome.addNode(calendar.getId(), "exo:calendar");
                calendarNode.setProperty("exo:id", calendar.getId());
                if (calendar.isDataInit()) {
                    this.reparePermissions(calendarNode, username);
                }
            }
        } else {
            calendarNode = calendarHome.getNode(calendar.getId());
        }
        calendarNode.setProperty("exo:name", calendar.getName());
        calendarNode.setProperty("exo:description", calendar.getDescription());
        calendarNode.setProperty("exo:categoryId", calendar.getCategoryId());
        calendarNode.setProperty("exo:viewPermissions", calendar.getViewPermission());
        calendarNode.setProperty("exo:editPermissions", calendar.getEditPermission());
        calendarNode.setProperty("exo:groups", calendar.getGroups());
        calendarNode.setProperty("exo:locale", calendar.getLocale());
        calendarNode.setProperty("exo:timeZone", calendar.getTimeZone());
        calendarNode.setProperty("exo:calendarColor", calendar.getCalendarColor());
        calendarNode.setProperty("exo:calendarOwner", calendar.getCalendarOwner());
        calendarHome.getSession().save();
    }

    public Calendar removeUserCalendar(SessionProvider sProvider, String username, String calendarId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(sProvider, username);
        if (calendarHome.hasNode(calendarId)) {
            Node calNode = calendarHome.getNode(calendarId);
            Calendar calendar = this.getCalendar(new String[]{calendarId}, username, calNode, true);
            NodeIterator iter = calNode.getNodes();
            while (iter.hasNext()) {
                this.removeReminder(sProvider, iter.nextNode());
            }
            calNode.remove();
            calendarHome.save();
            calendarHome.getSession().save();
            return calendar;
        }
        return null;
    }

    public Calendar getGroupCalendar(SessionProvider sProvider, String calendarId) throws Exception {
        Node calendarNode = this.getPublicCalendarHome(sProvider).getNode(calendarId);
        return this.getCalendar(new String[]{calendarId}, null, calendarNode, true);
    }

    public List<GroupCalendarData> getGroupCalendars(SessionProvider sProvider, String[] groupIds, boolean isShowAll, String username) throws Exception {
        Node calendarHome = this.getPublicCalendarHome(sProvider);
        ArrayList<GroupCalendarData> groupCalendars = new ArrayList<GroupCalendarData>();
        String[] defaultCalendars = null;
        if (this.getCalendarSetting(sProvider, username) != null) {
            defaultCalendars = this.getCalendarSetting(sProvider, username).getFilterPublicCalendars();
        }
        for (String groupId : groupIds) {
            StringBuffer queryString;
            QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root" + calendarHome.getPath() + "//element(*,exo:calendar)[@exo:groups='").append(groupId).append("']")).toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            if (!it.hasNext()) continue;
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            while (it.hasNext()) {
                Node calNode = it.nextNode();
                Calendar cal = this.getCalendar(defaultCalendars, null, calNode, isShowAll);
                if (cal == null) continue;
                calendars.add(cal);
            }
            groupCalendars.add(new GroupCalendarData(groupId, groupId, calendars));
        }
        return groupCalendars;
    }

    public void savePublicCalendar(SessionProvider sProvider, Calendar calendar, boolean isNew, String username) throws Exception {
        Node calendarNode;
        Node calendarHome = this.getPublicCalendarHome(sProvider);
        if (isNew) {
            if (calendarHome.hasNode(calendar.getId())) {
                throw new Exception("This calendar is already exists");
            }
            calendarNode = calendarHome.addNode(calendar.getId(), "exo:calendar");
            calendarNode.setProperty("exo:id", calendar.getId());
            if (username != null) {
                // empty if block
            }
        } else {
            calendarNode = calendarHome.getNode(calendar.getId());
        }
        calendarNode.setProperty("exo:name", calendar.getName());
        calendarNode.setProperty("exo:description", calendar.getDescription());
        calendarNode.setProperty("exo:categoryId", calendar.getCategoryId());
        calendarNode.setProperty("exo:viewPermissions", calendar.getViewPermission());
        calendarNode.setProperty("exo:editPermissions", calendar.getEditPermission());
        calendarNode.setProperty("exo:locale", calendar.getLocale());
        calendarNode.setProperty("exo:timeZone", calendar.getTimeZone());
        calendarNode.setProperty("exo:calendarOwner", calendar.getCalendarOwner());
        calendarNode.setProperty("exo:groups", calendar.getGroups());
        calendarNode.setProperty("exo:calendarColor", calendar.getCalendarColor());
        calendarHome.getSession().save();
    }

    public Calendar removeGroupCalendar(SessionProvider sProvider, String calendarId) throws Exception {
        Node calendarHome = this.getPublicCalendarHome(sProvider);
        if (calendarHome.hasNode(calendarId)) {
            Node calNode = calendarHome.getNode(calendarId);
            Calendar calendar = this.getCalendar(new String[]{calendarId}, null, calNode, true);
            NodeIterator iter = calNode.getNodes();
            while (iter.hasNext()) {
                this.removeReminder(sProvider, iter.nextNode());
            }
            calNode.remove();
            calendarHome.getSession().save();
            return calendar;
        }
        return null;
    }

    private Calendar getCalendar(String[] defaultFilterCalendars, String username, Node calNode, boolean isShowAll) throws Exception {
        Calendar calendar = null;
        if (isShowAll) {
            calendar = new Calendar();
            if (calNode.hasProperty("exo:id")) {
                calendar.setId(calNode.getProperty("exo:id").getString());
            }
            if (calNode.hasProperty("exo:name")) {
                calendar.setName(calNode.getProperty("exo:name").getString());
            }
            if (calNode.hasProperty("exo:description")) {
                calendar.setDescription(calNode.getProperty("exo:description").getString());
            }
            if (calNode.hasProperty("exo:categoryId")) {
                calendar.setCategoryId(calNode.getProperty("exo:categoryId").getString());
            }
            if (calNode.hasProperty("exo:locale")) {
                calendar.setLocale(calNode.getProperty("exo:locale").getString());
            }
            if (calNode.hasProperty("exo:timeZone")) {
                calendar.setTimeZone(calNode.getProperty("exo:timeZone").getString());
            }
            if (calNode.hasProperty("exo:calendarColor")) {
                calendar.setCalendarColor(calNode.getProperty("exo:calendarColor").getString());
            }
            if (calNode.hasProperty("exo:calendarOwner")) {
                calendar.setCalendarOwner(calNode.getProperty("exo:calendarOwner").getString());
            }
            if (!calendar.isPublic()) {
                if (calNode.hasProperty("exo:groups")) {
                    Value[] values = calNode.getProperty("exo:groups").getValues();
                    ArrayList<String> groups = new ArrayList<String>();
                    for (Value v : values) {
                        groups.add(v.getString());
                    }
                    calendar.setGroups(groups.toArray(new String[groups.size()]));
                }
                if (calNode.hasProperty("exo:viewPermissions")) {
                    Value[] viewValues = calNode.getProperty("exo:viewPermissions").getValues();
                    ArrayList<String> viewPerms = new ArrayList<String>();
                    for (Value v : viewValues) {
                        viewPerms.add(v.getString());
                    }
                    calendar.setViewPermission(viewPerms.toArray(new String[viewPerms.size()]));
                }
                if (calNode.hasProperty("exo:editPermissions")) {
                    Value[] editValues = calNode.getProperty("exo:editPermissions").getValues();
                    ArrayList<String> editPerms = new ArrayList<String>();
                    for (Value v : editValues) {
                        editPerms.add(v.getString());
                    }
                    calendar.setEditPermission(editPerms.toArray(new String[editPerms.size()]));
                }
            }
        } else if (defaultFilterCalendars == null || !Arrays.asList(defaultFilterCalendars).contains(calNode.getName())) {
            calendar = new Calendar();
            if (calNode.hasProperty("exo:id")) {
                calendar.setId(calNode.getProperty("exo:id").getString());
            }
            if (calNode.hasProperty("exo:name")) {
                calendar.setName(calNode.getProperty("exo:name").getString());
            }
            if (calNode.hasProperty("exo:description")) {
                calendar.setDescription(calNode.getProperty("exo:description").getString());
            }
            if (calNode.hasProperty("exo:categoryId")) {
                calendar.setCategoryId(calNode.getProperty("exo:categoryId").getString());
            }
            if (calNode.hasProperty("exo:locale")) {
                calendar.setLocale(calNode.getProperty("exo:locale").getString());
            }
            if (calNode.hasProperty("exo:timeZone")) {
                calendar.setTimeZone(calNode.getProperty("exo:timeZone").getString());
            }
            if (calNode.hasProperty("exo:sharedColor")) {
                calendar.setCalendarColor(calNode.getProperty("exo:sharedColor").getString());
            }
            if (calNode.hasProperty("exo:calendarColor")) {
                calendar.setCalendarColor(calNode.getProperty("exo:calendarColor").getString());
            }
            if (calNode.hasProperty("exo:calendarOwner")) {
                calendar.setCalendarOwner(calNode.getProperty("exo:calendarOwner").getString());
            }
            if (!calendar.isPublic()) {
                if (calNode.hasProperty("exo:groups")) {
                    Value[] values = calNode.getProperty("exo:groups").getValues();
                    ArrayList<String> groups = new ArrayList<String>();
                    for (Value v : values) {
                        groups.add(v.getString());
                    }
                    calendar.setGroups(groups.toArray(new String[groups.size()]));
                }
                if (calNode.hasProperty("exo:viewPermissions")) {
                    Value[] viewValues = calNode.getProperty("exo:viewPermissions").getValues();
                    ArrayList<String> viewPerms = new ArrayList<String>();
                    for (Value v : viewValues) {
                        viewPerms.add(v.getString());
                    }
                    calendar.setViewPermission(viewPerms.toArray(new String[viewPerms.size()]));
                }
                if (calNode.hasProperty("exo:editPermissions")) {
                    Value[] editValues = calNode.getProperty("exo:editPermissions").getValues();
                    ArrayList<String> editPerms = new ArrayList<String>();
                    for (Value v : editValues) {
                        editPerms.add(v.getString());
                    }
                    calendar.setEditPermission(editPerms.toArray(new String[editPerms.size()]));
                }
            }
        }
        return calendar;
    }

    public List<GroupCalendarData> getCalendarCategories(SessionProvider sProvider, String username, boolean isShowAll) throws Exception {
        Node calendarHome = this.getUserCalendarHome(sProvider, username);
        NodeIterator iter = this.getCalendarCategoryHome(sProvider, username).getNodes();
        ArrayList<GroupCalendarData> calendarCategories = new ArrayList<GroupCalendarData>();
        calendarHome.getSession().refresh(false);
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        String[] defaultCalendars = null;
        CalendarSetting calSetting = this.getCalendarSetting(sProvider, username);
        if (calSetting != null) {
            defaultCalendars = calSetting.getFilterPrivateCalendars();
        }
        while (iter.hasNext()) {
            Node categoryNode = iter.nextNode();
            String categoryId = categoryNode.getProperty("exo:id").getString();
            StringBuffer queryString = new StringBuffer("/jcr:root" + calendarHome.getPath() + "//element(*,exo:calendar)[@exo:categoryId='").append(categoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    Calendar cal = this.getCalendar(defaultCalendars, username, it.nextNode(), isShowAll);
                    if (cal == null) continue;
                    calendars.add(cal);
                }
            }
            calendarCategories.add(new GroupCalendarData(categoryId, categoryNode.getProperty("exo:name").getString(), calendars));
        }
        return calendarCategories;
    }

    public List<CalendarCategory> getCategories(SessionProvider sProvider, String username) throws Exception {
        Node calendarCategoryHome = this.getCalendarCategoryHome(sProvider, username);
        NodeIterator iter = calendarCategoryHome.getNodes();
        ArrayList<CalendarCategory> calendarCategories = new ArrayList<CalendarCategory>();
        while (iter.hasNext()) {
            calendarCategories.add(this.getCalendarCategory(iter.nextNode()));
        }
        return calendarCategories;
    }

    public CalendarCategory getCalendarCategory(SessionProvider sProvider, String username, String calendarCategoryId) throws Exception {
        Node calendarCategoryHome = this.getCalendarCategoryHome(sProvider, username);
        return this.getCalendarCategory(calendarCategoryHome.getNode(calendarCategoryId));
    }

    public void saveCalendarCategory(SessionProvider sProvider, String username, CalendarCategory calendarCategory, boolean isNew) throws Exception {
        Node calCategoryNode;
        Node calCategoryHome = this.getCalendarCategoryHome(sProvider, username);
        if (isNew) {
            if (calCategoryHome.hasNode(calendarCategory.getId())) {
                throw new Exception("This calendar category is already exists! ");
            }
            calCategoryNode = calCategoryHome.addNode(calendarCategory.getId(), "exo:calendarCategory");
            calCategoryNode.setProperty("exo:id", calendarCategory.getId());
            if (calendarCategory.isDataInit()) {
                this.reparePermissions(calCategoryNode, username);
            }
        } else {
            calCategoryNode = calCategoryHome.getNode(calendarCategory.getId());
        }
        calCategoryNode.setProperty("exo:name", calendarCategory.getName());
        calCategoryNode.setProperty("exo:description", calendarCategory.getDescription());
        this.reparePermissions(calCategoryHome, username);
        calCategoryHome.getSession().save();
    }

    private void reparePermissions(Node node, String owner) throws Exception {
    }

    public CalendarCategory removeCalendarCategory(SessionProvider sProvider, String username, String calendarCategoryId) throws Exception {
        Node calCategoryHome = this.getCalendarCategoryHome(sProvider, username);
        Node calCategoryNode = calCategoryHome.getNode(calendarCategoryId);
        CalendarCategory calCategory = this.getCalendarCategory(calCategoryNode);
        calCategoryNode.remove();
        for (Calendar cal : this.getUserCalendarsByCategory(sProvider, username, calendarCategoryId)) {
            this.removeUserCalendar(sProvider, username, cal.getId());
        }
        calCategoryHome.save();
        calCategoryHome.getSession().save();
        return calCategory;
    }

    private CalendarCategory getCalendarCategory(Node calCategoryNode) throws Exception {
        CalendarCategory calCategory = new CalendarCategory();
        if (calCategoryNode.hasProperty("exo:id")) {
            calCategory.setId(calCategoryNode.getProperty("exo:id").getString());
        }
        if (calCategoryNode.hasProperty("exo:name")) {
            calCategory.setName(calCategoryNode.getProperty("exo:name").getString());
        }
        if (calCategoryNode.hasProperty("exo:description")) {
            calCategory.setDescription(calCategoryNode.getProperty("exo:description").getString());
        }
        return calCategory;
    }

    public List<EventCategory> getEventCategories(SessionProvider sProvider, String username) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(sProvider, username);
        NodeIterator iter = eventCategoryHome.getNodes();
        ArrayList<EventCategory> categories = new ArrayList<EventCategory>();
        while (iter.hasNext()) {
            categories.add(this.getEventCategory(iter.nextNode()));
        }
        return categories;
    }

    public void saveEventCategory(SessionProvider sProvider, String username, EventCategory eventCategory, String[] values, boolean isNew) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(sProvider, username);
        Node eventCategoryNode = null;
        String name = null;
        String description = null;
        if (isNew) {
            if (eventCategoryHome.hasNode(eventCategory.getName())) {
                return;
            }
            eventCategoryNode = eventCategoryHome.addNode(eventCategory.getName(), "exo:eventCategory");
            name = eventCategory.getName();
            description = eventCategory.getDescription();
            if (eventCategory.isDataInit()) {
                this.reparePermissions(eventCategoryNode, username);
            }
        } else {
            eventCategoryNode = eventCategoryHome.getNode(eventCategory.getName());
            if (eventCategory.getName().equals(values[0])) {
                name = eventCategory.getName();
                description = values[1];
            } else {
                if (eventCategoryHome.hasNode(values[0])) {
                    return;
                }
                eventCategoryNode.remove();
                eventCategoryHome.addNode(values[0], "exo:eventCategory");
                name = values[0];
                description = values[1];
                Node calendarHome = this.getUserCalendarHome(sProvider, username);
                QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
                NodeIterator calIter = calendarHome.getNodes();
                while (calIter.hasNext()) {
                    StringBuffer queryString = new StringBuffer("/jcr:root" + calIter.nextNode().getPath() + "//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategory.getName()).append("']");
                    Query query = qm.createQuery(queryString.toString(), "xpath");
                    QueryResult result = query.execute();
                    NodeIterator it = result.getNodes();
                    while (it.hasNext()) {
                        Node eventNode = it.nextNode();
                        eventNode.setProperty("exo:eventCategoryId", name);
                    }
                }
            }
            eventCategoryNode = eventCategoryHome.getNode(name);
        }
        eventCategoryNode.setProperty("exo:name", name);
        eventCategoryNode.setProperty("exo:description", description);
        eventCategoryHome.getSession().save();
    }

    public void removeEventCategory(SessionProvider sProvider, String username, String eventCategoryName) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(sProvider, username);
        if (eventCategoryHome.hasNode(eventCategoryName)) {
            Node eventCategoryNode = eventCategoryHome.getNode(eventCategoryName);
            for (CalendarEvent ce : this.getUserEventByCategory(sProvider, username, eventCategoryName)) {
                this.removeUserEvent(sProvider, username, ce.getCalendarId(), ce.getId());
            }
            for (CalendarEvent ce : this.getSharedEventByCategory(username, eventCategoryName)) {
                this.removeSharedEvent(SessionProvider.createSystemProvider(), username, ce.getCalendarId(), ce.getId());
            }
            for (CalendarEvent ce : this.getPublicEventByCategory(username, eventCategoryName)) {
                this.removePublicEvent(SessionProvider.createSystemProvider(), ce.getCalendarId(), ce.getId());
            }
            eventCategoryNode.remove();
            eventCategoryHome.save();
            eventCategoryHome.getSession().save();
        }
    }

    private EventCategory getEventCategory(Node eventCatNode) throws Exception {
        EventCategory eventCategory = new EventCategory();
        if (eventCatNode.hasProperty("exo:name")) {
            eventCategory.setName(eventCatNode.getProperty("exo:name").getString());
        }
        if (eventCatNode.hasProperty("exo:description")) {
            eventCategory.setDescription(eventCatNode.getProperty("exo:description").getString());
        }
        return eventCategory;
    }

    public EventCategory getEventCategory(SessionProvider sProvider, String username, String eventCategoryName) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(sProvider, username);
        return this.getEventCategory(eventCategoryHome.getNode(eventCategoryName));
    }

    public CalendarEvent getUserEvent(SessionProvider sProvider, String username, String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getUserCalendarHome(sProvider, username).getNode(calendarId);
        return this.getEvent(sProvider, calendarNode.getNode(eventId));
    }

    public List<CalendarEvent> getUserEventByCalendar(SessionProvider sProvider, String username, List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String calendarId : calendarIds) {
            Node calendarNode = this.getUserCalendarHome(sProvider, username).getNode(calendarId);
            NodeIterator it = calendarNode.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(sProvider, it.nextNode()));
            }
        }
        return events;
    }

    private List<CalendarEvent> getPublicEventByCategory(String username, String eventCategoryId) throws Exception {
        Node publicCalendarHome = this.getPublicCalendarHome(SessionProvider.createSystemProvider());
        QueryManager qm = publicCalendarHome.getSession().getWorkspace().getQueryManager();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        NodeIterator calIter = publicCalendarHome.getNodes();
        while (calIter.hasNext()) {
            StringBuffer queryString = new StringBuffer("/jcr:root" + calIter.nextNode().getPath() + "//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(SessionProvider.createSystemProvider(), it.nextNode()));
            }
        }
        return events;
    }

    private List<CalendarEvent> getSharedEventByCategory(String username, String eventCategoryId) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome(SessionProvider.createSystemProvider());
        QueryManager qm = sharedCalendarHome.getSession().getWorkspace().getQueryManager();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        NodeIterator calIter = sharedCalendarHome.getNodes();
        while (calIter.hasNext()) {
            StringBuffer queryString = new StringBuffer("/jcr:root" + calIter.nextNode().getPath() + "//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(SessionProvider.createSystemProvider(), it.nextNode()));
            }
        }
        return events;
    }

    public List<CalendarEvent> getUserEventByCategory(SessionProvider sProvider, String username, String eventCategoryId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(sProvider, username);
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        NodeIterator calIter = calendarHome.getNodes();
        while (calIter.hasNext()) {
            StringBuffer queryString = new StringBuffer("/jcr:root" + calIter.nextNode().getPath() + "//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(sProvider, it.nextNode()));
            }
        }
        return events;
    }

    public List<CalendarEvent> getUserEvents(SessionProvider sProvider, String username, EventQuery eventQuery) throws Exception {
        Node calendarHome = this.getUserCalendarHome(sProvider, username);
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        eventQuery.setCalendarPath(calendarHome.getPath());
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            CalendarEvent calEvent = this.getEvent(sProvider, it.nextNode());
            calEvent.setCalType("0");
            events.add(calEvent);
        }
        return events;
    }

    public void saveUserEvent(SessionProvider sProvider, String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node calendarNode = this.getUserCalendarHome(sProvider, username).getNode(calendarId);
        if (event.getReminders() != null && event.getReminders().size() > 0) {
            Node reminderFolder = this.getReminderFolder(SessionProvider.createSystemProvider(), event.getFromDateTime());
            this.saveEvent(calendarNode, event, reminderFolder, isNew);
        } else {
            this.saveEvent(calendarNode, event, null, isNew);
        }
    }

    public CalendarEvent removeUserEvent(SessionProvider sProvider, String username, String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getUserCalendarHome(sProvider, username).getNode(calendarId);
        if (calendarNode.hasNode(eventId)) {
            Node eventNode = calendarNode.getNode(eventId);
            CalendarEvent event = this.getEvent(sProvider, eventNode);
            this.removeReminder(sProvider, eventNode);
            eventNode.remove();
            calendarNode.save();
            calendarNode.getSession().save();
            calendarNode.refresh(true);
            Node eventFolder = this.getEventFolder(SessionProvider.createSystemProvider(), event.getFromDateTime());
            this.syncRemoveEvent(eventFolder, eventId);
            return event;
        }
        return null;
    }

    private void removeReminder(SessionProvider sProvider, Node eventNode) throws Exception {
        if (eventNode.hasProperty("exo:fromDateTime")) {
            Node events;
            Node reminders = this.getReminderFolder(SessionProvider.createSystemProvider(), eventNode.getProperty("exo:fromDateTime").getDate().getTime());
            if (reminders.hasNode(eventNode.getName())) {
                reminders.getNode(eventNode.getName()).remove();
            }
            if ((events = reminders.getParent().getNode(CALENDAR_REMINDER)) != null && events.hasNode(eventNode.getName())) {
                events.getNode(eventNode.getName()).remove();
            }
            if (!reminders.isNew()) {
                reminders.save();
            }
        }
    }

    public CalendarEvent getGroupEvent(SessionProvider sProvider, String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getPublicCalendarHome(sProvider).getNode(calendarId);
        CalendarEvent calEvent = this.getEvent(sProvider, calendarNode.getNode(eventId));
        calEvent.setCalType("2");
        return calEvent;
    }

    public List<CalendarEvent> getGroupEventByCalendar(SessionProvider sProvider, List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String calendarId : calendarIds) {
            Node calendarNode = this.getPublicCalendarHome(sProvider).getNode(calendarId);
            NodeIterator it = calendarNode.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(sProvider, it.nextNode()));
            }
        }
        return events;
    }

    public List<CalendarEvent> getPublicEvents(SessionProvider sProvider, EventQuery eventQuery) throws Exception {
        Node calendarHome = this.getPublicCalendarHome(sProvider);
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        eventQuery.setCalendarPath(calendarHome.getPath());
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            CalendarEvent calEvent = this.getEvent(sProvider, it.nextNode());
            calEvent.setCalType("2");
            events.add(calEvent);
        }
        return events;
    }

    public void savePublicEvent(SessionProvider sProvider, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node calendarNode = this.getPublicCalendarHome(sProvider).getNode(calendarId);
        Node reminderFolder = this.getReminderFolder(sProvider, event.getFromDateTime());
        this.saveEvent(calendarNode, event, reminderFolder, isNew);
    }

    public CalendarEvent removePublicEvent(SessionProvider sProvider, String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getPublicCalendarHome(sProvider).getNode(calendarId);
        if (calendarNode.hasNode(eventId)) {
            Node eventNode = calendarNode.getNode(eventId);
            CalendarEvent event = this.getEvent(sProvider, eventNode);
            this.removeReminder(sProvider, eventNode);
            eventNode.remove();
            calendarNode.save();
            calendarNode.getSession().save();
            calendarNode.refresh(true);
            Node eventFolder = this.getEventFolder(SessionProvider.createSystemProvider(), event.getFromDateTime());
            this.syncRemoveEvent(eventFolder, eventId);
            return event;
        }
        return null;
    }

    private CalendarEvent getEvent(SessionProvider sProvider, Node eventNode) throws Exception {
        int i;
        Value[] values;
        CalendarEvent event = new CalendarEvent();
        if (eventNode.hasProperty("exo:id")) {
            event.setId(eventNode.getProperty("exo:id").getString());
        }
        if (eventNode.hasProperty("exo:calendarId")) {
            event.setCalendarId(eventNode.getProperty("exo:calendarId").getString());
        }
        if (eventNode.hasProperty("exo:summary")) {
            event.setSummary(eventNode.getProperty("exo:summary").getString());
        }
        if (eventNode.hasProperty("exo:eventCategoryId")) {
            event.setEventCategoryId(eventNode.getProperty("exo:eventCategoryId").getString());
        }
        if (eventNode.hasProperty("exo:location")) {
            event.setLocation(eventNode.getProperty("exo:location").getString());
        }
        if (eventNode.hasProperty("exo:taskDelegator")) {
            event.setTaskDelegator(eventNode.getProperty("exo:taskDelegator").getString());
        }
        if (eventNode.hasProperty("exo:repeat")) {
            event.setRepeatType(eventNode.getProperty("exo:repeat").getString());
        }
        if (eventNode.hasProperty("exo:description")) {
            event.setDescription(eventNode.getProperty("exo:description").getString());
        }
        if (eventNode.hasProperty("exo:fromDateTime")) {
            event.setFromDateTime(eventNode.getProperty("exo:fromDateTime").getDate().getTime());
        }
        if (eventNode.hasProperty("exo:toDateTime")) {
            event.setToDateTime(eventNode.getProperty("exo:toDateTime").getDate().getTime());
        }
        if (eventNode.hasProperty("exo:eventType")) {
            event.setEventType(eventNode.getProperty("exo:eventType").getString());
        }
        if (eventNode.hasProperty("exo:priority")) {
            event.setPriority(eventNode.getProperty("exo:priority").getString());
        }
        if (eventNode.hasProperty("exo:isPrivate")) {
            event.setPrivate(eventNode.getProperty("exo:isPrivate").getBoolean());
        }
        if (eventNode.hasProperty("exo:eventState")) {
            event.setEventState(eventNode.getProperty("exo:eventState").getString());
        }
        event.setReminders(this.getReminders(SessionProvider.createSystemProvider(), eventNode));
        event.setAttachment(this.getAttachments(eventNode));
        if (eventNode.hasProperty("exo:invitation")) {
            values = eventNode.getProperty("exo:invitation").getValues();
            if (values.length == 1) {
                event.setInvitation(new String[]{values[0].getString()});
            } else {
                String[] invites = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    invites[i] = values[i].getString();
                }
                event.setInvitation(invites);
            }
        }
        if (eventNode.hasProperty("exo:participant")) {
            values = eventNode.getProperty("exo:participant").getValues();
            if (values.length == 1) {
                event.setParticipant(new String[]{values[0].getString()});
            } else {
                String[] participant = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    participant[i] = values[i].getString();
                }
                event.setParticipant(participant);
            }
        }
        return event;
    }

    private void saveEvent(Node calendarNode, CalendarEvent event, Node reminderFolder, boolean isNew) throws Exception {
        List<Attachment> attachments;
        Node eventNode;
        if (isNew) {
            eventNode = calendarNode.addNode(event.getId(), "exo:calendarEvent");
            eventNode.setProperty("exo:id", event.getId());
        } else {
            try {
                eventNode = calendarNode.getNode(event.getId());
            }
            catch (Exception e) {
                CalendarEvent tempEvent = new CalendarEvent();
                eventNode = calendarNode.addNode(tempEvent.getId(), "exo:calendarEvent");
                eventNode.setProperty("exo:id", tempEvent.getId());
            }
            this.removeReminder(SessionProvider.createSystemProvider(), eventNode);
        }
        eventNode.setProperty("exo:summary", event.getSummary());
        eventNode.setProperty("exo:calendarId", event.getCalendarId());
        eventNode.setProperty("exo:eventCategoryId", event.getEventCategoryId());
        eventNode.setProperty("exo:description", event.getDescription());
        eventNode.setProperty("exo:location", event.getLocation());
        eventNode.setProperty("exo:taskDelegator", event.getTaskDelegator());
        GregorianCalendar dateTime = Utils.getInstanceTempCalendar();
        dateTime.setTime(event.getFromDateTime());
        eventNode.setProperty("exo:fromDateTime", (java.util.Calendar)dateTime);
        dateTime.setTime(event.getToDateTime());
        eventNode.setProperty("exo:toDateTime", (java.util.Calendar)dateTime);
        eventNode.setProperty("exo:eventType", event.getEventType());
        eventNode.setProperty("exo:repeat", event.getRepeatType());
        eventNode.setProperty("exo:priority", event.getPriority());
        eventNode.setProperty("exo:isPrivate", event.isPrivate());
        eventNode.setProperty("exo:eventState", event.getEventState());
        eventNode.setProperty("exo:invitation", event.getInvitation());
        eventNode.setProperty("exo:participant", event.getParticipant());
        List<Reminder> reminders = event.getReminders();
        if (reminders != null && !reminders.isEmpty()) {
            for (Reminder rm : reminders) {
                this.addReminder(eventNode, reminderFolder, rm);
            }
        }
        if (eventNode.hasNode(Utils.ATTACHMENT_NODE)) {
            while (eventNode.getNodes().hasNext()) {
                eventNode.getNodes().nextNode().remove();
            }
        }
        if ((attachments = event.getAttachment()) != null) {
            for (Attachment att : attachments) {
                this.addAttachment(eventNode, att, isNew);
            }
        }
        calendarNode.save();
        this.addEvent(event);
    }

    private void addReminder(Node eventNode, Node reminderFolder, Reminder reminder) throws Exception {
        Node reminderNode;
        Node catNode;
        try {
            catNode = reminderFolder.getNode(eventNode.getName());
        }
        catch (Exception e) {
            catNode = reminderFolder.addNode(eventNode.getName(), Utils.NT_UNSTRUCTURED);
        }
        try {
            reminderNode = catNode.getNode(reminder.getId());
        }
        catch (Exception e) {
            reminderNode = catNode.addNode(reminder.getId(), "exo:reminder");
        }
        reminderNode.setProperty("exo:eventId", eventNode.getName());
        reminderNode.setProperty("exo:alarmBefore", reminder.getAlarmBefore());
        reminderNode.setProperty("exo:repeatInterval", reminder.getRepeatInterval());
        reminderNode.setProperty("exo:reminderType", reminder.getReminderType());
        reminderNode.setProperty("exo:email", reminder.getEmailAddress());
        reminderNode.setProperty("exo:isRepeat", reminder.isRepeat());
        reminderNode.setProperty("exo:isOver", false);
        GregorianCalendar cal = new GregorianCalendar();
        if (reminder.getFromDateTime() != null) {
            cal.setTime(reminder.getFromDateTime());
            reminderNode.setProperty("exo:fromDateTime", (java.util.Calendar)cal);
            long time = reminder.getFromDateTime().getTime() - reminder.getAlarmBefore() * 60L * 1000L;
            cal = new GregorianCalendar();
            cal.setTimeInMillis(time);
            reminderNode.setProperty("exo:remindDateTime", (java.util.Calendar)cal);
        }
        StringBuffer summary = new StringBuffer("Event      : ");
        summary.append(eventNode.getProperty("exo:summary").getString()).append("<br>");
        summary.append("Description: ");
        if (eventNode.hasProperty("exo:description")) {
            summary.append(eventNode.getProperty("exo:description").getString());
        }
        summary.append("<br>");
        summary.append("Location   : ");
        if (eventNode.hasProperty("exo:location")) {
            summary.append(eventNode.getProperty("exo:location").getString());
        }
        summary.append("<br>");
        cal.setTime(eventNode.getProperty("exo:fromDateTime").getDate().getTime());
        summary.append("From       : ").append(cal.get(11)).append(":");
        summary.append(cal.get(12)).append(" - ");
        summary.append(cal.get(5)).append("/");
        summary.append(cal.get(2) + 1).append("/");
        summary.append(cal.get(1)).append("<br>");
        cal.setTime(eventNode.getProperty("exo:toDateTime").getDate().getTime());
        summary.append("To         : ").append(cal.get(11)).append(":");
        summary.append(cal.get(12)).append(" - ");
        summary.append(cal.get(5)).append("/");
        summary.append(cal.get(2) + 1).append("/");
        summary.append(cal.get(1)).append("<br>");
        reminderNode.setProperty("exo:eventSummary", summary.toString());
        if (!reminderFolder.isNew()) {
            reminderFolder.save();
        } else {
            reminderFolder.getSession().save();
        }
    }

    private void addEvent(CalendarEvent event) throws Exception {
        Node eventFolder = this.getEventFolder(SessionProvider.createSystemProvider(), event.getFromDateTime());
        this.syncRemoveEvent(eventFolder, event.getId());
        CalendarEvent ev = new CalendarEvent();
        Node publicEvent = eventFolder.addNode(ev.getId(), "exo:calendarPublicEvent");
        publicEvent.setProperty("exo:id", ev.getId());
        publicEvent.setProperty("exo:rootEventId", event.getId());
        publicEvent.setProperty("exo:eventType", event.getEventType());
        publicEvent.setProperty("exo:calendarId", event.getCalendarId());
        GregorianCalendar dateTime = Utils.getInstanceTempCalendar();
        dateTime.setTime(event.getFromDateTime());
        int fromDate = dateTime.get(5);
        publicEvent.setProperty("exo:fromDateTime", (java.util.Calendar)dateTime);
        publicEvent.setProperty("exo:eventState", event.getEventState());
        dateTime.setTime(event.getToDateTime());
        int toDate = dateTime.get(5);
        if (toDate > fromDate) {
            GregorianCalendar tmpTime = Utils.getInstanceTempCalendar();
            tmpTime.setTime(event.getFromDateTime());
            tmpTime.set(11, 0);
            tmpTime.set(12, 0);
            tmpTime.set(13, 0);
            tmpTime.set(14, 0);
            tmpTime.setTimeInMillis(tmpTime.getTimeInMillis() + 86400000L - 1000L);
            publicEvent.setProperty("exo:toDateTime", (java.util.Calendar)tmpTime);
        } else {
            publicEvent.setProperty("exo:toDateTime", (java.util.Calendar)dateTime);
        }
        publicEvent.setProperty("exo:participant", event.getParticipant());
        try {
            if (!eventFolder.isNew()) {
                eventFolder.save();
            } else {
                eventFolder.getSession().save();
            }
        }
        catch (Exception e) {
            eventFolder.getSession().refresh(true);
            eventFolder.getSession().save();
        }
        if (toDate > fromDate) {
            GregorianCalendar cal = Utils.getInstanceTempCalendar();
            cal.setTime(event.getFromDateTime());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            for (int i = fromDate + 1; i <= toDate; ++i) {
                ((java.util.Calendar)cal).roll(5, true);
                Node dateFolder = this.getEventFolder(SessionProvider.createSystemProvider(), cal.getTime());
                ev = new CalendarEvent();
                eventFolder.getSession().getWorkspace().copy(publicEvent.getPath(), dateFolder.getPath() + "/" + ev.getId());
                dateFolder.getSession().save();
                if (i > toDate) continue;
                Node newEvent = dateFolder.getNode(ev.getId());
                newEvent.setProperty("exo:id", ev.getId());
                newEvent.setProperty("exo:fromDateTime", (java.util.Calendar)cal);
                GregorianCalendar tmpCal = Utils.getInstanceTempCalendar();
                if (i == toDate) {
                    tmpCal.setTime(event.getToDateTime());
                } else {
                    tmpCal.setTimeInMillis(cal.getTimeInMillis() + 86400000L - 1000L);
                }
                newEvent.setProperty("exo:toDateTime", (java.util.Calendar)tmpCal);
                newEvent.save();
            }
        }
    }

    private void syncRemoveEvent(Node eventFolder, String rootEventId) throws Exception {
        StringBuffer queryString;
        QueryManager qm = eventFolder.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root" + eventFolder.getParent().getParent().getParent().getPath() + "//element(*,exo:calendarPublicEvent)[@exo:rootEventId='").append(rootEventId).append("']")).toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        if (it.getSize() > 0L) {
            while (it.hasNext()) {
                it.nextNode().remove();
            }
            eventFolder.getSession().save();
        }
    }

    private Node getReminderFolder(SessionProvider sysProvider, Date fromDate) throws Exception {
        Node publicApp = this.getPublicCalendarServiceHome(sysProvider);
        Node dateFolder = this.getDateFolder(publicApp, fromDate);
        try {
            return dateFolder.getNode(CALENDAR_REMINDER);
        }
        catch (Exception e) {
            dateFolder.addNode(CALENDAR_REMINDER, NT_UNSTRUCTURED);
            this.getPublicRoot(sysProvider).getSession().save();
            return dateFolder.getNode(CALENDAR_REMINDER);
        }
    }

    private Node getEventFolder(SessionProvider sysProvider, Date fromDate) throws Exception {
        Node publicApp = this.getPublicCalendarServiceHome(sysProvider);
        Node dateFolder = this.getDateFolder(publicApp, fromDate);
        try {
            return dateFolder.getNode(CALENDAR_EVENT);
        }
        catch (Exception e) {
            dateFolder.addNode(CALENDAR_EVENT, NT_UNSTRUCTURED);
            this.getPublicRoot(sysProvider).getSession().save();
            return dateFolder.getNode(CALENDAR_EVENT);
        }
    }

    private Node getDateFolder(Node publicApp, Date date) throws Exception {
        Node monthNode;
        Node yearNode;
        GregorianCalendar fromCalendar = new GregorianCalendar();
        fromCalendar.setTime(date);
        String year = "Y" + String.valueOf(fromCalendar.get(1));
        String month = "M" + String.valueOf(fromCalendar.get(2) + 1);
        String day = "D" + String.valueOf(fromCalendar.get(5));
        try {
            yearNode = publicApp.getNode(year);
        }
        catch (Exception e) {
            yearNode = publicApp.addNode(year, NT_UNSTRUCTURED);
        }
        try {
            monthNode = yearNode.getNode(month);
        }
        catch (Exception e) {
            monthNode = yearNode.addNode(month, NT_UNSTRUCTURED);
        }
        try {
            return monthNode.getNode(day);
        }
        catch (Exception e) {
            return monthNode.addNode(day, NT_UNSTRUCTURED);
        }
    }

    private List<Reminder> getReminders(SessionProvider sProvider, Node eventNode) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        Date fromDate = eventNode.getProperty("exo:fromDateTime").getDate().getTime();
        Node reminderFolder = this.getReminderFolder(sProvider, fromDate);
        if (reminderFolder.hasNode(eventNode.getName())) {
            NodeIterator iter = reminderFolder.getNode(eventNode.getName()).getNodes();
            while (iter.hasNext()) {
                Node reminderNode = iter.nextNode();
                if (!reminderNode.isNodeType("exo:reminder")) continue;
                Reminder reminder = new Reminder();
                reminder.setId(reminderNode.getName());
                if (reminderNode.hasProperty("exo:eventId")) {
                    reminder.setEventId(reminderNode.getProperty("exo:eventId").getString());
                }
                if (reminderNode.hasProperty("exo:reminderType")) {
                    reminder.setReminderType(reminderNode.getProperty("exo:reminderType").getString());
                }
                if (reminderNode.hasProperty("exo:alarmBefore")) {
                    reminder.setAlarmBefore(reminderNode.getProperty("exo:alarmBefore").getLong());
                }
                if (reminderNode.hasProperty("exo:email")) {
                    reminder.setEmailAddress(reminderNode.getProperty("exo:email").getString());
                }
                if (reminderNode.hasProperty("exo:isRepeat")) {
                    reminder.setRepeate(reminderNode.getProperty("exo:isRepeat").getBoolean());
                }
                if (reminderNode.hasProperty("exo:repeatInterval")) {
                    reminder.setRepeatInterval(reminderNode.getProperty("exo:repeatInterval").getLong());
                }
                reminder.setFromDateTime(fromDate);
                reminders.add(reminder);
            }
        }
        return reminders;
    }

    private void addAttachment(Node eventNode, Attachment attachment, boolean isNew) throws Exception {
        Node attachNode;
        Node attachHome;
        try {
            attachHome = eventNode.getNode(Utils.ATTACHMENT_NODE);
        }
        catch (Exception e) {
            attachHome = eventNode.addNode(Utils.ATTACHMENT_NODE, Utils.NT_UNSTRUCTURED);
        }
        String name = attachment.getId();
        if (!isNew) {
            name = name.substring(attachment.getId().lastIndexOf("/") + 1);
        }
        try {
            attachNode = attachHome.getNode(name);
        }
        catch (Exception e) {
            attachNode = attachHome.addNode(name, Utils.EXO_EVEN_TATTACHMENT);
        }
        attachNode.setProperty(Utils.EXO_FILE_NAME, attachment.getName());
        Node nodeContent = null;
        try {
            nodeContent = attachNode.getNode(Utils.JCR_CONTENT);
        }
        catch (Exception e) {
            nodeContent = attachNode.addNode(Utils.JCR_CONTENT, Utils.NT_RESOURCE);
        }
        nodeContent.setProperty(Utils.JCR_LASTMODIFIED, java.util.Calendar.getInstance().getTimeInMillis());
        nodeContent.setProperty(Utils.JCR_MIMETYPE, attachment.getMimeType());
        nodeContent.setProperty(Utils.JCR_DATA, attachment.getInputStream());
    }

    private List<Attachment> getAttachments(Node eventNode) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (eventNode.hasNode(Utils.ATTACHMENT_NODE)) {
            Node attachHome = eventNode.getNode(Utils.ATTACHMENT_NODE);
            NodeIterator iter = attachHome.getNodes();
            while (iter.hasNext()) {
                Node contentNode;
                Node attchmentNode = iter.nextNode();
                if (!attchmentNode.isNodeType(Utils.EXO_EVEN_TATTACHMENT)) continue;
                Attachment attachment = new Attachment();
                attachment.setId(attchmentNode.getPath());
                if (attchmentNode.hasProperty(Utils.EXO_FILE_NAME)) {
                    attachment.setName(attchmentNode.getProperty(Utils.EXO_FILE_NAME).getString());
                }
                if ((contentNode = attchmentNode.getNode(Utils.JCR_CONTENT)) != null) {
                    if (contentNode.hasProperty(Utils.JCR_LASTMODIFIED)) {
                        attachment.setLastModified(contentNode.getProperty(Utils.JCR_LASTMODIFIED).getDate());
                    }
                    if (contentNode.hasProperty(Utils.JCR_MIMETYPE)) {
                        attachment.setMimeType(contentNode.getProperty(Utils.JCR_MIMETYPE).getString());
                    }
                    if (contentNode.hasProperty(Utils.JCR_DATA)) {
                        InputStream inputStream = contentNode.getProperty(Utils.JCR_DATA).getStream();
                        attachment.setSize(inputStream.available());
                    }
                }
                attachment.setWorkspace(attchmentNode.getSession().getWorkspace().getName());
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    public void saveCalendarSetting(SessionProvider sProvider, String username, CalendarSetting setting) throws Exception {
        Node calendarHome = this.getUserCalendarServiceHome(sProvider, username);
        this.addCalendarSetting(calendarHome, setting);
        calendarHome.save();
    }

    private void addCalendarSetting(Node calendarHome, CalendarSetting setting) throws Exception {
        Node settingNode;
        try {
            settingNode = calendarHome.getNode(CALENDAR_SETTING);
        }
        catch (Exception e) {
            settingNode = calendarHome.addNode(CALENDAR_SETTING, "exo:calendarSetting");
        }
        settingNode.setProperty("exo:viewType", setting.getViewType());
        settingNode.setProperty("exo:timeInterval", setting.getTimeInterval());
        settingNode.setProperty("exo:weekStartOn", setting.getWeekStartOn());
        settingNode.setProperty("exo:dateFormat", setting.getDateFormat());
        settingNode.setProperty("exo:timeFormat", setting.getTimeFormat());
        settingNode.setProperty("exo:location", setting.getLocation());
        settingNode.setProperty("exo:timeZone", setting.getTimeZone());
        settingNode.setProperty("exo:showWorkingTime", setting.isShowWorkingTime());
        if (setting.isShowWorkingTime()) {
            settingNode.setProperty("exo:workingTimeBegin", setting.getWorkingTimeBegin());
            settingNode.setProperty("exo:workingTimeEnd", setting.getWorkingTimeEnd());
        }
        settingNode.setProperty("exo:baseURL", setting.getBaseURL());
        settingNode.setProperty("exo:defaultPrivateCalendars", setting.getFilterPrivateCalendars());
        settingNode.setProperty("exo:defaultPublicCalendars", setting.getFilterPublicCalendars());
        settingNode.setProperty("exo:defaultSharedCalendars", setting.getFilterSharedCalendars());
        settingNode.setProperty("exo:sharedCalendarsColors", setting.getSharedCalendarsColors());
    }

    public CalendarSetting getCalendarSetting(SessionProvider sProvider, String username) throws Exception {
        Node calendarHome = this.getUserCalendarServiceHome(sProvider, username);
        if (calendarHome.hasNode(CALENDAR_SETTING)) {
            int i;
            String[] calendars;
            Value[] values;
            CalendarSetting calendarSetting = new CalendarSetting();
            Node settingNode = calendarHome.getNode(CALENDAR_SETTING);
            calendarSetting.setViewType(settingNode.getProperty("exo:viewType").getString());
            calendarSetting.setTimeInterval(settingNode.getProperty("exo:timeInterval").getLong());
            calendarSetting.setWeekStartOn(settingNode.getProperty("exo:weekStartOn").getString());
            calendarSetting.setDateFormat(settingNode.getProperty("exo:dateFormat").getString());
            calendarSetting.setTimeFormat(settingNode.getProperty("exo:timeFormat").getString());
            if (settingNode.hasProperty("exo:baseURL")) {
                calendarSetting.setBaseURL(settingNode.getProperty("exo:baseURL").getString());
            }
            if (settingNode.hasProperty("exo:location")) {
                calendarSetting.setLocation(settingNode.getProperty("exo:location").getString());
            }
            if (settingNode.hasProperty("exo:timeZone")) {
                calendarSetting.setTimeZone(settingNode.getProperty("exo:timeZone").getString());
            }
            if (settingNode.hasProperty("exo:showWorkingTime")) {
                calendarSetting.setShowWorkingTime(settingNode.getProperty("exo:showWorkingTime").getBoolean());
            }
            if (calendarSetting.isShowWorkingTime()) {
                if (settingNode.hasProperty("exo:workingTimeBegin")) {
                    calendarSetting.setWorkingTimeBegin(settingNode.getProperty("exo:workingTimeBegin").getString());
                }
                if (settingNode.hasProperty("exo:workingTimeEnd")) {
                    calendarSetting.setWorkingTimeEnd(settingNode.getProperty("exo:workingTimeEnd").getString());
                }
            }
            if (settingNode.hasProperty("exo:defaultPrivateCalendars")) {
                values = settingNode.getProperty("exo:defaultPrivateCalendars").getValues();
                calendars = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendars[i] = values[i].getString();
                }
                calendarSetting.setFilterPrivateCalendars(calendars);
            }
            if (settingNode.hasProperty("exo:defaultPublicCalendars")) {
                values = settingNode.getProperty("exo:defaultPublicCalendars").getValues();
                calendars = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendars[i] = values[i].getString();
                }
                calendarSetting.setFilterPublicCalendars(calendars);
            }
            if (settingNode.hasProperty("exo:defaultSharedCalendars")) {
                values = settingNode.getProperty("exo:defaultSharedCalendars").getValues();
                calendars = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendars[i] = values[i].getString();
                }
                calendarSetting.setFilterSharedCalendars(calendars);
            }
            if (settingNode.hasProperty("exo:sharedCalendarsColors")) {
                values = settingNode.getProperty("exo:sharedCalendarsColors").getValues();
                String[] calendarsColors = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendarsColors[i] = values[i].getString();
                }
                calendarSetting.setSharedCalendarsColors(calendarsColors);
            }
            return calendarSetting;
        }
        return null;
    }

    public List<FeedData> getFeeds(SessionProvider sProvider, String username) throws Exception {
        ArrayList<FeedData> feeds = new ArrayList<FeedData>();
        Node rssHome = this.getRssHome(sProvider, username);
        NodeIterator iter = rssHome.getNodes();
        while (iter.hasNext()) {
            Node feedNode = iter.nextNode();
            if (!feedNode.isNodeType("exo:rssData")) continue;
            FeedData feed = new FeedData();
            feed.setTitle(feedNode.getProperty("exo:title").getString());
            StringBuffer url = new StringBuffer(feedNode.getProperty("exo:baseUrl").getString());
            url.append("/").append(PortalContainer.getInstance().getPortalContainerInfo().getContainerName());
            url.append("/").append(feedNode.getSession().getWorkspace().getName());
            url.append("/").append(username);
            url.append("/").append(feedNode.getName());
            feed.setUrl(url.toString());
            feeds.add(feed);
        }
        return feeds;
    }

    public int generateRss(SessionProvider sProvider, String username, List<String> calendarIds, RssData rssData, CalendarImportExport importExport) throws Exception {
        Node rssHomeNode = this.getRssHome(sProvider, username);
        Node iCalHome = null;
        try {
            iCalHome = rssHomeNode.getNode("iCalendars");
        }
        catch (Exception e) {
            iCalHome = rssHomeNode.addNode("iCalendars", NT_UNSTRUCTURED);
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssData.getVersion());
            feed.setTitle(rssData.getTitle());
            feed.setLink(rssData.getLink());
            feed.setDescription(rssData.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
            String portalName = containerInfo.getContainerName();
            ArrayList<String> ids = new ArrayList<String>();
            for (String calendarId : calendarIds) {
                ids.clear();
                ids.add(calendarId);
                OutputStream out = importExport.exportCalendar(sProvider, username, ids, "0");
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                try {
                    iCalHome.getNode(calendarId + ".ics").setProperty("exo:data", (InputStream)is);
                }
                catch (Exception e) {
                    Node ical = iCalHome.addNode(calendarId + ".ics", "exo:iCalData");
                    ical.setProperty("exo:data", (InputStream)is);
                }
                StringBuffer path = new StringBuffer("/");
                path.append(iCalHome.getName()).append("/").append(iCalHome.getNode(calendarId + ".ics").getName());
                String url = this.getEntryUrl(portalName, rssHomeNode.getSession().getWorkspace().getName(), username, path.toString(), rssData.getUrl());
                Calendar exoCal = this.getUserCalendar(sProvider, username, calendarId);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(exoCal.getName());
                entry.setLink(url);
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue(exoCal.getDescription());
                entry.setDescription((SyndContent)description);
                entries.add(entry);
                entry.getEnclosures();
            }
            if (entries.isEmpty()) {
                System.out.println("No data to make rss!");
                return -1;
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, rssHomeNode, rssData.getName(), rssData);
            rssHomeNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 1;
    }

    public int generateCalDav(SessionProvider sProvider, String username, List<String> calendarIds, RssData rssData, CalendarImportExport importExport) throws Exception {
        Node rssHomeNode = this.getRssHome(sProvider, username);
        Node WebDaveiCalHome = null;
        try {
            WebDaveiCalHome = rssHomeNode.getNode("WebDavCalendars");
        }
        catch (Exception e) {
            WebDaveiCalHome = rssHomeNode.addNode("WebDavCalendars", NT_UNSTRUCTURED);
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssData.getVersion());
            feed.setTitle(rssData.getTitle());
            feed.setLink(rssData.getLink());
            feed.setDescription(rssData.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            ArrayList<String> ids = new ArrayList<String>();
            for (String calendarId : calendarIds) {
                ids.clear();
                ids.add(calendarId);
                OutputStream out = importExport.exportCalendar(sProvider, username, ids, "0");
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                try {
                    WebDaveiCalHome.getNode(calendarId + ".ics").setProperty("exo:data", (InputStream)is);
                }
                catch (Exception e) {
                    Node ical = WebDaveiCalHome.addNode(calendarId + ".ics", "exo:iCalData");
                    ical.setProperty("exo:data", (InputStream)is);
                }
                String link = rssData.getLink() + WebDaveiCalHome.getPath() + "/" + calendarId + ".ics";
                Calendar exoCal = this.getUserCalendar(sProvider, username, calendarId);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(exoCal.getName());
                entry.setLink(link);
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue(exoCal.getDescription());
                entry.setDescription((SyndContent)description);
                entries.add(entry);
                entry.getEnclosures();
            }
            if (entries.isEmpty()) {
                System.out.println("No data to make caldav!");
                return -1;
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, rssHomeNode, rssData.getName(), rssData);
            rssHomeNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 1;
    }

    private void storeXML(String feedXML, Node rssHome, String rssNodeName, RssData rssData) throws Exception {
        Node rss = rssHome.hasNode(rssNodeName) ? rssHome.getNode(rssNodeName) : rssHome.addNode(rssNodeName, "exo:rssData");
        rss.setProperty("exo:baseUrl", rssData.getUrl());
        rss.setProperty("exo:title", rssData.getTitle());
        rss.setProperty("exo:content", (InputStream)new ByteArrayInputStream(feedXML.getBytes()));
    }

    private String getEntryUrl(String portalName, String wsName, String username, String path, String baseUrl) throws Exception {
        StringBuilder url = new StringBuilder(baseUrl);
        url.append("/").append(portalName).append("/").append(wsName).append("/").append(username).append(path);
        return url.toString();
    }

    public EventPageList searchEvent(SessionProvider sProvider, String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        events.addAll(this.getUserEvents(sProvider, username, eventQuery));
        events.addAll(this.getPublicEvents(SessionProvider.createSystemProvider(), eventQuery));
        events.addAll(this.getSharedEvents(SessionProvider.createSystemProvider(), username, eventQuery));
        return new EventPageList(events, 10L);
    }

    public Map<Integer, String> searchHightLightEvent(SessionProvider sProvider, String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        NodeIterator it;
        Query query;
        QueryManager qm;
        Map<Integer, String> mapData = new HashMap<Integer, String>();
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        CalendarSetting calSetting = this.getCalendarSetting(sProvider, username);
        if (username != null && username.length() > 0) {
            Node calendarHome = this.getUserCalendarHome(sProvider, username);
            eventQuery.setCalendarPath(calendarHome.getPath());
            qm = calendarHome.getSession().getWorkspace().getQueryManager();
            query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
            it = query.execute().getNodes();
            mapData = this.updateMap(mapData, it, eventQuery.getFromDate(), eventQuery.getToDate(), calSetting.getFilterPrivateCalendars());
        }
        if (this.getSharedCalendarHome(systemSession).hasNode(username)) {
            PropertyIterator iter = this.getSharedCalendarHome(systemSession).getNode(username).getReferences();
            while (iter.hasNext()) {
                try {
                    Node calendar = iter.nextProperty().getParent();
                    eventQuery.setCalendarPath(calendar.getPath());
                    qm = calendar.getSession().getWorkspace().getQueryManager();
                    query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
                    NodeIterator it2 = query.execute().getNodes();
                    mapData = this.updateMap(mapData, it2, eventQuery.getFromDate(), eventQuery.getToDate(), calSetting.getFilterSharedCalendars());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Node publicCalHome = this.getPublicCalendarHome(systemSession);
        eventQuery.setCalendarPath(publicCalHome.getPath());
        qm = publicCalHome.getSession().getWorkspace().getQueryManager();
        eventQuery.setCalendarId(publicCalendarIds);
        query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
        it = query.execute().getNodes();
        mapData = this.updateMap(mapData, it, eventQuery.getFromDate(), eventQuery.getToDate(), calSetting.getFilterPublicCalendars());
        return mapData;
    }

    private Map<Integer, String> updateMap(Map<Integer, String> data, NodeIterator it, java.util.Calendar fromDate, java.util.Calendar toDate, String[] filterCalIds) throws Exception {
        int fromDayOfYear = fromDate.get(6);
        int toDayOfYear = toDate.get(6);
        boolean isVictory = false;
        while (it.hasNext() && !isVictory) {
            Node eventNode = it.nextNode();
            if (filterCalIds != null && Arrays.asList(filterCalIds).contains(eventNode.getProperty("exo:calendarId").getString())) continue;
            java.util.Calendar eventFormDate = eventNode.getProperty("exo:fromDateTime").getDate();
            java.util.Calendar eventToDate = eventNode.getProperty("exo:toDateTime").getDate();
            int eventFromDayOfYear = eventFormDate.get(6);
            int eventToDayOfYear = eventToDate.get(6);
            Integer begin = -1;
            Integer end = -1;
            if (fromDayOfYear >= eventFromDayOfYear) {
                begin = fromDayOfYear;
                if (toDayOfYear <= eventToDayOfYear) {
                    end = toDayOfYear;
                    isVictory = true;
                } else {
                    end = eventToDayOfYear;
                }
            } else {
                begin = eventFromDayOfYear;
                end = toDayOfYear <= eventToDayOfYear ? Integer.valueOf(toDayOfYear) : Integer.valueOf(eventToDayOfYear);
            }
            if (begin <= 0 || end <= 0) continue;
            Integer i = begin;
            while (i <= end) {
                data.put(i, VALUE);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return data;
    }

    public void shareCalendar(SessionProvider sProvider, String username, String calendarId, List<String> receiverUsers) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome(sProvider);
        Node calendarNode = this.getUserCalendarHome(sProvider, username).getNode(calendarId);
        Value[] values = new Value[]{};
        if (calendarNode.isNodeType(SHARED_MIXIN)) {
            values = calendarNode.getProperty(SHARED_PROP).getValues();
        } else {
            calendarNode.addMixin(SHARED_MIXIN);
        }
        SessionProvider spd = SessionProvider.createSystemProvider();
        Session systemSession = sharedCalendarHome.getSession();
        ArrayList<Value> valueList = new ArrayList<Value>();
        for (String user : receiverUsers) {
            Node userNode;
            block12: {
                CalendarSetting calSetting = this.getCalendarSetting(spd, user);
                if (calSetting == null) {
                    calSetting = new CalendarSetting();
                }
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : calSetting.getSharedCalendarsColors()) {
                    map.put(key.split(":")[0], key.split(":")[1]);
                }
                if (map.get(calendarNode.getProperty("exo:id").getString()) == null) {
                    map.put(calendarNode.getProperty("exo:id").getString(), calendarNode.getProperty("exo:calendarColor").getString());
                }
                ArrayList<String> calColors = new ArrayList<String>();
                for (String key : map.keySet()) {
                    calColors.add(key + ":" + (String)map.get(key));
                }
                calSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
                this.saveCalendarSetting(spd, user, calSetting);
                try {
                    userNode = sharedCalendarHome.getNode(user);
                }
                catch (Exception e) {
                    userNode = sharedCalendarHome.addNode(user, NT_UNSTRUCTURED);
                    if (!userNode.canAddMixin("mix:referenceable")) break block12;
                    userNode.addMixin("mix:referenceable");
                }
            }
            boolean isExist = false;
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                String uuid = value.getString();
                Node refNode = systemSession.getNodeByUUID(uuid);
                if (refNode.getPath().equals(userNode.getPath())) {
                    isExist = true;
                    break;
                }
                valueList.add(value);
            }
            if (isExist) continue;
            Value value2add = calendarNode.getSession().getValueFactory().createValue(userNode);
            valueList.add(value2add);
        }
        if (valueList.size() > 0) {
            calendarNode.setProperty(SHARED_PROP, valueList.toArray(new Value[valueList.size()]));
            calendarNode.save();
            sharedCalendarHome.getSession().save();
            calendarNode.getSession().save();
            systemSession.logout();
        }
    }

    public GroupCalendarData getSharedCalendars(SessionProvider sProvider, String username, boolean isShowAll) throws Exception {
        if (this.getSharedCalendarHome(sProvider).hasNode(username)) {
            Node sharedNode = this.getSharedCalendarHome(sProvider).getNode(username);
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            PropertyIterator iter = sharedNode.getReferences();
            String[] defaultFilterCalendars = null;
            if (this.getCalendarSetting(sProvider, username) != null) {
                defaultFilterCalendars = this.getCalendarSetting(sProvider, username).getFilterSharedCalendars();
            }
            while (iter.hasNext()) {
                try {
                    Calendar cal = this.getCalendar(defaultFilterCalendars, null, iter.nextProperty().getParent(), isShowAll);
                    if (cal == null) continue;
                    calendars.add(cal);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (calendars.size() > 0) {
                return new GroupCalendarData("Shared", "Shared", calendars);
            }
        }
        return null;
    }

    public void saveSharedCalendar(SessionProvider sProvider, String username, Calendar calendar) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome(sProvider);
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            String uuid = userNode.getProperty("jcr:uuid").getString();
            PropertyIterator iter = userNode.getReferences();
            ArrayList<Value> newValues = new ArrayList<Value>();
            while (iter.hasNext()) {
                Value[] values;
                Node calendarNode = iter.nextProperty().getParent();
                if (!calendarNode.getProperty("exo:id").getString().equals(calendar.getId())) continue;
                for (Value value : values = calendarNode.getProperty(SHARED_PROP).getValues()) {
                    if (value.getString().equals(uuid)) continue;
                    newValues.add(value);
                }
                calendarNode.setProperty("exo:name", calendar.getName());
                calendarNode.setProperty("exo:description", calendar.getDescription());
                calendarNode.setProperty("exo:categoryId", calendar.getCategoryId());
                calendarNode.setProperty("exo:viewPermissions", calendar.getViewPermission());
                calendarNode.setProperty("exo:editPermissions", calendar.getEditPermission());
                calendarNode.setProperty("exo:groups", calendar.getGroups());
                calendarNode.setProperty("exo:locale", calendar.getLocale());
                calendarNode.setProperty("exo:timeZone", calendar.getTimeZone());
                CalendarSetting usCalSetting = this.getCalendarSetting(sProvider, username);
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : usCalSetting.getSharedCalendarsColors()) {
                    map.put(key.split(":")[0], key.split(":")[1]);
                }
                map.put(calendar.getId(), calendar.getCalendarColor());
                ArrayList<String> calColors = new ArrayList<String>();
                for (String key : map.keySet()) {
                    calColors.add(key + ":" + (String)map.get(key));
                }
                calColors.add(calendar.getId() + ":" + calendar.getCalendarColor());
                usCalSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
                this.saveCalendarSetting(sProvider, username, usCalSetting);
                calendarNode.save();
                break;
            }
        }
    }

    public List<CalendarEvent> getSharedEvents(SessionProvider sProvider, String username, EventQuery eventQuery) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        if (this.getSharedCalendarHome(sProvider).hasNode(username)) {
            PropertyIterator iter = this.getSharedCalendarHome(sProvider).getNode(username).getReferences();
            while (iter.hasNext()) {
                try {
                    Node calendar = iter.nextProperty().getParent();
                    eventQuery.setCalendarPath(calendar.getPath());
                    QueryManager qm = calendar.getSession().getWorkspace().getQueryManager();
                    Query query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        CalendarEvent calEvent = this.getEvent(sProvider, it.nextNode());
                        calEvent.setCalType("1");
                        events.add(calEvent);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return events;
    }

    public List<CalendarEvent> getSharedEventByCalendars(SessionProvider sProvider, String username, List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        if (this.getSharedCalendarHome(sProvider).hasNode(username)) {
            PropertyIterator iter = this.getSharedCalendarHome(sProvider).getNode(username).getReferences();
            while (iter.hasNext()) {
                try {
                    Node calendar = iter.nextProperty().getParent();
                    if (!calendarIds.contains(calendar.getProperty("exo:id").getString())) continue;
                    NodeIterator it = calendar.getNodes();
                    while (it.hasNext()) {
                        events.add(this.getEvent(sProvider, it.nextNode()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return events;
    }

    public void removeSharedCalendar(SessionProvider sProvider, String username, String calendarId) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome(sProvider);
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            String uuid = userNode.getProperty("jcr:uuid").getString();
            PropertyIterator iter = userNode.getReferences();
            CalendarSetting calSetting = this.getCalendarSetting(sProvider, username);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : calSetting.getSharedCalendarsColors()) {
                map.put(key.split(":")[0], key.split(":")[1]);
            }
            ArrayList<Value> newValues = new ArrayList<Value>();
            while (iter.hasNext()) {
                Value[] values;
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty("exo:id").getString().equals(calendarId)) continue;
                map.remove(calendarId);
                for (Value value : values = calendar.getProperty(SHARED_PROP).getValues()) {
                    if (value.getString().equals(uuid)) continue;
                    newValues.add(value);
                }
                ArrayList<String> calColors = new ArrayList<String>();
                for (String key : map.keySet()) {
                    calColors.add(key + ":" + (String)map.get(key));
                }
                calSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
                this.saveCalendarSetting(sProvider, username, calSetting);
                calendar.setProperty(SHARED_PROP, newValues.toArray(new Value[newValues.size()]));
                calendar.save();
                break;
            }
        }
    }

    public void saveEventToSharedCalendar(SessionProvider sProvider, String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome(sProvider);
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty("exo:id").getString().equals(calendarId)) continue;
                Node reminderFolder = this.getReminderFolder(sProvider, event.getFromDateTime());
                this.saveEvent(calendar, event, reminderFolder, isNew);
                calendar.save();
                break;
            }
        }
    }

    public List<CalendarEvent> getEvents(SessionProvider sProvider, String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        ArrayList<String> filterList = new ArrayList<String>();
        CalendarSetting calSetting = this.getCalendarSetting(sProvider, username);
        filterList.addAll(Arrays.asList(calSetting.getFilterPrivateCalendars()));
        filterList.addAll(Arrays.asList(calSetting.getFilterPublicCalendars()));
        filterList.addAll(Arrays.asList(calSetting.getFilterSharedCalendars()));
        eventQuery.setFilterCalendarIds(filterList.toArray(new String[0]));
        events.addAll(this.getUserEvents(sProvider, username, eventQuery));
        events.addAll(this.getSharedEvents(SessionProvider.createSystemProvider(), username, eventQuery));
        events.addAll(this.getPublicEvents(SessionProvider.createSystemProvider(), eventQuery));
        return events;
    }

    public Map<String, String> checkFreeBusy(SessionProvider sysProvider, EventQuery eventQuery) throws Exception {
        String[] pars;
        Node eventFolder = this.getEventFolder(sysProvider, eventQuery.getFromDate().getTime());
        HashMap<String, String> participantMap = new HashMap<String, String>();
        eventQuery.setCalendarPath(eventFolder.getPath());
        eventQuery.setOrderBy(new String[]{"exo:fromDateTime"});
        QueryManager qm = eventFolder.getSession().getWorkspace().getQueryManager();
        for (String par : pars = eventQuery.getParticipants()) {
            eventQuery.setParticipants(new String[]{par});
            Query query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            StringBuilder timeValues = new StringBuilder();
            while (it.hasNext()) {
                String to;
                Node event = it.nextNode();
                if (!event.hasProperty("exo:eventState") || CalendarEvent.ST_AVAILABLE.equals(event.getProperty("exo:eventState").getValue().getString())) continue;
                java.util.Calendar fromCal = event.getProperty("exo:fromDateTime").getDate();
                java.util.Calendar toCal = event.getProperty("exo:toDateTime").getDate();
                String from = fromCal.getTimeInMillis() < eventQuery.getFromDate().getTimeInMillis() ? String.valueOf(eventQuery.getFromDate().getTimeInMillis()) : String.valueOf(fromCal.getTimeInMillis());
                if (toCal.getTimeInMillis() > eventQuery.getToDate().getTimeInMillis()) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(eventQuery.getToDate().getTimeInMillis() - 1000L);
                    to = String.valueOf(cal.getTimeInMillis());
                } else {
                    to = String.valueOf(toCal.getTimeInMillis());
                }
                if (timeValues != null && timeValues.length() > 0) {
                    timeValues.append(",");
                }
                timeValues.append(from).append(",").append(to);
                participantMap.put(par, timeValues.toString());
            }
        }
        return participantMap;
    }

    public void removeSharedEvent(SessionProvider sessionProvider, String username, String calendarId, String eventId) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome(sessionProvider);
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty("exo:id").getString().equals(calendarId)) continue;
                if (calendar.hasNode(eventId)) {
                    Node event = calendar.getNode(eventId);
                    Node eventFolder = this.getEventFolder(SessionProvider.createSystemProvider(), event.getProperty("exo:fromDateTime").getDate().getTime());
                    this.syncRemoveEvent(eventFolder, eventId);
                    this.removeReminder(sessionProvider, event);
                    event.remove();
                }
                calendar.save();
                calendar.refresh(true);
                break;
            }
        }
    }

    public boolean hasEditPermission(SessionProvider sProvider, String sharedCalendarId, String username) throws Exception {
        if (this.getSharedCalendarHome(sProvider).hasNode(username)) {
            Node userNode = this.getSharedCalendarHome(sProvider).getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty("exo:id").getString().equals(sharedCalendarId)) continue;
                Value[] editValues = calendar.getProperty("exo:editPermissions").getValues();
                return Arrays.asList(editValues).contains(username);
            }
        }
        return false;
    }

    public void moveEvent(SessionProvider sProvider, String formCalendar, String toCalendar, String fromType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        block0 : switch (Integer.parseInt(fromType)) {
            case 0: {
                if (!this.getUserCalendarHome(sProvider, username).hasNode(formCalendar)) break;
                switch (Integer.parseInt(toType)) {
                    case 0: {
                        if (!this.getUserCalendarHome(sProvider, username).hasNode(toCalendar)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            if (!formCalendar.equals(toCalendar)) {
                                calEvent.setCalendarId(toCalendar);
                                this.saveUserEvent(sProvider, username, toCalendar, calEvent, this.getUserCalendarHome(sProvider, username).getNode(toCalendar).hasNode(calEvent.getId()));
                                this.removeUserEvent(sProvider, username, formCalendar, calEvent.getId());
                                continue;
                            }
                            this.saveUserEvent(sProvider, username, toCalendar, calEvent, false);
                        }
                        break block0;
                    }
                    case 1: {
                        if (!this.getSharedCalendarHome(systemSession).hasNode(username)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            calEvent.setCalendarId(toCalendar);
                            this.saveEventToSharedCalendar(systemSession, username, toCalendar, calEvent, this.getSharedCalendarHome(systemSession).getNode(username).hasNode(calEvent.getId()));
                            this.removeUserEvent(sProvider, username, formCalendar, calEvent.getId());
                        }
                        break block0;
                    }
                    case 2: {
                        if (!this.getPublicCalendarHome(systemSession).hasNode(toCalendar)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            calEvent.setCalendarId(toCalendar);
                            this.savePublicEvent(systemSession, toCalendar, calEvent, this.getPublicCalendarHome(systemSession).getNode(toCalendar).hasNode(calEvent.getId()));
                            this.removeUserEvent(systemSession, username, formCalendar, calEvent.getId());
                        }
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (!this.getSharedCalendarHome(systemSession).hasNode(username)) break;
                switch (Integer.parseInt(toType)) {
                    case 0: {
                        if (!this.getUserCalendarHome(sProvider, username).hasNode(toCalendar)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            calEvent.setCalendarId(toCalendar);
                            this.saveUserEvent(sProvider, username, toCalendar, calEvent, this.getUserCalendarHome(sProvider, username).getNode(toCalendar).hasNode(calEvent.getId()));
                            this.removeSharedEvent(systemSession, username, formCalendar, calEvent.getId());
                        }
                        break block0;
                    }
                    case 1: {
                        if (!this.getSharedCalendarHome(systemSession).hasNode(username)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            if (!formCalendar.equals(toCalendar)) {
                                calEvent.setCalendarId(toCalendar);
                                this.saveEventToSharedCalendar(systemSession, username, toCalendar, calEvent, this.getSharedCalendarHome(systemSession).getNode(username).hasNode(calEvent.getId()));
                                this.removeSharedEvent(systemSession, username, formCalendar, calEvent.getId());
                                continue;
                            }
                            this.saveEventToSharedCalendar(systemSession, username, toCalendar, calEvent, false);
                        }
                        break block0;
                    }
                    case 2: {
                        if (!this.getPublicCalendarHome(systemSession).hasNode(formCalendar)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            calEvent.setCalendarId(toCalendar);
                            this.savePublicEvent(systemSession, toCalendar, calEvent, this.getPublicCalendarHome(systemSession).getNode(toCalendar).hasNode(calEvent.getId()));
                            this.removeSharedEvent(systemSession, username, formCalendar, calEvent.getId());
                        }
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (!this.getPublicCalendarHome(systemSession).hasNode(formCalendar)) break;
                switch (Integer.parseInt(toType)) {
                    case 0: {
                        if (!this.getUserCalendarHome(sProvider, username).hasNode(toCalendar)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            calEvent.setCalendarId(toCalendar);
                            this.saveUserEvent(sProvider, username, toCalendar, calEvent, this.getUserCalendarHome(sProvider, username).getNode(toCalendar).hasNode(calEvent.getId()));
                            this.removePublicEvent(systemSession, formCalendar, calEvent.getId());
                        }
                        break block0;
                    }
                    case 1: {
                        if (!this.getSharedCalendarHome(systemSession).hasNode(username)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            calEvent.setCalendarId(toCalendar);
                            this.saveEventToSharedCalendar(systemSession, username, toCalendar, calEvent, this.getSharedCalendarHome(systemSession).getNode(toCalendar).hasNode(calEvent.getId()));
                            this.removePublicEvent(systemSession, formCalendar, calEvent.getId());
                        }
                        break block0;
                    }
                    case 2: {
                        if (!this.getPublicCalendarHome(systemSession).hasNode(toCalendar)) break;
                        for (CalendarEvent calEvent : calEvents) {
                            if (!formCalendar.equals(toCalendar)) {
                                calEvent.setCalendarId(toCalendar);
                                this.savePublicEvent(systemSession, toCalendar, calEvent, this.getPublicCalendarHome(systemSession).getNode(toCalendar).hasNode(calEvent.getId()));
                                this.removePublicEvent(systemSession, formCalendar, calEvent.getId());
                                continue;
                            }
                            this.savePublicEvent(systemSession, toCalendar, calEvent, false);
                        }
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void confirmInvitation(String fromUserId, String toUserId, int calType, String calendarId, String eventId, int answer) throws Exception {
        SessionProvider session = SessionProvider.createSystemProvider();
        HashMap<String, String> pars = new HashMap<String, String>();
        CalendarEvent event = null;
        if (0 == calType) {
            event = this.getUserEvent(session, fromUserId, calendarId, eventId);
        } else if (1 == calType) {
            ArrayList<String> calendarIds = new ArrayList<String>();
            calendarIds.add(calendarId);
            for (CalendarEvent calEvent : this.getSharedEventByCalendars(session, fromUserId, calendarIds)) {
                if (!calEvent.getId().equals(eventId)) continue;
                event = calEvent;
                break;
            }
        } else if (2 == calType) {
            event = this.getGroupEvent(session, calendarId, eventId);
        }
        if (event != null) {
            if (event.getParticipant() != null) {
                for (String id : event.getParticipant()) {
                    pars.put(id, id);
                }
            }
            if (0 == answer) {
                pars.remove(toUserId);
            }
            if (1 == answer || 2 == answer) {
                pars.put(toUserId, toUserId);
            }
            event.setParticipant(pars.values().toArray(new String[pars.values().size()]));
            if (0 == calType) {
                this.saveUserEvent(session, fromUserId, calendarId, event, false);
            } else if (1 == calType) {
                this.saveEventToSharedCalendar(session, fromUserId, calendarId, event, false);
            } else if (2 == calType) {
                this.savePublicEvent(session, calendarId, event, false);
            }
        }
    }
}

