/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    public static final String EVENT_CATEGORIES = "defaultEventCategories".intern();
    public static final String CALENDAR_CATEGORIES = "defaultCalendarCategory".intern();
    public static final String CALENDAR_NAME = "defaultCalendar".intern();
    public static final String COMA = ",".intern();
    public static final String ST_VIEW_TYPE = "viewType".intern();
    public static final String ST_TIME_INTEVAL = "timeInterval".intern();
    public static final String ST_WEEK_START = "weekStartOn".intern();
    public static final String ST_DATE_FORMAT = "dateFormat".intern();
    public static final String ST_TIME_FORMAT = "timeFormat".intern();
    public static final String ST_LOCALE = "localeId".intern();
    public static final String ST_TIMEZONE = "timezoneId".intern();
    public static final String ST_BASE_URL = "baseUrlForRss".intern();
    public static final String ST_WORKINGTIME = "isShowWorkingTime".intern();
    public static final String ST_TIME_BEGIN = "workingTimeBegin".intern();
    public static final String ST_TIME_END = "workingTimeEnd".intern();
    private CalendarService cservice_;
    private String[] defaultEventCategories_;
    private String defaultCalendarCategory_;
    private String[] defaultCalendar_;
    private CalendarSetting defaultCalendarSetting_;

    public NewUserListener(CalendarService cservice, InitParams params) throws Exception {
        this.cservice_ = cservice;
        String defaultEventCategories = params.getValueParam(EVENT_CATEGORIES).getValue();
        if (defaultEventCategories != null && defaultEventCategories.length() > 0) {
            this.defaultEventCategories_ = defaultEventCategories.split(COMA);
        }
        this.defaultCalendarCategory_ = params.getValueParam(CALENDAR_CATEGORIES).getValue();
        String defaultCalendar = params.getValueParam(CALENDAR_NAME).getValue();
        if (defaultCalendar != null && defaultCalendar.length() > 0) {
            this.defaultCalendar_ = defaultCalendar.split(COMA);
        }
        this.defaultCalendarSetting_ = new CalendarSetting();
        if (params.getValueParam(ST_VIEW_TYPE) != null) {
            this.defaultCalendarSetting_.setViewType(params.getValueParam(ST_VIEW_TYPE).getValue());
        }
        if (params.getValueParam(ST_TIME_INTEVAL) != null) {
            this.defaultCalendarSetting_.setTimeInterval(Long.parseLong(params.getValueParam(ST_TIME_INTEVAL).getValue()));
        }
        if (params.getValueParam(ST_WEEK_START) != null) {
            this.defaultCalendarSetting_.setWeekStartOn(params.getValueParam(ST_WEEK_START).getValue());
        }
        if (params.getValueParam(ST_DATE_FORMAT) != null) {
            this.defaultCalendarSetting_.setDateFormat(params.getValueParam(ST_DATE_FORMAT).getValue());
        }
        if (params.getValueParam(ST_TIME_FORMAT) != null) {
            this.defaultCalendarSetting_.setTimeFormat(params.getValueParam(ST_TIME_FORMAT).getValue());
        }
        if (params.getValueParam(ST_LOCALE) != null) {
            this.defaultCalendarSetting_.setLocation(params.getValueParam(ST_LOCALE).getValue());
        }
        if (params.getValueParam(ST_TIMEZONE) != null) {
            this.defaultCalendarSetting_.setTimeZone(params.getValueParam(ST_TIMEZONE).getValue());
        }
        if (params.getValueParam(ST_BASE_URL) != null) {
            this.defaultCalendarSetting_.setBaseURL(params.getValueParam(ST_BASE_URL).getValue());
        }
        if (params.getValueParam(ST_WORKINGTIME) != null) {
            this.defaultCalendarSetting_.setShowWorkingTime(Boolean.parseBoolean(params.getValueParam(ST_WORKINGTIME).getValue()));
            if (this.defaultCalendarSetting_.isShowWorkingTime()) {
                if (params.getValueParam(ST_TIME_BEGIN) != null) {
                    this.defaultCalendarSetting_.setWorkingTimeBegin(params.getValueParam(ST_TIME_BEGIN).getValue());
                }
                if (params.getValueParam(ST_TIME_END) != null) {
                    this.defaultCalendarSetting_.setWorkingTimeEnd(params.getValueParam(ST_TIME_END).getValue());
                }
            }
        }
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        if (this.defaultEventCategories_ != null && this.defaultEventCategories_.length > 0) {
            for (String evCategory : this.defaultEventCategories_) {
                EventCategory eventCategory = new EventCategory();
                eventCategory.setName(evCategory);
                eventCategory.setDataInit(true);
                this.cservice_.saveEventCategory(sysProvider, user.getUserName(), eventCategory, null, true);
            }
        }
        if (this.defaultCalendarCategory_ != null && this.defaultCalendarCategory_.length() > 0) {
            CalendarCategory calCategory = new CalendarCategory();
            calCategory.setName(this.defaultCalendarCategory_);
            calCategory.setDataInit(true);
            this.cservice_.saveCalendarCategory(sysProvider, user.getUserName(), calCategory, true);
            if (this.defaultCalendar_ != null && this.defaultCalendar_.length > 0) {
                for (String calendar : this.defaultCalendar_) {
                    Calendar cal = new Calendar();
                    cal.setName(calendar);
                    cal.setCategoryId(calCategory.getId());
                    cal.setDataInit(true);
                    cal.setCalendarOwner(user.getUserName());
                    if (this.defaultCalendarSetting_ != null) {
                        if (this.defaultCalendarSetting_.getLocation() != null) {
                            cal.setLocale(this.defaultCalendarSetting_.getLocation());
                        }
                        if (this.defaultCalendarSetting_.getTimeZone() != null) {
                            cal.setTimeZone(this.defaultCalendarSetting_.getTimeZone());
                        }
                    }
                    this.cservice_.saveUserCalendar(sysProvider, user.getUserName(), cal, true);
                }
            }
        }
        if (this.defaultCalendarSetting_ != null && user != null) {
            this.cservice_.saveCalendarSetting(sysProvider, user.getUserName(), this.defaultCalendarSetting_);
        }
        sysProvider.close();
    }

    public void preDelete(User user) throws Exception {
    }
}

