/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.container.PortalContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImportExport
implements CalendarImportExport {
    public static final String CSV_PATTERN = "\"([^\"]+?)\",?|([^,]+),?|,";
    private static Pattern csvRE;
    public static String EV_SUMMARY;
    public static String EV_STARTDATE;
    public static String EV_STARTTIME;
    public static String EV_ENDDATE;
    public static String EV_ENDTIME;
    public static String EV_ALLDAY;
    public static String EV_HASREMINDER;
    public static String EV_REMINDERDATE;
    public static String EV_REMINDERTIME;
    public static String EV_MEETINGORGANIZER;
    public static String EV_ATTENDEES;
    public static String EV_INVITATION;
    public static String EV_ATTACTMENT;
    public static String EV_BILLINGINFO;
    public static String EV_CATEGORIES;
    public static String EV_DESCRIPTION;
    public static String EV_LOCATION;
    public static String EV_MILEAGE;
    public static String EV_PRIORITY;
    public static String EV_PRIVATE;
    public static String EV_SENSITIVITY;
    public static String EV_STATUS;
    private static LinkedHashMap<String, Integer> dataMap;
    private static String[] keys;
    private static final String PRIVATE_TYPE;
    private JCRDataStorage storage_;

    public CsvImportExport(JCRDataStorage dataStore) {
        csvRE = Pattern.compile(CSV_PATTERN);
        this.storage_ = dataStore;
        int count = 0;
        for (String k : keys) {
            dataMap.put(k, count);
            ++count;
        }
    }

    public List<CalendarEvent> process(BufferedReader in) throws Exception {
        String line;
        int lineCount = 0;
        ArrayList<CalendarEvent> eventList = new ArrayList<CalendarEvent>();
        while ((line = in.readLine()) != null) {
            List<String> l;
            String tempLine = line;
            if (!line.endsWith("\"")) {
                line = tempLine + in.readLine();
            }
            if (lineCount > 0 && !Utils.isEmpty((l = this.parse(line)).get(dataMap.get(EV_SUMMARY)))) {
                java.util.Calendar cal;
                boolean isValid = true;
                CalendarEvent eventObj = new CalendarEvent();
                eventObj.setEventType(CalendarEvent.TYPE_EVENT);
                eventObj.setCalType(PRIVATE_TYPE);
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", Locale.ENGLISH);
                if (!Utils.isEmpty(l.get(dataMap.get(EV_SUMMARY)))) {
                    eventObj.setSummary(l.get(dataMap.get(EV_SUMMARY)));
                }
                if (!Utils.isEmpty(l.get(dataMap.get(EV_STARTDATE))) && !Utils.isEmpty(l.get(dataMap.get(EV_STARTTIME)))) {
                    cal = GregorianCalendar.getInstance();
                    try {
                        cal.setTime(df.parse(l.get(dataMap.get(EV_STARTDATE)) + " " + l.get(dataMap.get(EV_STARTTIME))));
                    }
                    catch (Exception e) {
                        isValid = false;
                        throw e;
                    }
                    if (!Utils.isEmpty(l.get(dataMap.get(EV_ALLDAY))) && isValid && Boolean.parseBoolean(l.get(dataMap.get(EV_ALLDAY)))) {
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(14, 0);
                    }
                    if (isValid) {
                        eventObj.setFromDateTime(cal.getTime());
                    }
                }
                if (!Utils.isEmpty(l.get(dataMap.get(EV_ENDDATE)))) {
                    if (!Utils.isEmpty(l.get(dataMap.get(EV_ENDTIME)))) {
                        cal = GregorianCalendar.getInstance();
                        try {
                            cal.setTime(df.parse(l.get(dataMap.get(EV_ENDDATE)) + " " + l.get(dataMap.get(EV_ENDTIME))));
                        }
                        catch (Exception e) {
                            isValid = false;
                            throw e;
                        }
                        if (!Utils.isEmpty(l.get(dataMap.get(EV_ALLDAY))) && isValid && Boolean.parseBoolean(l.get(dataMap.get(EV_ALLDAY)))) {
                            cal.set(11, 23);
                            cal.set(12, 59);
                            cal.set(14, 999);
                        }
                        if (isValid) {
                            eventObj.setToDateTime(cal.getTime());
                        }
                    }
                    if (isValid) {
                        if (!Utils.isEmpty(l.get(dataMap.get(EV_ATTENDEES)))) {
                            eventObj.setParticipant(l.get(dataMap.get(EV_ATTENDEES)).split(";"));
                        }
                        if (!Utils.isEmpty(l.get(dataMap.get(EV_INVITATION)))) {
                            eventObj.setInvitation(l.get(dataMap.get(EV_INVITATION)).split(";"));
                        }
                        if (!Utils.isEmpty(l.get(dataMap.get(EV_CATEGORIES)))) {
                            eventObj.setEventCategoryName(l.get(dataMap.get(EV_CATEGORIES)));
                        } else {
                            eventObj.setEventCategoryName("csvimported");
                        }
                        if (!Utils.isEmpty(l.get(dataMap.get(EV_LOCATION)))) {
                            eventObj.setLocation(l.get(dataMap.get(EV_LOCATION)));
                        }
                        if (!Utils.isEmpty(l.get(dataMap.get(EV_DESCRIPTION)))) {
                            eventObj.setDescription(l.get(dataMap.get(EV_DESCRIPTION)));
                        }
                        if (!Utils.isEmpty(l.get(dataMap.get(EV_STATUS)))) {
                            String eventState = l.get(dataMap.get(EV_STATUS));
                            try {
                                int value = Integer.parseInt(eventState);
                                if (value == 0 || value == 1) {
                                    eventState = CalendarEvent.ST_AVAILABLE;
                                }
                                if (value == 2) {
                                    eventState = CalendarEvent.ST_BUSY;
                                }
                                if (value == 3) {
                                    eventState = CalendarEvent.ST_OUTSIDE;
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            eventObj.setEventState(eventState);
                        }
                        if (!Utils.isEmpty(l.get(dataMap.get(EV_PRIORITY)))) {
                            for (int i = 0; i < CalendarEvent.PRIORITY.length; ++i) {
                                if (!CalendarEvent.PRIORITY[i].equalsIgnoreCase(l.get(dataMap.get(EV_PRIORITY)).toLowerCase())) continue;
                                eventObj.setPriority(String.valueOf(i));
                                break;
                            }
                        }
                    }
                }
                if (!isValid) break;
                eventList.add(eventObj);
            }
            ++lineCount;
        }
        return eventList;
    }

    public List<String> parse(String line) {
        String match;
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = csvRE.matcher(line);
        while (m.find() && (match = m.group()) != null) {
            if (match.endsWith(",")) {
                match = match.substring(0, match.length() - 1);
            }
            if (match.startsWith("\"")) {
                match = match.substring(1, match.length() - 1);
            }
            if (match.length() == 0) {
                match = null;
            }
            list.add(match);
        }
        return list;
    }

    @Override
    public OutputStream exportCalendar(String username, List<String> calendarIds, String type) throws Exception {
        return null;
    }

    @Override
    public void importCalendar(String username, InputStream csvInputStream, String calendarName) throws Exception {
        List<CalendarEvent> data = this.process(new BufferedReader(new InputStreamReader(csvInputStream)));
        if (data.size() > 0) {
            String categoryId;
            NodeIterator iter = this.storage_.getCalendarCategoryHome(username).getNodes();
            CalendarService calServie = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
            Node cat = null;
            boolean isExists = false;
            while (iter.hasNext()) {
                cat = iter.nextNode();
                if (!cat.getProperty(Utils.EXO_NAME).getString().equals("Imported")) continue;
                isExists = true;
                break;
            }
            if (!isExists) {
                CalendarCategory calendarCate = new CalendarCategory();
                calendarCate.setDescription("Imported icalendar category");
                calendarCate.setName("Imported");
                categoryId = calendarCate.getId();
                calServie.saveCalendarCategory(username, calendarCate, true);
            } else {
                categoryId = cat.getProperty(Utils.EXO_ID).getString();
            }
            Calendar exoCalendar = new Calendar();
            exoCalendar.setName(calendarName);
            exoCalendar.setCalendarColor(Calendar.COLORS[new Random().nextInt(Calendar.COLORS.length - 1)]);
            exoCalendar.setDescription("");
            exoCalendar.setCategoryId(categoryId);
            exoCalendar.setPublic(true);
            exoCalendar.setCalendarOwner(username);
            calServie.saveUserCalendar(username, exoCalendar, true);
            for (CalendarEvent exoEvent : data) {
                if (!Utils.isEmpty(exoEvent.getEventCategoryName())) {
                    EventCategory evCate = new EventCategory();
                    evCate.setName(exoEvent.getEventCategoryName());
                    try {
                        calServie.saveEventCategory(username, evCate, true);
                    }
                    catch (ItemExistsException e) {
                        evCate = calServie.getEventCategoryByName(username, evCate.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    exoEvent.setEventCategoryId(evCate.getId());
                    exoEvent.setEventCategoryName(evCate.getName());
                }
                exoEvent.setCalendarId(exoCalendar.getId());
                calServie.saveUserEvent(username, exoCalendar.getId(), exoEvent, true);
            }
        }
    }

    @Override
    public List<CalendarEvent> getEventObjects(InputStream icalInputStream) throws Exception {
        return null;
    }

    @Override
    public void importToCalendar(String username, InputStream icalInputStream, String calendarId) throws Exception {
        List<CalendarEvent> data = this.process(new BufferedReader(new InputStreamReader(icalInputStream)));
        CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
        for (CalendarEvent exoEvent : data) {
            if (!Utils.isEmpty(exoEvent.getEventCategoryName())) {
                EventCategory evCate = new EventCategory();
                evCate.setName(exoEvent.getEventCategoryName());
                try {
                    calService.saveEventCategory(username, evCate, true);
                }
                catch (ItemExistsException e) {
                    evCate = calService.getEventCategoryByName(username, evCate.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                exoEvent.setEventCategoryId(evCate.getId());
                exoEvent.setEventCategoryName(evCate.getName());
            }
            exoEvent.setCalendarId(calendarId);
            this.storage_.saveUserEvent(username, calendarId, exoEvent, true);
        }
    }

    @Override
    public boolean isValidate(InputStream icalInputStream) throws Exception {
        try {
            this.process(new BufferedReader(new InputStreamReader(icalInputStream)));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public OutputStream exportCalendar(String username, List<String> calendarIds, String type, int number) throws Exception {
        return null;
    }

    @Override
    public OutputStream exportEventCalendar(String username, String calendarId, String type, String eventId) throws Exception {
        return null;
    }

    @Override
    public ByteArrayOutputStream exportEventCalendar(CalendarEvent event) throws Exception {
        return null;
    }

    static {
        EV_SUMMARY = "Subject".intern();
        EV_STARTDATE = "Start Date".intern();
        EV_STARTTIME = "Start Time".intern();
        EV_ENDDATE = "End Date".intern();
        EV_ENDTIME = "End Time".intern();
        EV_ALLDAY = "All day event".intern();
        EV_HASREMINDER = "Reminder on/off".intern();
        EV_REMINDERDATE = "Reminder Date".intern();
        EV_REMINDERTIME = "Reminder Time".intern();
        EV_MEETINGORGANIZER = "Meeting Organizer".intern();
        EV_ATTENDEES = "Required Attendees".intern();
        EV_INVITATION = "Optional Attendees".intern();
        EV_ATTACTMENT = "Meeting Resources".intern();
        EV_BILLINGINFO = "Billing Information".intern();
        EV_CATEGORIES = "Categories".intern();
        EV_DESCRIPTION = "Description".intern();
        EV_LOCATION = "Location".intern();
        EV_MILEAGE = "Mileage".intern();
        EV_PRIORITY = "Priority".intern();
        EV_PRIVATE = "Private".intern();
        EV_SENSITIVITY = "Sensitivity".intern();
        EV_STATUS = "Show time as".intern();
        dataMap = new LinkedHashMap();
        keys = new String[]{EV_SUMMARY, EV_STARTDATE, EV_STARTTIME, EV_ENDDATE, EV_ENDTIME, EV_ALLDAY, EV_HASREMINDER, EV_REMINDERDATE, EV_REMINDERTIME, EV_MEETINGORGANIZER, EV_ATTENDEES, EV_INVITATION, EV_ATTACTMENT, EV_BILLINGINFO, EV_CATEGORIES, EV_DESCRIPTION, EV_LOCATION, EV_MILEAGE, EV_PRIORITY, EV_PRIVATE, EV_SENSITIVITY, EV_STATUS};
        PRIVATE_TYPE = "0".intern();
    }
}

