/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.PopupReminderJob;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ReminderJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"cs.calendar.job");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        PortalContainer container = Utils.getPortalContainer(context);
        if (container == null) {
            return;
        }
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"Calendar email reminder service");
            }
            Calendar fromCalendar = GregorianCalendar.getInstance();
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            Node calendarHome = Utils.getPublicServiceHome(provider);
            if (calendarHome == null) {
                return;
            }
            StringBuffer path = new StringBuffer(PopupReminderJob.getReminderPath(fromCalendar, provider));
            path.append("//element(*,exo:reminder)");
            path.append("[@exo:remindDateTime <= xs:dateTime('" + ISO8601.format((Calendar)fromCalendar) + "') and @exo:isOver = 'false' and @exo:reminderType = 'email' ]");
            QueryManager queryManager = Utils.getSession(provider).getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(path.toString(), "xpath");
            QueryResult results = query.execute();
            NodeIterator iter = results.getNodes();
            while (iter.hasNext()) {
                Node reminder = iter.nextNode();
                boolean isRepeat = reminder.getProperty(Utils.EXO_IS_REPEAT).getBoolean();
                long fromTime = reminder.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTimeInMillis();
                long remindTime = reminder.getProperty(Utils.EXO_REMINDER_DATE).getDate().getTimeInMillis();
                long interval = reminder.getProperty(Utils.EXO_TIME_INTERVAL).getLong() * 60L * 1000L;
                String to = reminder.getProperty(Utils.EXO_EMAIL).getString();
                if (to == null || to.length() <= 0) continue;
                Message message = new Message();
                message.setMimeType("text/html");
                message.setTo(to);
                message.setSubject("[reminder] eXo calendar notify mail !");
                message.setBody(reminder.getProperty(Utils.EXO_DESCRIPTION).getString());
                message.setFrom(jdatamap.getString("account"));
                if (isRepeat) {
                    if (fromCalendar.getTimeInMillis() >= fromTime) {
                        reminder.setProperty(Utils.EXO_IS_OVER, true);
                    } else if (remindTime + interval > fromTime) {
                        reminder.setProperty(Utils.EXO_IS_OVER, true);
                    } else {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeInMillis(remindTime + interval);
                        reminder.setProperty(Utils.EXO_REMINDER_DATE, (Calendar)cal);
                        reminder.setProperty(Utils.EXO_IS_OVER, false);
                    }
                } else {
                    reminder.setProperty(Utils.EXO_IS_OVER, true);
                }
                reminder.save();
                mailService.sendMessage(message);
            }
        }
        catch (RepositoryException e) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"Data base not ready !");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (log_.isDebugEnabled()) {
                log_.debug((Object)e.toString());
            }
        }
        finally {
            provider.close();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
        if (log_.isDebugEnabled()) {
            log_.debug((Object)"File plan job done");
        }
    }
}

