/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.LinkedHashMap;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIPreview;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIDefaultPreview.gtmpl", events={@EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete")})
public class UIPreview
extends UICalendarView
implements UIPopupComponent {
    private CalendarEvent event_ = null;
    private boolean isShowPopup_ = false;

    public String getTemplate() {
        if (this.event_ == null) {
            return "app:/templates/calendar/webui/UIDefaultPreview.gtmpl";
        }
        if (this.event_.getEventType().equals(CalendarEvent.TYPE_EVENT)) {
            return "app:/templates/calendar/webui/UIEventPreview.gtmpl";
        }
        if (this.event_.getEventType().equals(CalendarEvent.TYPE_TASK)) {
            return "app:/templates/calendar/webui/UITaskPreview.gtmpl";
        }
        return "app:/templates/calendar/webui/UIDefaultPreview.gtmpl";
    }

    public CalendarEvent getEvent() {
        return this.event_;
    }

    public void setEvent(CalendarEvent event) {
        this.event_ = event;
    }

    public void refresh() throws Exception {
        if (this.getAncestorOfType(UIListContainer.class) != null) {
            this.event_ = ((UIListView)((UIListContainer)this.getAncestorOfType(UIListContainer.class)).findFirstComponentOfType(UIListView.class)).getSelectedEventObj();
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setShowPopup(boolean isShow) {
        this.isShowPopup_ = isShow;
    }

    public boolean isShowPopup() {
        return this.isShowPopup_;
    }

    public Attachment getAttachment(String attId) {
        if (this.getEvent() != null) {
            for (Attachment a : this.getEvent().getAttachment()) {
                if (!a.getId().equals(attId)) continue;
                return a;
            }
        }
        return null;
    }

    public String getDownloadLink(Attachment attach) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        return CalendarUtils.getDataSource((Attachment)attach, (DownloadService)dservice);
    }

    LinkedHashMap<String, CalendarEvent> getDataMap() {
        LinkedHashMap<String, CalendarEvent> dataMap = new LinkedHashMap<String, CalendarEvent>();
        if (this.event_ != null) {
            dataMap.put(this.event_.getId(), this.event_);
        }
        return dataMap;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }
}

