/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/calendar/webui/UIPopup/UICalendarSettingTab.gtmpl")
public class UICalendarSettingTab
extends UIFormInputWithActions {
    public static final String VIEW_TYPE = "viewType".intern();
    public static final String TIME_INTERVAL = "timeInterval".intern();
    public static final String WEEK_START_ON = "weekStartOn".intern();
    public static final String DATE_FORMAT = "dateFormat".intern();
    public static final String TIME_FORMAT = "timeFormat".intern();
    public static final String LOCATION = "location".intern();
    public static final String TIMEZONE = "timeZone".intern();
    public static final String ISSHOWWORKINGTIME = "showWorkingTime".intern();
    public static final String WORKINGTIME_BEGIN = "beginTime".intern();
    public static final String WORKINGTIME_END = "endTime".intern();
    public static final String BASE_URL = "baseURL".intern();
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_ = new HashMap();

    public UICalendarSettingTab(String compId) throws Exception {
        super(compId);
        this.setComponentConfig(this.getClass(), null);
        ArrayList<SelectItemOption> viewTypes = new ArrayList<SelectItemOption>();
        viewTypes.add(new SelectItemOption(CalendarSetting.DAY_VIEW, (Object)CalendarSetting.DAY_VIEW));
        viewTypes.add(new SelectItemOption(CalendarSetting.WEEK_VIEW, (Object)CalendarSetting.WEEK_VIEW));
        viewTypes.add(new SelectItemOption(CalendarSetting.WORKING_VIEW, (Object)CalendarSetting.WORKING_VIEW));
        viewTypes.add(new SelectItemOption(CalendarSetting.MONTH_VIEW, (Object)CalendarSetting.MONTH_VIEW));
        viewTypes.add(new SelectItemOption(CalendarSetting.YEAR_VIEW, (Object)CalendarSetting.YEAR_VIEW));
        viewTypes.add(new SelectItemOption(CalendarSetting.LIST_VIEW, (Object)CalendarSetting.LIST_VIEW));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(VIEW_TYPE, VIEW_TYPE, viewTypes));
        ArrayList<SelectItemOption> timeInterval = new ArrayList<SelectItemOption>();
        for (int i = 5; i < 121; i += 5) {
            timeInterval.add(new SelectItemOption(String.valueOf(i), (Object)(String.valueOf(i) + "-itv")));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TIME_INTERVAL, TIME_INTERVAL, timeInterval));
        ArrayList<SelectItemOption> weekStartOn = new ArrayList<SelectItemOption>();
        DateFormatSymbols dfs = new DateFormatSymbols();
        for (int id = 1; id < dfs.getWeekdays().length; ++id) {
            weekStartOn.add(new SelectItemOption(String.valueOf(id) + "-wst", (Object)(String.valueOf(id) + "-wst")));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(WEEK_START_ON, WEEK_START_ON, weekStartOn));
        ArrayList<SelectItemOption> dateFormat = new ArrayList<SelectItemOption>();
        dateFormat.add(new SelectItemOption("dd/MM/yyyy", (Object)"dd/MM/yyyy"));
        dateFormat.add(new SelectItemOption("dd-MM-yyyy", (Object)"dd-MM-yyyy"));
        dateFormat.add(new SelectItemOption("MM/dd/yyyy", (Object)"MM/dd/yyyy"));
        dateFormat.add(new SelectItemOption("MM-dd-yyyy", (Object)"MM-dd-yyyy"));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(DATE_FORMAT, DATE_FORMAT, dateFormat));
        ArrayList<SelectItemOption> timeFormat = new ArrayList<SelectItemOption>();
        timeFormat.add(new SelectItemOption("AM/PM", (Object)"AM/PM"));
        timeFormat.add(new SelectItemOption("24-Hours", (Object)"24-Hours"));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TIME_FORMAT, TIME_FORMAT, timeFormat));
        UIFormSelectBox localeSelect = new UIFormSelectBox(LOCATION, LOCATION, this.getLocales());
        this.addUIFormInput((UIFormInput)localeSelect);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TIMEZONE, TIMEZONE, this.getTimeZones(null)));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(ISSHOWWORKINGTIME, ISSHOWWORKINGTIME, (Object)false));
        ArrayList startTimes = new ArrayList();
        List endTimes = CalendarUtils.getTimesSelectBoxOptions((String)CalendarUtils.TIMEFORMAT, (int)30);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(WORKINGTIME_BEGIN, WORKINGTIME_BEGIN, startTimes));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(WORKINGTIME_END, WORKINGTIME_END, endTimes));
    }

    protected UIForm getParentFrom() {
        return (UIForm)this.getParent();
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) throws Exception {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    public void processRender(WebuiRequestContext arg0) throws Exception {
        super.processRender(arg0);
    }

    protected String getViewType() {
        return (String)this.getUIFormSelectBox(VIEW_TYPE).getValue();
    }

    protected void setViewType(String value) {
        this.getUIFormSelectBox(VIEW_TYPE).setValue(value);
    }

    protected String getTimeInterval() {
        String value = (String)this.getUIFormSelectBox(TIME_INTERVAL).getValue();
        return value.substring(0, value.lastIndexOf("-itv"));
    }

    protected void setTimeInterval(String value) {
        value = value + "-itv";
        this.getUIFormSelectBox(TIME_INTERVAL).setValue(value);
    }

    protected String getWeekStartOn() {
        String value = (String)this.getUIFormSelectBox(WEEK_START_ON).getValue();
        return value.substring(0, value.lastIndexOf("-wst"));
    }

    protected void setWeekStartOn(String value) {
        value = value + "-wst";
        this.getUIFormSelectBox(WEEK_START_ON).setValue(value);
    }

    protected String getDateFormat() {
        return (String)this.getUIFormSelectBox(DATE_FORMAT).getValue();
    }

    protected void setDateFormat(String value) {
        this.getUIFormSelectBox(DATE_FORMAT).setValue(value);
    }

    protected String getTimeFormat() {
        if ("AM/PM".equals(this.getUIFormSelectBox(TIME_FORMAT).getValue())) {
            return "hh:mm a";
        }
        return "HH:mm";
    }

    protected void setTimeFormat(String value) {
        if ("hh:mm a".endsWith(value)) {
            this.getUIFormSelectBox(TIME_FORMAT).setValue("AM/PM");
        } else {
            this.getUIFormSelectBox(TIME_FORMAT).setValue("24-Hours");
        }
    }

    protected String getLocale() {
        return (String)this.getUIFormSelectBox(LOCATION).getValue();
    }

    protected void setLocale(String value) {
        this.getUIFormSelectBox(LOCATION).setValue(value);
    }

    protected String getTimeZone() {
        return (String)this.getUIFormSelectBox(TIMEZONE).getValue();
    }

    protected void setTimeZone(String value) {
        this.getUIFormSelectBox(TIMEZONE).setValue(value);
    }

    protected boolean getShowWorkingTimes() {
        return this.getUIFormCheckBoxInput(ISSHOWWORKINGTIME).isChecked();
    }

    protected void setShowWorkingTimes(boolean value) {
        this.getUIFormCheckBoxInput(ISSHOWWORKINGTIME).setChecked(value);
    }

    protected String getWorkingBegin() throws Exception {
        return (String)this.getUIFormSelectBox(WORKINGTIME_BEGIN).getValue();
    }

    protected String getWorkingBegin(Locale locale) throws Exception {
        Calendar cal = CalendarUtils.getInstanceTempCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
        SimpleDateFormat timeFormat = new SimpleDateFormat(this.getTimeFormat());
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(CalendarUtils.DATETIMEFORMAT);
        dateFormat.setCalendar(cal);
        timeFormat.setCalendar(cal);
        dateTimeFormat.setCalendar(cal);
        String value = (String)this.getUIFormSelectBox(WORKINGTIME_BEGIN).getValue();
        String date = dateFormat.format(cal.getTime()) + " " + value;
        cal.setTime(dateTimeFormat.parse(date));
        return timeFormat.format(cal.getTime());
    }

    protected Date getWorkingBeginTime() throws Exception {
        Calendar cal = CalendarUtils.getBeginDay((Calendar)CalendarUtils.getInstanceTempCalendar());
        SimpleDateFormat dateFormat = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(CalendarUtils.DATETIMEFORMAT);
        String value = (String)this.getUIFormSelectBox(WORKINGTIME_BEGIN).getValue();
        String date = dateFormat.format(cal.getTime()) + " " + value;
        cal.setTime(dateTimeFormat.parse(date));
        return cal.getTime();
    }

    protected Date getWorkingBeginTime(Locale locale) throws Exception {
        Calendar cal = CalendarUtils.getBeginDay((Calendar)CalendarUtils.getInstanceTempCalendar());
        SimpleDateFormat dateFormat = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(CalendarUtils.DATETIMEFORMAT);
        String value = (String)this.getUIFormSelectBox(WORKINGTIME_BEGIN).getValue();
        String date = dateFormat.format(cal.getTime()) + " " + value;
        cal.setTime(dateTimeFormat.parse(date));
        return cal.getTime();
    }

    protected void setWorkingBegin(String value, String format) throws Exception {
        this.getUIFormSelectBox(WORKINGTIME_BEGIN).setValue(value);
    }

    protected String getWorkingEnd() throws Exception {
        return (String)this.getUIFormSelectBox(WORKINGTIME_END).getValue();
    }

    protected Date getWorkingEndTime() throws Exception {
        Calendar cal = CalendarUtils.getBeginDay((Calendar)CalendarUtils.getInstanceTempCalendar());
        SimpleDateFormat dateFormat = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(CalendarUtils.DATETIMEFORMAT);
        dateFormat.setCalendar(cal);
        dateTimeFormat.setCalendar(cal);
        String value = (String)this.getUIFormSelectBox(WORKINGTIME_END).getValue();
        String date = dateFormat.format(cal.getTime()) + " " + value;
        cal.setTime(dateTimeFormat.parse(date));
        return cal.getTime();
    }

    protected void setWorkingEnd(String value, String format) throws Exception {
        this.getUIFormSelectBox(WORKINGTIME_END).setValue(value);
    }

    public List<SelectItemOption<String>> getTimeZones(String locale) {
        return CalendarUtils.getTimeZoneSelectBoxOptions((String[])TimeZone.getAvailableIDs());
    }

    private List<SelectItemOption<String>> getLocales() {
        return CalendarUtils.getLocaleSelectBoxOptions((Locale[])Calendar.getAvailableLocales());
    }
}

