/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UIFormComboBox;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UIQuickAddEvent;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIQuickAddEvent.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={MoreDetailActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIQuickAddEvent
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_EVENT = "eventName".intern();
    public static final String FIELD_CALENDAR = "calendar".intern();
    public static final String FIELD_CATEGORY = "category".intern();
    public static final String FIELD_FROM = "from".intern();
    public static final String FIELD_TO = "to".intern();
    public static final String FIELD_FROM_TIME = "fromTime".intern();
    public static final String FIELD_TO_TIME = "toTime".intern();
    public static final String FIELD_ALLDAY = "allDay".intern();
    public static final String FIELD_DESCRIPTION = "description".intern();
    public static final String UIQUICKADDTASK = "UIQuickAddTask".intern();
    private String calType_ = "0".intern();
    private boolean isEvent_ = true;

    public UIQuickAddEvent() throws Exception {
        ArrayList options = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_EVENT, FIELD_EVENT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESCRIPTION, FIELD_DESCRIPTION, null));
        this.addUIFormInput((UIFormInput)new UIFormDateTimePicker(FIELD_FROM, FIELD_FROM, new Date(), false).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormDateTimePicker(FIELD_TO, FIELD_TO, new Date(), false).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormComboBox(FIELD_FROM_TIME, FIELD_FROM_TIME, options));
        this.addUIFormInput((UIFormInput)new UIFormComboBox(FIELD_TO_TIME, FIELD_TO_TIME, options));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_ALLDAY, FIELD_ALLDAY, (Object)false));
        this.addUIFormInput((UIFormInput)new UIFormSelectBoxWithGroups(FIELD_CALENDAR, FIELD_CALENDAR, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_CATEGORY, FIELD_CATEGORY, UIEventForm.getCategory()));
    }

    public UIFormComboBox getUIFormCombobox(String name) {
        return (UIFormComboBox)this.findComponentById(name);
    }

    public void init(CalendarSetting calendarSetting, String startTime, String endTime) throws Exception {
        List fromOptions = CalendarUtils.getTimesSelectBoxOptions((String)calendarSetting.getTimeFormat(), (String)calendarSetting.getTimeFormat(), (long)calendarSetting.getTimeInterval());
        List toOptions = CalendarUtils.getTimesSelectBoxOptions((String)calendarSetting.getTimeFormat(), (String)calendarSetting.getTimeFormat(), (long)calendarSetting.getTimeInterval());
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)this.getChildById(FIELD_FROM);
        fromField.setDateFormatStyle(calendarSetting.getDateFormat());
        UIFormDateTimePicker toField = (UIFormDateTimePicker)this.getChildById(FIELD_TO);
        toField.setDateFormatStyle(calendarSetting.getDateFormat());
        this.getUIFormCombobox(FIELD_FROM_TIME).setOptions(fromOptions);
        this.getUIFormCombobox(FIELD_TO_TIME).setOptions(toOptions);
        UIMiniCalendar miniCalendar = (UIMiniCalendar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
        Calendar cal = CalendarUtils.getInstanceTempCalendar();
        cal.setTime(miniCalendar.getCurrentCalendar().getTime());
        if (startTime != null) {
            cal.setTimeInMillis(Long.parseLong(startTime));
        }
        Long begingMinute = (long)cal.get(12) / calendarSetting.getTimeInterval() * calendarSetting.getTimeInterval();
        cal.set(12, begingMinute.intValue());
        this.setEventFromDate(cal.getTime(), calendarSetting.getDateFormat(), calendarSetting.getTimeFormat());
        if (endTime != null) {
            cal.setTimeInMillis(Long.parseLong(endTime));
        } else {
            cal.add(12, (int)calendarSetting.getTimeInterval() * 2);
        }
        this.setEventToDate(cal.getTime(), calendarSetting.getDateFormat(), calendarSetting.getTimeFormat());
    }

    private void setEventFromDate(Date value, String dateFormat, String timeFormat) {
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)this.getChildById(FIELD_FROM);
        UIFormComboBox timeFile = (UIFormComboBox)this.getChildById(FIELD_FROM_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        fromField.setValue((Object)df.format(value));
        SimpleDateFormat tf = new SimpleDateFormat(timeFormat, locale);
        timeFile.setValue((Object)tf.format(value));
    }

    private Date getEventFromDate(String dateFormat, String timeFormat) throws Exception {
        try {
            UIFormDateTimePicker fromField = (UIFormDateTimePicker)this.getChildById(FIELD_FROM);
            UIFormComboBox timeFile = (UIFormComboBox)this.getChildById(FIELD_FROM_TIME);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            Locale locale = context.getParentAppRequestContext().getLocale();
            if (this.getIsAllDay()) {
                SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
                df.setCalendar(CalendarUtils.getInstanceTempCalendar());
                return CalendarUtils.getBeginDay((Date)df.parse((String)fromField.getValue())).getTime();
            }
            SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
            df.setCalendar(CalendarUtils.getInstanceTempCalendar());
            return df.parse((String)fromField.getValue() + " " + (String)timeFile.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setEventToDate(Date value, String dateFormat, String timeFormat) {
        UIFormDateTimePicker toField = (UIFormDateTimePicker)this.getChildById(FIELD_TO);
        UIFormComboBox timeField = (UIFormComboBox)this.getChildById(FIELD_TO_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        toField.setValue((Object)df.format(value));
        SimpleDateFormat tf = new SimpleDateFormat(timeFormat, locale);
        timeField.setValue((Object)tf.format(value));
    }

    private Date getEventToDate(String dateFormat, String timeFormat) throws Exception {
        try {
            UIFormDateTimePicker toField = (UIFormDateTimePicker)this.getChildById(FIELD_TO);
            UIFormComboBox timeFile = (UIFormComboBox)this.getChildById(FIELD_TO_TIME);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            Locale locale = context.getParentAppRequestContext().getLocale();
            if (this.getIsAllDay()) {
                SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
                df.setCalendar(CalendarUtils.getInstanceTempCalendar());
                return CalendarUtils.getEndDay((Date)df.parse((String)toField.getValue())).getTime();
            }
            SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
            df.setCalendar(CalendarUtils.getInstanceTempCalendar());
            return df.parse((String)toField.getValue() + " " + (String)timeFile.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<SelectItem> getCalendars() throws Exception {
        return CalendarUtils.getCalendarOption();
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    private String getEventSummary() {
        return (String)this.getUIStringInput(FIELD_EVENT).getValue();
    }

    private String getEventDescription() {
        return (String)this.getUIFormTextAreaInput(FIELD_DESCRIPTION).getValue();
    }

    private boolean getIsAllDay() {
        return this.getUIFormCheckBoxInput(FIELD_ALLDAY).isChecked();
    }

    public void setIsAllday(boolean isChecked) {
        this.getUIFormCheckBoxInput(FIELD_ALLDAY).setChecked(isChecked);
    }

    private String getEventCalendar() {
        String values = (String)this.getUIFormSelectBoxGroup(FIELD_CALENDAR).getValue();
        if (values != null && values.trim().length() > 0 && values.split(CalendarUtils.COLON).length > 0) {
            this.calType_ = values.split(CalendarUtils.COLON)[0];
            return values.split(CalendarUtils.COLON)[1];
        }
        return null;
    }

    public void setSelectedCalendar(String value) {
        value = this.calType_ + CalendarUtils.COLON + value;
        this.getUIFormSelectBoxGroup(FIELD_CALENDAR).setValue(value);
    }

    public UIFormSelectBoxWithGroups getUIFormSelectBoxGroup(String id) {
        return (UIFormSelectBoxWithGroups)this.findComponentById(id);
    }

    public void setSelectedCategory(String value) {
        this.getUIFormSelectBox(FIELD_CATEGORY).setValue(value);
    }

    private String getEventCategory() {
        return (String)this.getUIFormSelectBox(FIELD_CATEGORY).getValue();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setEvent(boolean isEvent) {
        this.isEvent_ = isEvent;
    }

    public boolean isEvent() {
        return this.isEvent_;
    }

    public void update(String calType, List<SelectItem> options) throws Exception {
        if (options != null) {
            this.getUIFormSelectBoxGroup(FIELD_CALENDAR).setOptions(options);
        } else {
            this.getUIFormSelectBoxGroup(FIELD_CALENDAR).setOptions(this.getCalendars());
        }
        this.calType_ = calType;
    }

    static /* synthetic */ String access$000(UIQuickAddEvent x0) {
        return x0.getEventSummary();
    }

    static /* synthetic */ String access$100(UIQuickAddEvent x0) {
        return x0.getEventDescription();
    }

    static /* synthetic */ String access$200(UIQuickAddEvent x0) {
        return x0.getEventCalendar();
    }

    static /* synthetic */ String access$300(UIQuickAddEvent x0) {
        return x0.getEventCategory();
    }

    static /* synthetic */ Date access$400(UIQuickAddEvent x0, String x1, String x2) throws Exception {
        return x0.getEventFromDate(x1, x2);
    }

    static /* synthetic */ Date access$500(UIQuickAddEvent x0, String x1, String x2) throws Exception {
        return x0.getEventToDate(x1, x2);
    }

    static /* synthetic */ boolean access$600(UIQuickAddEvent x0) {
        return x0.getIsAllDay();
    }

    static /* synthetic */ boolean access$700(UIQuickAddEvent x0) {
        return x0.isEvent_;
    }

    static /* synthetic */ String access$800(UIQuickAddEvent x0) {
        return x0.calType_;
    }
}

