/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIWeekView;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIWeekView.gtmpl", events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.AddCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.QuickAddActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UpdateEventActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={SaveEventActionListener.class})})
public class UIWeekView
extends UICalendarView {
    protected Map<String, Map<String, CalendarEvent>> eventData_ = new HashMap();
    protected LinkedHashMap<String, CalendarEvent> allWeekData_ = new LinkedHashMap();
    protected LinkedHashMap<String, CalendarEvent> dataMap_ = new LinkedHashMap();
    protected List<CalendarEvent> daysData_ = new ArrayList();
    protected boolean isShowCustomView_ = false;
    protected Date beginDate_;
    protected Date endDate_;

    public void refresh() throws Exception {
        this.eventData_.clear();
        this.allWeekData_.clear();
        int i = 0;
        Calendar c = this.getBeginDateOfWeek();
        int maxDay = 7;
        if (this.isShowCustomView_) {
            maxDay = 5;
        }
        while (i++ < maxDay) {
            HashMap list = new HashMap();
            String key = this.keyGen(c.get(5), c.get(2), c.get(1));
            this.eventData_.put(key, list);
            c.add(5, 1);
        }
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfWeek());
        eventQuery.setToDate(this.getEndDateOfWeek());
        List allEvents = calendarService.getEvents(username, eventQuery, this.getPublicCalendars());
        Iterator iter = allEvents.iterator();
        while (iter.hasNext()) {
            CalendarEvent event = (CalendarEvent)iter.next();
            Date beginEvent = event.getFromDateTime();
            Date endEvent = event.getToDateTime();
            long eventAmount = endEvent.getTime() - beginEvent.getTime();
            i = 0;
            c = this.getBeginDateOfWeek();
            while (i++ < maxDay) {
                String key = this.keyGen(c.get(5), c.get(2), c.get(1));
                if (this.isSameDate(c.getTime(), beginEvent) && this.isSameDate(c.getTime(), endEvent) && eventAmount < 84960000L) {
                    ((Map)this.eventData_.get(key)).put(event.getId(), event);
                    iter.remove();
                }
                c.add(5, 1);
            }
        }
        for (CalendarEvent ce : allEvents) {
            this.allWeekData_.put(ce.getId(), ce);
        }
    }

    public Calendar getBeginDateOfWeek() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        if (this.isShowCustomView_) {
            temCal.setFirstDayOfWeek(1);
        } else {
            temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        }
        if (temCal.getFirstDayOfWeek() > this.calendar_.get(7)) {
            temCal.set(3, this.getCurrentWeek() - 1);
        } else {
            temCal.set(3, this.getCurrentWeek());
        }
        temCal.setTime(this.calendar_.getTime());
        int amout = temCal.getFirstDayOfWeek() - this.calendar_.get(7);
        if (this.isShowCustomView_) {
            ++amout;
        }
        temCal.add(5, amout);
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfWeek() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        if (this.isShowCustomView_) {
            temCal.setFirstDayOfWeek(1);
        } else {
            temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        }
        temCal.setTime(this.getBeginDateOfWeek().getTime());
        int amout = 6;
        if (this.isShowCustomView_) {
            amout -= 2;
        }
        temCal.add(5, amout);
        return this.getEndDay(temCal);
    }

    protected Map<String, Map<String, CalendarEvent>> getEventData() {
        return this.eventData_;
    }

    protected LinkedHashMap<String, CalendarEvent> getEventList() {
        return this.allWeekData_;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        LinkedHashMap<String, CalendarEvent> dataMap = new LinkedHashMap<String, CalendarEvent>();
        dataMap.putAll(this.allWeekData_);
        for (String key : this.eventData_.keySet()) {
            dataMap.putAll((Map)this.eventData_.get(key));
        }
        return dataMap;
    }

    public boolean isShowCustomView() {
        return this.isShowCustomView_;
    }
}

