/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIMonthView;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIMonthView.gtmpl", events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.ChangeCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.EventSelectActionListener.class}), @EventConfig(listeners={UICalendarView.AddCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={QuickAddActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={UpdateEventActionListener.class})})
public class UIMonthView
extends UICalendarView {
    private LinkedHashMap<String, CalendarEvent> dataMap_ = new LinkedHashMap();

    protected int getWeeksOfTheMonth(int year, int month, int day) {
        Calendar cal = this.getInstanceTempCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getActualMaximum(4);
    }

    public void refresh() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfMonthView());
        eventQuery.setToDate(this.getEndDateOfMonthView());
        List allEvents = calendarService.getEvents(username, eventQuery, this.getPublicCalendars());
        Iterator childIter = this.getChildren().iterator();
        while (childIter.hasNext()) {
            UIComponent comp = (UIComponent)childIter.next();
            if (!(comp instanceof UIFormCheckBoxInput)) continue;
            childIter.remove();
        }
        this.dataMap_.clear();
        Iterator eventIter = allEvents.iterator();
        while (eventIter.hasNext()) {
            CalendarEvent ce = (CalendarEvent)eventIter.next();
            this.dataMap_.put(ce.getId(), ce);
            UIFormCheckBoxInput input = new UIFormCheckBoxInput(ce.getId(), ce.getId(), (Object)false);
            input.setBindingField(ce.getCalendarId());
            this.addChild((UIComponent)input);
            eventIter.remove();
        }
    }

    public Calendar getBeginDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonth();
        temCal.setFirstDayOfWeek(1);
        int amount = temCal.getFirstDayOfWeek() - temCal.get(7);
        temCal.add(5, amount);
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonthView();
        temCal.setFirstDayOfWeek(1);
        temCal.add(5, this.getWeeksOfTheMonth(this.getCurrentYear(), this.getCurrentMonth(), 1) * 7);
        return this.getBeginDay(temCal);
    }

    public Calendar getBeginDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.setFirstDayOfWeek(1);
        temCal.set(5, 1);
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.setFirstDayOfWeek(1);
        temCal.set(5, this.getDaysInMonth());
        return this.getEndDay(temCal);
    }

    protected List<CalendarEvent> getSelectedEvents() {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String id : this.dataMap_.keySet()) {
            UIFormCheckBoxInput checkbox = (UIFormCheckBoxInput)this.getChildById(id);
            if (checkbox == null || !checkbox.isChecked()) continue;
            events.add((CalendarEvent)this.dataMap_.get(id));
        }
        return events;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        return this.dataMap_;
    }
}

