/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.webui.popup.UIAddressForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIAddressForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ReplaceActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_KEYWORD = "keyWord".intern();
    public static final String FIELD_GROUP = "group".intern();
    private String recipientsType = "";
    protected String selectedAddressId_ = "";
    private UIPageIterator uiPageIterator_;
    protected String[] actions_ = new String[]{"Add", "Replace", "Cancel"};
    public List<String> checkedList_ = new ArrayList();

    public void setRecipientsType(String type) {
        this.recipientsType = type;
    }

    public String getRecipientType() {
        return this.recipientsType;
    }

    public UIAddressForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        UIFormSelectBox fieldGroup = new UIFormSelectBox(FIELD_GROUP, FIELD_GROUP, this.getGroups());
        fieldGroup.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)fieldGroup);
        this.uiPageIterator_ = new UIPageIterator();
        this.uiPageIterator_.setId("UICalendarAddressPage");
    }

    private List<SelectItemOption<String>> getGroups() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ContactService contactService = (ContactService)this.getApplicationComponent(ContactService.class);
        options.add(new SelectItemOption("all", (Object)""));
        for (AddressBook cg : contactService.getGroups(CalendarUtils.getCurrentUser())) {
            options.add(new SelectItemOption(cg.getName(), (Object)cg.getId()));
        }
        List addressList = contactService.getSharedAddressBooks(CalendarUtils.getCurrentUser());
        for (SharedAddressBook sa : addressList) {
            String name = "";
            if (!CalendarUtils.isEmpty((String)sa.getSharedUserId())) {
                name = sa.getSharedUserId() + "-";
            }
            options.add((SelectItemOption<String>)new SelectItemOption(name + sa.getName(), (Object)sa.getId()));
        }
        List publicAddressBookIds = contactService.getAllsPublicAddressBookIds(CalendarUtils.getCurrentUser());
        if (!publicAddressBookIds.isEmpty()) {
            for (String publicCg : publicAddressBookIds) {
                options.add((SelectItemOption<String>)new SelectItemOption(CalendarUtils.getOrganizationService().getGroupHandler().findGroupById(publicCg).getGroupName(), (Object)publicCg));
            }
        }
        return options;
    }

    public String[] getActions() {
        return this.actions_;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
        this.actions_ = new String[]{"Add", "Replace", "Cancel"};
    }

    public List<ContactData> getContacts() throws Exception {
        for (String id : this.checkedList_) {
            UIFormCheckBoxInput uiInput = this.getUIFormCheckBoxInput(id);
            if (uiInput == null) continue;
            uiInput.setChecked(true);
        }
        return new ArrayList<ContactData>(this.uiPageIterator_.getCurrentPageData());
    }

    public void setContactList(String groupId) throws Exception {
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ContactFilter filter = new ContactFilter();
        if (!CalendarUtils.isEmpty((String)groupId)) {
            filter.setCategories(new String[]{groupId});
        }
        Map resultMap = contactSrv.searchEmails(CalendarUtils.getCurrentUser(), filter);
        ArrayList<ContactData> data2 = new ArrayList<ContactData>();
        Iterator i$ = resultMap.keySet().iterator();
        while (i$.hasNext()) {
            String ct;
            String id = ct = (String)i$.next();
            String value = (String)resultMap.get(id);
            if (resultMap.get(id) == null || ((String)resultMap.get(id)).trim().length() <= 0 || value.lastIndexOf(Utils.SPLIT) <= 0) continue;
            String fullName = value.substring(0, value.lastIndexOf(Utils.SPLIT));
            String email = value.substring(value.lastIndexOf(Utils.SPLIT) + Utils.SPLIT.length());
            if (CalendarUtils.isEmpty((String)email)) continue;
            data2.add(new ContactData(this, id, fullName, email));
        }
        this.setContactList(data2);
    }

    public void setContactList(ContactFilter filter) throws Exception {
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        Map resultMap = contactSrv.searchEmails(CalendarUtils.getCurrentUser(), filter);
        ArrayList<ContactData> data2 = new ArrayList<ContactData>();
        Iterator i$ = resultMap.keySet().iterator();
        while (i$.hasNext()) {
            String ct;
            String id = ct = (String)i$.next();
            String value = (String)resultMap.get(id);
            if (resultMap.get(id) == null || ((String)resultMap.get(id)).trim().length() <= 0 || value.lastIndexOf(Utils.SPLIT) <= 0) continue;
            String fullName = value.substring(0, value.lastIndexOf(Utils.SPLIT));
            String email = value.substring(value.lastIndexOf(Utils.SPLIT) + Utils.SPLIT.length());
            if (CalendarUtils.isEmpty((String)email)) continue;
            data2.add(new ContactData(this, id, fullName, email));
        }
        this.setContactList(data2);
    }

    public List<ContactData> getContactList() {
        try {
            return this.uiPageIterator_.getPageList().getAll();
        }
        catch (Exception e) {
            return new ArrayList<ContactData>();
        }
    }

    public void setContactList(List<ContactData> contactList) throws Exception {
        this.getUIFormSelectBox(FIELD_GROUP).setOptions(this.getGroups());
        ObjectPageList objPageList = new ObjectPageList(contactList, 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
        for (ContactData contact : contactList) {
            UIFormCheckBoxInput uiCheckbox = this.getUIFormCheckBoxInput(contact.getId());
            if (uiCheckbox != null) continue;
            uiCheckbox = new UIFormCheckBoxInput(contact.getId(), contact.getId(), (Object)false);
            this.addUIFormInput((UIFormInput)uiCheckbox);
        }
    }

    public List<ContactData> getCheckedContact() throws Exception {
        ArrayList<ContactData> contactList = new ArrayList<ContactData>();
        for (ContactData contact : new ArrayList(this.uiPageIterator_.getCurrentPageData())) {
            UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            contactList.add(contact);
        }
        return contactList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public long getAvailablePage() {
        return this.uiPageIterator_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageIterator_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageIterator_.setCurrentPage(page);
    }
}

