/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.webui.popup.UIAddEditPermission;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISharedForm;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIEventCategoryManager.msg.confirm-delete")})
public class UIAddEditPermission
extends UIContainer
implements UIPopupComponent {
    public static String[] BEAN_FIELD = new String[]{"viewPermission", "editPermission"};
    private static String[] ACTION = new String[]{"Edit", "Delete"};
    private String calendarId_ = null;

    public UIAddEditPermission() throws Exception {
        this.setName("UIAddEditPermission");
        UIGrid permissionList = (UIGrid)this.addChild(UIGrid.class, null, "PermissionList");
        permissionList.configure("viewPermission", BEAN_FIELD, ACTION);
        permissionList.getUIPageIterator().setId("PermissionListIterator");
        this.addChild(UISharedForm.class, null, null);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void init(String username, Calendar cal, boolean isAddNew) throws Exception {
        UISharedForm shareForm = (UISharedForm)this.getChild(UISharedForm.class);
        shareForm.init(username, cal, isAddNew);
        this.updateGrid(cal, 1);
        this.calendarId_ = cal.getId();
    }

    public int getCurrentPage() throws Exception {
        UIGrid permissionList = (UIGrid)this.getChild(UIGrid.class);
        return permissionList.getUIPageIterator().getCurrentPage();
    }

    public void updateGrid(Calendar cal, int currentPage) throws Exception {
        ArrayList<data> dataRow = new ArrayList<data>();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        if (cal.getViewPermission() != null) {
            for (String username : cal.getViewPermission()) {
                boolean canEdit = cal.getEditPermission() != null && Arrays.asList(cal.getEditPermission()).contains(username);
                String label = this.getId() + ".label." + String.valueOf(canEdit);
                String editPerm = String.valueOf(canEdit);
                try {
                    editPerm = res.getString(label);
                }
                catch (Exception e) {
                    System.out.println("Can not find " + label);
                }
                dataRow.add(new data(this, username, editPerm));
            }
        }
        Collections.sort(dataRow, new UserDataComparator());
        UIGrid permissionList = (UIGrid)this.getChild(UIGrid.class);
        ObjectPageList objPageList = new ObjectPageList(dataRow, 10);
        permissionList.getUIPageIterator().setPageList((PageList)objPageList);
        if (currentPage > 1 && currentPage <= permissionList.getUIPageIterator().getAvailablePage()) {
            permissionList.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    static /* synthetic */ String access$000(UIAddEditPermission x0) {
        return x0.calendarId_;
    }
}

