/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.io.Writer;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.webui.popup.UICalendarCategoryForm;
import org.exoplatform.calendar.webui.popup.UICalendarCategoryManager;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UICalendarCategoryManager.msg.confirm-delete")})
public class UICalendarCategoryManager
extends UIContainer
implements UIPopupComponent {
    public static String[] BEAN_FIELD = new String[]{"name"};
    private static String[] ACTION = new String[]{"Edit", "Delete"};

    public UICalendarCategoryManager() throws Exception {
        this.setName("UICalendarCategoryManager");
        UIGrid categoryList = (UIGrid)this.addChild(UIGrid.class, null, "UICategoryList");
        categoryList.configure("id", BEAN_FIELD, ACTION);
        categoryList.getUIPageIterator().setId("CategoryIterator");
        this.addChild(UICalendarCategoryForm.class, null, null);
        this.updateGrid();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<div id=\"UICalendarCategoryManager\" class=\"UICalendarCategoryManager\">");
        this.renderChildren();
        w.write("</div>");
    }

    public void updateGrid() throws Exception {
        CalendarService calService = (CalendarService)this.getApplicationComponent(CalendarService.class);
        String username = CalendarUtils.getCurrentUser();
        List categories = calService.getCategories(username);
        for (CalendarCategory calendarCategory : categories) {
            if (!calendarCategory.getId().equals("defaultCalendarCategoryId") || !calendarCategory.getName().equals("defaultCalendarCategoryName")) continue;
            String newName = CalendarUtils.getResourceBundle((String)"UICalendars.label.defaultCalendarCategoryId");
            calendarCategory.setName(newName);
        }
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        ObjectPageList objPageList = new ObjectPageList(categories, 20);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public void resetForm() {
        ((UICalendarCategoryForm)this.getChild(UICalendarCategoryForm.class)).reset();
    }
}

