/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.calendar.webui.CalendarView;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.calendar.webui.UIPreview;
import org.exoplatform.calendar.webui.popup.UIAttachFileForm;
import org.exoplatform.calendar.webui.popup.UIEventAttenderTab;
import org.exoplatform.calendar.webui.popup.UIEventDetailTab;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIEventReminderTab;
import org.exoplatform.calendar.webui.popup.UIEventShareTab;
import org.exoplatform.calendar.webui.popup.UIPopupAction;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.BufferAttachment;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.mail.impl.MailServiceImpl;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveEmailActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MoveNextActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MovePreviousActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddEmailAddressActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DownloadAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddParticipantActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmOKActionListener.class}, name="ConfirmOK", phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmCancelActionListener.class}, name="ConfirmCancel", phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIPopupWindowAddUserEventForm", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UIEventForm
extends UIFormTabPane
implements UIPopupComponent,
UISelector {
    public static final Log log = ExoLogger.getLogger(UIEventForm.class);
    public static final String TAB_EVENTDETAIL = "eventDetail".intern();
    public static final String TAB_EVENTREMINDER = "eventReminder".intern();
    public static final String TAB_EVENTSHARE = "eventShare".intern();
    public static final String TAB_EVENTATTENDER = "eventAttender".intern();
    public static final String FIELD_MEETING = "participant".intern();
    public static final String FIELD_ISSENDMAIL = "isSendMail".intern();
    public static final String ITEM_PUBLIC = "public".intern();
    public static final String ITEM_PRIVATE = "private".intern();
    public static final String ITEM_AVAILABLE = "available".intern();
    public static final String ITEM_BUSY = "busy".intern();
    public static final String ITEM_OUTSIDE = "outside".intern();
    public static final String ITEM_REPEAT = "true".intern();
    public static final String ITEM_UNREPEAT = "false".intern();
    public static final String ITEM_ALWAYS = "always".intern();
    public static final String ITEM_NERVER = "never".intern();
    public static final String ITEM_ASK = "ask".intern();
    public static final String ACT_REMOVE = "RemoveAttachment".intern();
    public static final String ACT_DOWNLOAD = "DownloadAttachment".intern();
    public static final String ACT_ADDEMAIL = "AddEmailAddress".intern();
    public static final String ACT_ADDCATEGORY = "AddCategory".intern();
    public static final String STATUS_EMPTY = "".intern();
    public static final String STATUS_PENDING = "pending".intern();
    public static final String STATUS_YES = "yes".intern();
    public static final String STATUS_NO = "no".intern();
    private boolean isAddNew_ = true;
    private boolean isChangedSignificantly = false;
    private CalendarEvent calendarEvent_ = null;
    protected String calType_ = "0";
    protected String invitationMsg_ = "";
    protected String participantList_ = "";
    private String errorMsg_ = null;
    private String errorValues = null;
    protected Map<String, String> participants_ = new LinkedHashMap();
    protected Map<String, String> participantStatus_ = new LinkedHashMap();
    protected LinkedList<ParticipantStatus> participantStatusList_ = new LinkedList();
    private String oldCalendarId_ = null;
    private String newCalendarId_ = null;
    private String confirm_msg = "";

    public UIEventForm() throws Exception {
        super("UIEventForm");
        this.setId("UIEventForm");
        this.confirm_msg = "confirm-msg";
        try {
            this.confirm_msg = this.getLabel("confirm-msg");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UIEventDetailTab eventDetailTab = new UIEventDetailTab(TAB_EVENTDETAIL);
        this.addChild((UIComponent)eventDetailTab);
        UIEventReminderTab eventReminderTab = new UIEventReminderTab(TAB_EVENTREMINDER);
        this.addChild((UIComponent)eventReminderTab);
        UIEventShareTab eventShareTab = new UIEventShareTab(TAB_EVENTSHARE);
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE, UIEventShareTab.FIELD_SHARE, this.getShareValue()));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS, UIEventShareTab.FIELD_STATUS, this.getStatusValue()));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_SEND, UIEventShareTab.FIELD_SEND, CalendarUtils.getSendValue(null)));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormInputInfo(UIEventShareTab.FIELD_INFO, UIEventShareTab.FIELD_INFO, null));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MEETING, FIELD_MEETING, null));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addUser = new UIFormInputWithActions.ActionData();
        addUser.setActionListener("AddParticipant");
        addUser.setActionName("AddUser");
        addUser.setActionParameter(TAB_EVENTSHARE);
        addUser.setActionType(0);
        addUser.setCssIconClass("AddNewNodeIcon");
        actions.add(addUser);
        eventShareTab.setActionField(UIEventShareTab.FIELD_INFO, actions);
        this.addChild((UIComponent)eventShareTab);
        UIEventAttenderTab eventAttenderTab = new UIEventAttenderTab(TAB_EVENTATTENDER);
        this.addChild((UIComponent)eventAttenderTab);
        this.setSelectedTab(eventDetailTab.getId());
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            System.out.println("Can not find " + this.getId() + ".label." + id);
            return id;
        }
    }

    public void initForm(CalendarSetting calSetting, CalendarEvent eventCalendar, String formTime) throws Exception {
        this.reset();
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        ((UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM)).setDateFormatStyle(calSetting.getDateFormat());
        ((UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO)).setDateFormatStyle(calSetting.getDateFormat());
        UIEventAttenderTab attenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        List fromTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        List toTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME).setOptions(fromTimes);
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME).setOptions(toTimes);
        List fromOptions = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat());
        List toOptions = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat());
        attenderTab.getUIFormComboBox(UIEventAttenderTab.FIELD_FROM_TIME).setOptions(fromOptions);
        attenderTab.getUIFormComboBox(UIEventAttenderTab.FIELD_TO_TIME).setOptions(toOptions);
        if (eventCalendar != null) {
            this.isAddNew_ = false;
            this.calendarEvent_ = eventCalendar;
            this.setEventSumary(eventCalendar.getSummary());
            this.setEventDescription(eventCalendar.getDescription());
            this.setEventAllDate(CalendarUtils.isAllDayEvent((CalendarEvent)eventCalendar));
            this.setEventFromDate(eventCalendar.getFromDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventCheckTime(eventCalendar.getFromDateTime());
            this.setEventToDate(eventCalendar.getToDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setSelectedCalendarId(eventCalendar.getCalendarId());
            String eventCategoryId = eventCalendar.getEventCategoryId();
            if (!CalendarUtils.isEmpty((String)eventCategoryId)) {
                UIFormSelectBox selectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
                boolean hasEventCategory = false;
                for (SelectItemOption o : selectBox.getOptions()) {
                    if (!((String)o.getValue()).equals(eventCategoryId)) continue;
                    hasEventCategory = true;
                    break;
                }
                if (!hasEventCategory) {
                    selectBox.getOptions().add(new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCategoryId));
                }
                this.setSelectedCategory(eventCategoryId);
            }
            this.setEventPlace(eventCalendar.getLocation());
            this.setEventRepeat(eventCalendar.getRepeatType());
            this.setSelectedEventPriority(eventCalendar.getPriority());
            if (eventCalendar.getReminders() != null) {
                this.setEventReminders(eventCalendar.getReminders());
            }
            this.setAttachments(eventCalendar.getAttachment());
            if (eventCalendar.isPrivate()) {
                this.setSelectedShareType(ITEM_PRIVATE);
            } else {
                this.setSelectedShareType(ITEM_PUBLIC);
            }
            this.setSendOption(eventCalendar.getSendOption());
            this.setMessage(eventCalendar.getMessage());
            this.setParticipantStatusValues(eventCalendar.getParticipantStatus());
            ((UIEventShareTab)this.getChild(UIEventShareTab.class)).setParticipantStatusList((List)this.participantStatusList_);
            this.setSelectedEventState(eventCalendar.getEventState());
            this.setMeetingInvitation(eventCalendar.getInvitation());
            StringBuffer pars = new StringBuffer();
            if (eventCalendar.getParticipant() != null) {
                for (String par : eventCalendar.getParticipant()) {
                    if (!CalendarUtils.isEmpty((String)pars.toString())) {
                        pars.append(CalendarUtils.BREAK_LINE);
                    }
                    pars.append(par);
                }
            }
            this.setParticipant(pars.toString());
            if (eventCategoryId != null) {
                UIFormSelectBox uiSelectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
                if (!this.isAddNew_ && !String.valueOf(0).equalsIgnoreCase(this.calType_)) {
                    SelectItemOption item = new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCalendar.getEventCategoryId());
                    uiSelectBox.getOptions().add(item);
                    uiSelectBox.setValue(eventCalendar.getEventCategoryId());
                    uiSelectBox.setDisabled(true);
                    eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setDisabled(true);
                    eventDetailTab.setActionField(UIEventDetailTab.FIELD_CATEGORY, null);
                }
            }
            attenderTab.calendar_.setTime(eventCalendar.getFromDateTime());
        } else {
            UIMiniCalendar miniCalendar = (UIMiniCalendar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
            java.util.Calendar cal = CalendarUtils.getInstanceOfCurrentCalendar();
            try {
                cal.setTimeInMillis(Long.parseLong(formTime));
            }
            catch (Exception e) {
                cal.setTime(miniCalendar.getCurrentCalendar().getTime());
            }
            Long beginMinute = (long)cal.get(12) / calSetting.getTimeInterval() * calSetting.getTimeInterval();
            cal.set(12, beginMinute.intValue());
            this.setEventFromDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventCheckTime(cal.getTime());
            cal.add(12, (int)calSetting.getTimeInterval() * 2);
            this.setEventToDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            StringBuffer pars = new StringBuffer(CalendarUtils.getCurrentUser());
            this.setMeetingInvitation(new String[]{CalendarUtils.getOrganizationService().getUserHandler().findUserByName(pars.toString()).getEmail()});
            this.setParticipant(pars.toString());
            this.setSendOption(calSetting.getSendOption());
            ((UIEventShareTab)this.getChild(UIEventShareTab.class)).setParticipantStatusList((List)this.participantStatusList_);
            attenderTab.updateParticipants(pars.toString());
        }
    }

    private void setEventCheckTime(Date time) {
        UIEventAttenderTab uiAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        uiAttenderTab.calendar_.setTime(time);
    }

    public void update(String calType, List<SelectItem> options) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        if (options != null) {
            uiEventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setOptions(options);
        } else {
            uiEventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setOptions(this.getCalendars());
        }
        this.calType_ = calType;
    }

    private List<SelectItem> getCalendars() throws Exception {
        return CalendarUtils.getCalendarOption();
    }

    public static List<SelectItemOption<String>> getCategory() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List eventCategories = calendarService.getEventCategories(CalendarUtils.getCurrentUser());
        for (EventCategory category : eventCategories) {
            boolean isDefaultEventCategory = false;
            for (int i = 0; i < NewUserListener.defaultEventCategoryIds.length; ++i) {
                if (!category.getId().equals(NewUserListener.defaultEventCategoryIds[i]) || !category.getName().equals(NewUserListener.defaultEventCategoryNames[i])) continue;
                isDefaultEventCategory = true;
                break;
            }
            if (isDefaultEventCategory) {
                String newName = CalendarUtils.getResourceBundle((String)("UICalendarView.label." + category.getId()), (String)category.getId());
                options.add((SelectItemOption<String>)new SelectItemOption(newName, (Object)category.getId()));
                continue;
            }
            options.add((SelectItemOption<String>)new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        return options;
    }

    protected void refreshCategory() throws Exception {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setOptions(UIEventForm.getCategory());
    }

    private List<SelectItemOption<String>> getShareValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(ITEM_PRIVATE, (Object)ITEM_PRIVATE));
        options.add(new SelectItemOption(ITEM_PUBLIC, (Object)ITEM_PUBLIC));
        return options;
    }

    private List<SelectItemOption<String>> getStatusValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(ITEM_BUSY, (Object)ITEM_BUSY));
        options.add(new SelectItemOption(ITEM_AVAILABLE, (Object)ITEM_AVAILABLE));
        options.add(new SelectItemOption(ITEM_OUTSIDE, (Object)ITEM_OUTSIDE));
        return options;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateSelect(String selectField, String value) throws Exception {
    }

    protected boolean isEventDetailValid(CalendarSetting calendarSetting) throws Exception {
        String dateFormat = calendarSetting.getDateFormat();
        String timeFormat = calendarSetting.getTimeFormat();
        Date from = null;
        Date to = null;
        if (CalendarUtils.isEmpty((String)this.getCalendarId())) {
            this.errorMsg_ = this.getId() + ".msg.event-calendar-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventCategory())) {
            this.errorMsg_ = this.getId() + ".msg.event-category-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventFormDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventToDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-todate-required";
            return false;
        }
        try {
            from = this.getEventFromDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fail to get event's from-date", (Throwable)e);
            }
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        try {
            to = this.getEventToDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fail to get event's to-date", (Throwable)e);
            }
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        if (from.after(to) || from.equals(to)) {
            this.errorMsg_ = "UIEventForm.msg.event-date-time-logic";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    private boolean isReminderValid() throws Exception {
        if (this.getEmailReminder()) {
            if (CalendarUtils.isEmpty((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-required";
                this.errorValues = "";
                return false;
            }
            if (!CalendarUtils.isValidEmailAddresses((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-invalid";
                this.errorValues = CalendarUtils.invalidEmailAddresses((String)this.getEmailAddress());
                return false;
            }
        }
        this.errorMsg_ = null;
        return true;
    }

    private boolean isParticipantValid() throws Exception {
        if (this.isSendMail() && this.getMeetingInvitation() == null) {
            this.errorMsg_ = "UIEventForm.msg.error-particimant-email-required";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    protected String getEventSumary() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).getValue();
    }

    protected void setEventSumary(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).setValue((Object)value);
    }

    protected String getEventDescription() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).getValue();
    }

    protected void setEventDescription(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).setValue((Object)value);
    }

    protected String getCalendarId() {
        String value;
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        this.newCalendarId_ = value = (String)eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            this.calType_ = value.split(CalendarUtils.COLON)[0];
            return value.split(CalendarUtils.COLON)[1];
        }
        return value;
    }

    public void setSelectedCalendarId(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        value = this.calType_ + CalendarUtils.COLON + value;
        eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setValue(value);
        this.oldCalendarId_ = value;
    }

    protected String getEventCategory() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).getValue();
    }

    public void setSelectedCategory(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setValue(value);
    }

    protected Date getEventFromDate(String dateFormat, String timeFormat) throws Exception {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.getEventAllDate()) {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
            df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
            return CalendarUtils.getBeginDay((Date)df.parse((String)fromField.getValue())).getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        return df.parse((String)fromField.getValue() + " " + (String)timeField.getValue());
    }

    protected String getEventFormDateValue() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        return (String)fromField.getValue();
    }

    protected void setEventFromDate(Date date, String dateFormat, String timeFormat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIEventAttenderTab eventAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        UIFormComboBox timeField = (UIFormComboBox)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        fromField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        timeField.setValue((Object)df.format(date));
        eventAttenderTab.setEventFromDate(date, timeFormat);
    }

    protected Date getEventToDate(String dateFormat, String timeFormat) throws Exception {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.getEventAllDate()) {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
            df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
            return CalendarUtils.getEndDay((Date)df.parse((String)toField.getValue())).getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        return df.parse((String)toField.getValue() + " " + (String)timeField.getValue());
    }

    protected void setEventToDate(Date date, String dateFormat, String timeFormat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIEventAttenderTab eventAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = (UIFormComboBox)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        toField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        timeField.setValue((Object)df.format(date));
        eventAttenderTab.setEventToDate(date, timeFormat);
    }

    protected String getEventToDateValue() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        return (String)toField.getValue();
    }

    protected boolean getEventAllDate() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).isChecked();
    }

    protected void setEventAllDate(boolean isCheckAll) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).setChecked(isCheckAll);
    }

    protected String getEventRepeat() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).getValue();
    }

    protected void setEventRepeat(String type) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).setValue(type);
    }

    protected String getEventPlace() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).getValue();
    }

    protected void setEventPlace(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).setValue((Object)value);
    }

    protected boolean getEmailReminder() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).isChecked();
    }

    public void setEmailReminder(boolean isChecked) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).setChecked(isChecked);
    }

    protected String getEmailRemindBefore() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).getValue();
    }

    protected boolean isEmailRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return Boolean.parseBoolean(eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.EMAIL_IS_REPEAT).getValue().toString());
    }

    public void setEmailRepeat(Boolean value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.EMAIL_IS_REPEAT).setChecked(value.booleanValue());
    }

    protected String getEmailRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).getValue();
    }

    protected void setEmailRepeatInterVal(long value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected Boolean isPopupRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return Boolean.parseBoolean(eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.POPUP_IS_REPEAT).getValue().toString());
    }

    protected void setPopupRepeat(Boolean value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.POPUP_IS_REPEAT).setChecked(value.booleanValue());
    }

    protected String getPopupRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
    }

    public void setEmailRemindBefore(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).setValue(value);
    }

    protected String getEmailAddress() throws Exception {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIStringInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).getValue();
    }

    public void setEmailAddress(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIStringInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).setValue((Object)value);
    }

    protected boolean getPopupReminder() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).isChecked();
    }

    protected void setPopupReminder(boolean isChecked) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).setChecked(isChecked);
    }

    protected String getPopupReminderTime() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).getValue();
    }

    protected void setPopupRemindBefore(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).setValue(value);
    }

    protected long getPopupReminderSnooze() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        try {
            String time = (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
            return Long.parseLong(time);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    protected List<org.exoplatform.calendar.service.Attachment> getAttachments(String eventId, boolean isAddNew) {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        return uiEventDetailTab.getAttachments();
    }

    protected long getTotalAttachment() {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        long attSize = 0L;
        for (org.exoplatform.calendar.service.Attachment att : uiEventDetailTab.getAttachments()) {
            attSize += att.getSize();
        }
        return attSize;
    }

    protected void setAttachments(List<org.exoplatform.calendar.service.Attachment> attachment) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        uiEventDetailTab.setAttachments(attachment);
        uiEventDetailTab.refreshUploadFileList();
    }

    protected void setPopupRepeatInterval(long value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected void setEventReminders(List<Reminder> reminders) {
        for (Reminder rm : reminders) {
            if (Reminder.TYPE_EMAIL.equals(rm.getReminderType())) {
                this.setEmailReminder(true);
                this.setEmailAddress(rm.getEmailAddress());
                this.setEmailRepeat(Boolean.valueOf(rm.isRepeat()));
                this.setEmailRemindBefore(String.valueOf(rm.getAlarmBefore()));
                this.setEmailRepeatInterVal(rm.getRepeatInterval());
                continue;
            }
            if (!Reminder.TYPE_POPUP.equals(rm.getReminderType())) continue;
            this.setPopupReminder(true);
            this.setPopupRepeat(Boolean.valueOf(rm.isRepeat()));
            this.setPopupRemindBefore(String.valueOf(rm.getAlarmBefore()));
            this.setPopupRepeatInterval(rm.getRepeatInterval());
        }
    }

    protected List<Reminder> getEventReminders(Date fromDateTime, List<Reminder> currentReminders) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        if (this.getEmailReminder()) {
            Reminder email = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_EMAIL)) continue;
                    email = rm;
                    break;
                }
            }
            email.setReminderType(Reminder.TYPE_EMAIL);
            email.setAlarmBefore(Long.parseLong(this.getEmailRemindBefore()));
            StringBuffer sbAddress = new StringBuffer();
            for (String s : this.getEmailAddress().replaceAll(CalendarUtils.SEMICOLON, CalendarUtils.COMMA).split(CalendarUtils.COMMA)) {
                if (sbAddress.indexOf(s = s.trim()) >= 0) continue;
                if (sbAddress.length() > 0) {
                    sbAddress.append(CalendarUtils.COMMA);
                }
                sbAddress.append(s);
            }
            email.setEmailAddress(sbAddress.toString());
            email.setRepeate(this.isEmailRepeat());
            email.setRepeatInterval(Long.parseLong(this.getEmailRepeatInterVal()));
            email.setFromDateTime(fromDateTime);
            if (!CalendarUtils.isEmpty((String)email.getEmailAddress())) {
                reminders.add(email);
            }
        }
        if (this.getPopupReminder()) {
            Reminder popup = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_POPUP)) continue;
                    popup = rm;
                    break;
                }
            }
            StringBuffer sb = new StringBuffer();
            boolean isExist = false;
            if (!isExist) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(CalendarUtils.getCurrentUser());
            }
            popup.setReminderOwner(sb.toString());
            popup.setReminderType(Reminder.TYPE_POPUP);
            popup.setAlarmBefore(Long.parseLong(this.getPopupReminderTime()));
            popup.setRepeate(this.isPopupRepeat().booleanValue());
            popup.setRepeatInterval(Long.parseLong(this.getPopupRepeatInterVal()));
            popup.setFromDateTime(fromDateTime);
            reminders.add(popup);
        }
        return reminders;
    }

    protected String getEventPriority() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).getValue();
    }

    protected void setSelectedEventPriority(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).setValue(value);
    }

    protected String getEventState() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS).getValue();
    }

    public void setSelectedEventState(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS).setValue((Object)value);
    }

    protected String getShareType() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE).getValue();
    }

    protected String getSendOption() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SEND).getValue();
    }

    protected void setSendOption(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SEND).setValue((Object)value);
    }

    public String getMessage() {
        return this.invitationMsg_;
    }

    public void setMessage(String invitationMsg) {
        this.invitationMsg_ = invitationMsg;
    }

    protected void setSelectedShareType(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE).setValue((Object)value);
    }

    protected String[] getMeetingInvitation() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        String invitation = (String)eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).getValue();
        if (CalendarUtils.isEmpty((String)invitation)) {
            return null;
        }
        return invitation.replace(CalendarUtils.SEMICOLON, CalendarUtils.COMMA).split(CalendarUtils.COMMA);
    }

    protected String getInvitationEmail() {
        StringBuilder buider = new StringBuilder("");
        for (Map.Entry par : this.participantStatus_.entrySet()) {
            if (buider.length() > 0 && ((String)par.getKey()).contains("@")) {
                buider.append(CalendarUtils.COMMA);
            }
            if (!((String)par.getKey()).contains("@")) continue;
            buider.append(((String)par.getKey()).substring(((String)par.getKey()).lastIndexOf(CalendarUtils.OPEN_PARENTHESIS) + 1).replace(CalendarUtils.CLOSE_PARENTHESIS, ""));
        }
        return buider.toString();
    }

    protected void setMeetingInvitation(String[] values) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            for (String s : values) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(s);
            }
        }
        eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).setValue((Object)sb.toString());
    }

    protected String getParticipantValues() {
        StringBuilder buider = new StringBuilder("");
        for (String par : this.participants_.keySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append(par);
        }
        return buider.toString();
    }

    protected String getParticipantStatusValues() {
        StringBuilder buider = new StringBuilder("");
        for (Map.Entry par : this.participantStatus_.entrySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append((String)par.getKey() + ":" + (String)par.getValue());
        }
        return buider.toString();
    }

    protected void setParticipantStatusValues(String[] values) throws Exception {
        this.participantStatus_.clear();
        this.participantStatusList_.clear();
        for (String par : values) {
            String[] entry = par.split(":");
            if (entry.length > 1) {
                this.participantStatus_.put(entry[0], entry[1]);
                this.participantStatusList_.add(new ParticipantStatus(this, entry[0], entry[1]));
                continue;
            }
            if (entry.length != 1) continue;
            this.participantStatus_.put(entry[0], STATUS_EMPTY);
            this.participantStatusList_.add(new ParticipantStatus(this, entry[0], STATUS_EMPTY));
        }
    }

    public void setParticipant(String values) throws Exception {
        OrganizationService orgService = CalendarUtils.getOrganizationService();
        StringBuffer sb = new StringBuffer();
        for (String s : values.split(CalendarUtils.BREAK_LINE)) {
            User user = orgService.getUserHandler().findUserByName(s);
            if (user == null) continue;
            this.participants_.put(s.trim(), user.getEmail());
            if (!CalendarUtils.isEmpty((String)sb.toString())) {
                sb.append(CalendarUtils.BREAK_LINE);
            }
            sb.append(s.trim());
        }
        ((UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER)).updateParticipants(this.getParticipantValues());
    }

    public String getParticipantStatus() {
        StringBuilder buider = new StringBuilder("");
        for (String par : this.participantStatus_.keySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append(par);
        }
        return buider.toString();
    }

    public void setParticipantStatus(String values) throws Exception {
        for (String s : values.split(CalendarUtils.BREAK_LINE)) {
            if (s.trim().length() <= 0 || this.participantStatus_.put(s.trim(), STATUS_EMPTY) != null) continue;
            this.participantStatusList_.add(new ParticipantStatus(this, s.trim(), STATUS_EMPTY));
        }
    }

    protected boolean isSendMail() {
        return false;
    }

    protected void sendMail(MailService svr, OrganizationService orSvr, CalendarSetting setting, Account acc, String fromId, String toId, CalendarEvent event) throws Exception {
        CalendarService calService;
        List atts = this.getAttachments(null, false);
        SimpleDateFormat df = new SimpleDateFormat(setting.getDateFormat() + " " + setting.getTimeFormat());
        User invitor = orSvr.getUserHandler().findUserByName(CalendarUtils.getCurrentUser());
        StringBuffer sbSubject = new StringBuffer("[" + this.getLabel("invitation") + "] ");
        sbSubject.append(event.getSummary());
        sbSubject.append(" ");
        sbSubject.append(df.format(event.getFromDateTime()));
        StringBuffer sbBody = new StringBuffer();
        sbBody.append("<div style=\"margin: 20px auto; padding: 8px; background: rgb(224, 236, 255) none repeat scroll 0%; -moz-background-clip: -moz-initial; -moz-background-origin: -moz-initial; -moz-background-inline-policy: -moz-initial; width: 400px;\">");
        sbBody.append("<table style=\"margin: 0px; padding: 0px; border-collapse: collapse; border-spacing: 0px; width: 100%; line-height: 16px;\">");
        sbBody.append("<tbody>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap; \">" + this.getLabel("fromWho") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> " + invitor.getUserName() + "(" + invitor.getEmail() + ")" + " </td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_MESSAGE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getMessage() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_EVENT) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getSummary() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_DESCRIPTION) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getDescription() != null && event.getDescription().trim().length() > 0 ? event.getDescription() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel("when") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> <div>" + this.getLabel(UIEventDetailTab.FIELD_FROM) + ": " + df.format(event.getFromDateTime()) + "</div>");
        sbBody.append("<div>" + this.getLabel(UIEventDetailTab.FIELD_TO) + ": " + df.format(event.getToDateTime()) + "</div></td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_PLACE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getLocation() != null && event.getLocation().trim().length() > 0 ? event.getLocation() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(FIELD_MEETING) + "</td>");
        toId = toId.replace(CalendarUtils.BREAK_LINE, CalendarUtils.COMMA);
        if (CalendarUtils.isEmpty((String)this.getInvitationEmail())) {
            sbBody.append("<td style=\"padding: 4px;\">" + toId + "</td>");
        } else {
            String newInvi = this.getInvitationEmail().replace(",", ", ");
            sbBody.append("<td style=\"padding: 4px;\">" + toId + ", " + newInvi + "</td>");
        }
        sbBody.append("</tr>");
        if (!atts.isEmpty()) {
            sbBody.append("<tr>");
            sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_ATTACHMENTS) + ":</td>");
            StringBuffer sbf = new StringBuffer();
            for (org.exoplatform.calendar.service.Attachment att : atts) {
                if (sbf.length() > 0) {
                    sbf.append(",");
                }
                sbf.append(att.getName());
            }
            sbBody.append("<td style=\"padding: 4px;\"> (" + atts.size() + ") " + sbf.toString() + " </td>");
            sbBody.append("</tr>");
        }
        sbBody.append("</tbody>");
        sbBody.append("</table>");
        sbBody.append("</div>");
        StringBuffer sbAddress = new StringBuffer();
        if (event.getInvitation() != null) {
            for (String s : event.getInvitation()) {
                s = s.trim();
                if (sbAddress.length() > 0) {
                    sbAddress.append(",");
                }
                sbAddress.append(s);
            }
        }
        OrganizationService orgService = CalendarUtils.getOrganizationService();
        StringBuffer sb = new StringBuffer();
        for (String s : toId.split(CalendarUtils.COMMA)) {
            User user = orgService.getUserHandler().findUserByName(s);
            if (user == null) continue;
            if (!CalendarUtils.isEmpty((String)sb.toString())) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(user.getEmail());
        }
        if (sbAddress.length() > 0 && sb.toString().trim().length() > 0) {
            sbAddress.append(",");
        }
        sbAddress.append(sb.toString().trim());
        StringBuffer values = new StringBuffer(fromId);
        User user = orSvr.getUserHandler().findUserByName(fromId);
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(toId);
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getCalType());
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getCalendarId());
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getId());
        if (acc != null) {
            org.exoplatform.mail.service.Message message = new org.exoplatform.mail.service.Message();
            message.setSubject(sbSubject.toString());
            message.setMessageBody(sbBody.toString());
            message.setMessageTo(sbAddress.toString());
            message.setContentType(org.exoplatform.mail.service.Utils.MIMETYPE_TEXTHTML);
            message.setFrom(user.getEmail());
            message.setHeader(CalendarUtils.EXO_INVITATION, values.toString());
            message.setSendDate(new Date());
            ArrayList<BufferAttachment> attachments = new ArrayList<BufferAttachment>();
            try {
                calService = CalendarUtils.getCalendarService();
                OutputStream out = calService.getCalendarImportExports(CalendarService.ICALENDAR).exportEventCalendar(fromId, event.getCalendarId(), event.getCalType(), event.getId());
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                BufferAttachment bf = new BufferAttachment();
                bf.setInputStream((InputStream)is);
                bf.setName("icalendar.ics");
                bf.setMimeType("text/calendar");
                attachments.add(bf);
                for (org.exoplatform.calendar.service.Attachment att : atts) {
                    bf = new BufferAttachment();
                    bf.setInputStream(att.getInputStream());
                    bf.setName(att.getName());
                    bf.setMimeType(att.getMimeType());
                    attachments.add(bf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            message.setAttachements(attachments);
            svr.sendMessage(user.getUserName(), acc.getId(), message);
            ContactService contactService = (ContactService)PortalContainer.getComponent(ContactService.class);
            contactService.saveAddress(CalendarUtils.getCurrentUser(), sbAddress.toString());
        } else {
            Message message = new Message();
            message.setSubject(sbSubject.toString());
            message.setBody(sbBody.toString());
            message.setTo(sbAddress.toString());
            message.setMimeType(org.exoplatform.mail.service.Utils.MIMETYPE_TEXTHTML);
            message.setFrom(user.getEmail());
            Attachment attachmentCal = new Attachment();
            try {
                calService = CalendarUtils.getCalendarService();
                OutputStream out = calService.getCalendarImportExports(CalendarService.ICALENDAR).exportEventCalendar(fromId, event.getCalendarId(), event.getCalType(), event.getId());
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                attachmentCal.setInputStream((InputStream)is);
                attachmentCal.setName("icalendar.ics");
                attachmentCal.setMimeType("text/calendar");
                message.addAttachment(attachmentCal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!atts.isEmpty()) {
                for (org.exoplatform.calendar.service.Attachment att : atts) {
                    Attachment attachment = new Attachment();
                    attachment.setInputStream(att.getInputStream());
                    attachment.setMimeType(att.getMimeType());
                    message.addAttachment(attachment);
                }
            }
            org.exoplatform.services.mail.MailService mService = (org.exoplatform.services.mail.MailService)this.getApplicationComponent(MailServiceImpl.class);
            mService.sendMessage(message);
            ContactService contactService = (ContactService)PortalContainer.getComponent(ContactService.class);
            contactService.saveAddress(CalendarUtils.getCurrentUser(), sbAddress.toString());
        }
    }

    public String cleanValue(String values) throws Exception {
        String[] tmpArr = values.split(",");
        List<String> list = Arrays.asList(tmpArr);
        HashSet<String> set = new HashSet<String>(list);
        String[] result = new String[set.size()];
        set.toArray(result);
        String data2 = "";
        for (String s : result) {
            data2 = data2 + "," + s;
        }
        data2 = data2.substring(1);
        return data2;
    }

    public org.exoplatform.calendar.service.Attachment getAttachment(String attId) {
        UIEventDetailTab uiDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        for (org.exoplatform.calendar.service.Attachment att : uiDetailTab.getAttachments()) {
            if (!att.getId().equals(attId)) continue;
            return att;
        }
        return null;
    }

    public List<ParticipantStatus> getParticipantStatusList() {
        return this.participantStatusList_;
    }

    public void SaveAndNoAsk(Event<UIEventForm> event, boolean isSend) throws Exception {
        Account acc;
        Date to;
        String description;
        UIEventForm uiForm = (UIEventForm)event.getSource();
        UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
        UICalendarPortlet calendarPortlet = (UICalendarPortlet)uiForm.getAncestorOfType(UICalendarPortlet.class);
        UIPopupAction uiPopupAction = (UIPopupAction)uiForm.getAncestorOfType(UIPopupAction.class);
        UICalendarViewContainer uiViewContainer = (UICalendarViewContainer)calendarPortlet.findFirstComponentOfType(UICalendarViewContainer.class);
        CalendarSetting calSetting = calendarPortlet.getCalendarSetting();
        CalendarService calService = CalendarUtils.getCalendarService();
        String summary = uiForm.getEventSumary().trim();
        summary = CalendarUtils.enCodeTitle((String)summary);
        String location = uiForm.getEventPlace();
        if (!CalendarUtils.isEmpty((String)location)) {
            location = location.replaceAll(CalendarUtils.GREATER_THAN, "").replaceAll(CalendarUtils.SMALLER_THAN, "");
        }
        if (!CalendarUtils.isEmpty((String)(description = uiForm.getEventDescription()))) {
            description = description.replaceAll(CalendarUtils.GREATER_THAN, "").replaceAll(CalendarUtils.SMALLER_THAN, "");
        }
        if (!uiForm.isEventDetailValid(calSetting)) {
            uiApp.addMessage(new ApplicationMessage(uiForm.errorMsg_, null));
            uiForm.setSelectedTab(TAB_EVENTDETAIL);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        if (!uiForm.isReminderValid()) {
            uiApp.addMessage(new ApplicationMessage(uiForm.errorMsg_, (Object[])new String[]{uiForm.errorValues}));
            uiForm.setSelectedTab(TAB_EVENTREMINDER);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        if (!uiForm.isParticipantValid()) {
            uiApp.addMessage(new ApplicationMessage(uiForm.errorMsg_, (Object[])new String[]{uiForm.errorValues}));
            uiForm.setSelectedTab(TAB_EVENTSHARE);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        String username = CalendarUtils.getCurrentUser();
        String calendarId = uiForm.getCalendarId();
        Date from = uiForm.getEventFromDate(calSetting.getDateFormat(), calSetting.getTimeFormat());
        if (from.after(to = uiForm.getEventToDate(calSetting.getDateFormat(), calSetting.getTimeFormat()))) {
            uiApp.addMessage(new ApplicationMessage(uiForm.getId() + ".msg.event-date-time-logic", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        if (from.equals(to)) {
            to = CalendarUtils.getEndDay((Date)from).getTime();
        }
        if (uiForm.getEventAllDate()) {
            java.util.Calendar tempCal = CalendarUtils.getInstanceOfCurrentCalendar();
            tempCal.setTime(to);
            tempCal.add(14, -1);
            to = tempCal.getTime();
        }
        Calendar currentCalendar = null;
        if (uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) {
            currentCalendar = calService.getUserCalendar(username, calendarId);
        } else if (uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) {
            GroupCalendarData gCalendarData = calService.getSharedCalendars(username, true);
            if (gCalendarData != null && gCalendarData.getCalendarById(calendarId) != null) {
                currentCalendar = gCalendarData.getCalendarById(calendarId);
            }
        } else if (uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) {
            currentCalendar = calService.getGroupCalendar(calendarId);
        }
        if (currentCalendar == null) {
            uiPopupAction.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
            uiApp.addMessage(new ApplicationMessage("UICalendars.msg.have-no-calendar", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        boolean canEdit = false;
        if (uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) {
            canEdit = CalendarUtils.canEdit(null, (String[])Utils.getEditPerUsers((Calendar)currentCalendar), (String)username);
        } else if (uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) {
            canEdit = CalendarUtils.canEdit((OrganizationService)CalendarUtils.getOrganizationService(), (String[])currentCalendar.getEditPermission(), (String)username);
        }
        if (!canEdit && !uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) {
            uiPopupAction.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
            uiApp.addMessage(new ApplicationMessage("UICalendars.msg.have-no-permission-to-edit", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        CalendarEvent calendarEvent = null;
        CalendarEvent oldCalendarEvent = null;
        String[] pars = uiForm.getParticipantValues().split(CalendarUtils.BREAK_LINE);
        String eventId = null;
        if (uiForm.isAddNew_) {
            calendarEvent = new CalendarEvent();
        } else {
            calendarEvent = uiForm.calendarEvent_;
            oldCalendarEvent = new CalendarEvent();
            oldCalendarEvent.setSummary(calendarEvent.getSummary());
            oldCalendarEvent.setDescription(calendarEvent.getDescription());
            oldCalendarEvent.setLocation(calendarEvent.getLocation());
            oldCalendarEvent.setFromDateTime(calendarEvent.getFromDateTime());
            oldCalendarEvent.setToDateTime(calendarEvent.getToDateTime());
        }
        calendarEvent.setFromDateTime(from);
        calendarEvent.setToDateTime(to);
        calendarEvent.setSendOption(uiForm.getSendOption());
        calendarEvent.setMessage(uiForm.getMessage());
        String[] parStatus = uiForm.getParticipantStatusValues().split(CalendarUtils.BREAK_LINE);
        calendarEvent.setParticipantStatus(parStatus);
        calendarEvent.setParticipant(pars);
        if (CalendarUtils.isEmpty((String)uiForm.getInvitationEmail())) {
            calendarEvent.setInvitation(null);
        } else if (CalendarUtils.isValidEmailAddresses((String)uiForm.getInvitationEmail())) {
            String addressList = uiForm.getInvitationEmail().replaceAll(CalendarUtils.SEMICOLON, CalendarUtils.COMMA);
            LinkedHashMap<String, String> emails = new LinkedHashMap<String, String>();
            for (String email : addressList.split(CalendarUtils.COMMA)) {
                String address = email.trim();
                if (emails.containsKey(address)) continue;
                emails.put(address, address);
            }
            if (!emails.isEmpty()) {
                calendarEvent.setInvitation(emails.keySet().toArray(new String[emails.size()]));
            }
        } else {
            uiApp.addMessage(new ApplicationMessage("UIEventForm.msg.event-email-invalid", (Object[])new String[]{CalendarUtils.invalidEmailAddresses((String)uiForm.getInvitationEmail())}));
            uiForm.setSelectedTab(TAB_EVENTSHARE);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        calendarEvent.setCalendarId(uiForm.getCalendarId());
        calendarEvent.setEventType(CalendarEvent.TYPE_EVENT);
        calendarEvent.setSummary(summary);
        calendarEvent.setDescription(description);
        calendarEvent.setCalType(uiForm.calType_);
        calendarEvent.setCalendarId(calendarId);
        calendarEvent.setEventCategoryId(uiForm.getEventCategory());
        UIFormSelectBox selectBox = ((UIFormInputWithActions)uiForm.getChildById(TAB_EVENTDETAIL)).getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
        for (SelectItemOption o : selectBox.getOptions()) {
            if (!((String)o.getValue()).equals(selectBox.getValue())) continue;
            calendarEvent.setEventCategoryName(o.getLabel());
            break;
        }
        calendarEvent.setLocation(location);
        calendarEvent.setRepeatType(uiForm.getEventRepeat());
        calendarEvent.setPriority(uiForm.getEventPriority());
        calendarEvent.setPrivate(ITEM_PRIVATE.equals(uiForm.getShareType()));
        calendarEvent.setEventState(uiForm.getEventState());
        calendarEvent.setAttachment(uiForm.getAttachments(calendarEvent.getId(), uiForm.isAddNew_));
        calendarEvent.setReminders(uiForm.getEventReminders(from, calendarEvent.getReminders()));
        eventId = calendarEvent.getId();
        CalendarView calendarView = (CalendarView)uiViewContainer.getRenderedChild();
        try {
            block75: {
                UIListContainer uiListContainer;
                block73: {
                    block76: {
                        block74: {
                            if (!uiForm.isAddNew_) break block73;
                            if (!uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) break block74;
                            calService.saveUserEvent(username, calendarId, calendarEvent, uiForm.isAddNew_);
                            break block75;
                        }
                        if (!uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) break block76;
                        calService.saveEventToSharedCalendar(username, calendarId, calendarEvent, uiForm.isAddNew_);
                        break block75;
                    }
                    if (!uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) break block75;
                    calService.savePublicEvent(calendarId, calendarEvent, uiForm.isAddNew_);
                    break block75;
                }
                String fromCal = uiForm.oldCalendarId_.split(CalendarUtils.COLON)[1].trim();
                String toCal = uiForm.newCalendarId_.split(CalendarUtils.COLON)[1].trim();
                String fromType = uiForm.oldCalendarId_.split(CalendarUtils.COLON)[0].trim();
                String toType = uiForm.newCalendarId_.split(CalendarUtils.COLON)[0].trim();
                ArrayList<CalendarEvent> listEvent = new ArrayList<CalendarEvent>();
                listEvent.add(calendarEvent);
                calService.moveEvent(fromCal, toCal, fromType, toType, listEvent, username);
                if (calendarView instanceof UIListContainer && (uiListContainer = (UIListContainer)calendarView).isDisplaySearchResult() && calendarEvent.getAttachment() != null) {
                    UIPreview uiPreview = (UIPreview)uiListContainer.getChild(UIPreview.class);
                    EventQuery eventQuery = new EventQuery();
                    eventQuery.setCalendarId(new String[]{calendarEvent.getCalendarId()});
                    eventQuery.setEventType(calendarEvent.getEventType());
                    eventQuery.setCategoryId(new String[]{calendarEvent.getEventCategoryId()});
                    UIListView listView = (UIListView)uiListContainer.getChild(UIListView.class);
                    List list = calService.getEvents(username, eventQuery, listView.getPublicCalendars());
                    for (CalendarEvent ev : list) {
                        if (!ev.getId().equals(calendarEvent.getId())) continue;
                        if (!listView.getDataMap().containsKey(ev.getId())) break;
                        listView.getDataMap().put(ev.getId(), ev);
                        if (!uiPreview.getEvent().getId().equals(ev.getId())) break;
                        uiPreview.setEvent(ev);
                        break;
                    }
                }
            }
            if (calendarView instanceof UIListContainer) {
                UIListContainer uiListContainer = (UIListContainer)calendarView;
                if (!uiListContainer.isDisplaySearchResult()) {
                    uiViewContainer.refresh();
                }
            } else {
                uiViewContainer.refresh();
            }
            calendarView.setLastUpdatedEventId(eventId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
            UIMiniCalendar uiMiniCalendar = (UIMiniCalendar)calendarPortlet.findFirstComponentOfType(UIMiniCalendar.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMiniCalendar);
            uiPopupAction.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        }
        catch (Exception e) {
            uiApp.addMessage(new ApplicationMessage("UIEventForm.msg.add-event-error", null));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            e.printStackTrace();
        }
        if (calendarEvent != null && uiForm.isSendMail()) {
            acc = CalendarUtils.getMailService().getDefaultAccount(username);
            try {
                uiForm.sendMail(CalendarUtils.getMailService(), CalendarUtils.getOrganizationService(), calSetting, acc, username, uiForm.getParticipantValues(), calendarEvent);
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIEventForm.msg.error-send-email", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                e.printStackTrace();
            }
        } else if (calendarEvent != null && isSend) {
            String[] entry;
            acc = CalendarUtils.getMailService().getDefaultAccount(username);
            if (oldCalendarEvent != null) {
                if (oldCalendarEvent.getSummary() != null && !oldCalendarEvent.getSummary().equalsIgnoreCase(calendarEvent.getSummary()) || calendarEvent.getSummary() != null && !calendarEvent.getSummary().equalsIgnoreCase(oldCalendarEvent.getSummary())) {
                    uiForm.isChangedSignificantly = true;
                }
                if (oldCalendarEvent.getDescription() != null && !oldCalendarEvent.getDescription().equalsIgnoreCase(calendarEvent.getDescription()) || calendarEvent.getDescription() != null && !calendarEvent.getDescription().equalsIgnoreCase(oldCalendarEvent.getDescription())) {
                    uiForm.isChangedSignificantly = true;
                }
                if (oldCalendarEvent.getLocation() != null && !oldCalendarEvent.getLocation().equalsIgnoreCase(calendarEvent.getLocation()) || calendarEvent.getLocation() != null && !calendarEvent.getLocation().equalsIgnoreCase(oldCalendarEvent.getLocation())) {
                    uiForm.isChangedSignificantly = true;
                }
                if (!oldCalendarEvent.getFromDateTime().equals(calendarEvent.getFromDateTime())) {
                    uiForm.isChangedSignificantly = true;
                }
                if (!oldCalendarEvent.getToDateTime().equals(calendarEvent.getToDateTime())) {
                    uiForm.isChangedSignificantly = true;
                }
            }
            if (uiForm.isAddNew_ || uiForm.isChangedSignificantly) {
                try {
                    uiForm.sendMail(CalendarUtils.getMailService(), CalendarUtils.getOrganizationService(), calSetting, acc, username, uiForm.getParticipantValues(), calendarEvent);
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIEventForm.msg.error-send-email", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    e.printStackTrace();
                }
                HashMap<String, String> parsUpdated = new HashMap<String, String>();
                for (String parSt : calendarEvent.getParticipantStatus()) {
                    entry = parSt.split(":");
                    parsUpdated.put(entry[0], STATUS_PENDING);
                }
                HashMap<String, String> participant = new HashMap<String, String>();
                for (Map.Entry par : parsUpdated.entrySet()) {
                    participant.put((String)par.getKey() + ":" + (String)par.getValue(), "");
                }
                calendarEvent.setParticipantStatus(participant.keySet().toArray(new String[participant.keySet().size()]));
                if (uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) {
                    calService.saveUserEvent(username, calendarId, calendarEvent, false);
                } else if (uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) {
                    calService.saveEventToSharedCalendar(username, calendarId, calendarEvent, false);
                } else if (uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) {
                    calService.savePublicEvent(calendarId, calendarEvent, false);
                }
            } else {
                LinkedHashMap<String, String> invitations = new LinkedHashMap<String, String>();
                for (String s : calendarEvent.getInvitation()) {
                    invitations.put(s, s);
                }
                for (String parSt : calendarEvent.getParticipantStatus()) {
                    entry = parSt.split(":");
                    if (entry.length <= 1 || !entry[0].contains("@")) continue;
                    invitations.remove(entry[0]);
                }
                calendarEvent.setInvitation(invitations.keySet().toArray(new String[invitations.size()]));
                StringBuilder buider = new StringBuilder("");
                for (String parSt : calendarEvent.getParticipantStatus()) {
                    String[] entry2 = parSt.split(":");
                    if (entry2.length != 1 || entry2[0].contains("@")) continue;
                    if (buider.length() > 0) {
                        buider.append(CalendarUtils.BREAK_LINE);
                    }
                    buider.append(entry2[0]);
                }
                if (buider.toString().trim().length() > 0 || invitations.size() > 0) {
                    try {
                        uiForm.sendMail(CalendarUtils.getMailService(), CalendarUtils.getOrganizationService(), calSetting, acc, username, buider.toString(), calendarEvent);
                    }
                    catch (Exception e) {
                        uiApp.addMessage(new ApplicationMessage("UIEventForm.msg.error-send-email", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        e.printStackTrace();
                    }
                    HashMap<String, String> parsUpdated = new HashMap<String, String>();
                    for (String parSt : calendarEvent.getParticipantStatus()) {
                        String[] entry3 = parSt.split(":");
                        if (entry3.length > 1) {
                            parsUpdated.put(entry3[0], entry3[1]);
                            continue;
                        }
                        parsUpdated.put(entry3[0], STATUS_PENDING);
                    }
                    HashMap<String, String> participant = new HashMap<String, String>();
                    for (Map.Entry par : parsUpdated.entrySet()) {
                        participant.put((String)par.getKey() + ":" + (String)par.getValue(), "");
                    }
                    calendarEvent.setParticipantStatus(participant.keySet().toArray(new String[participant.keySet().size()]));
                    if (uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) {
                        calService.saveUserEvent(username, calendarId, calendarEvent, false);
                    } else if (uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) {
                        calService.saveEventToSharedCalendar(username, calendarId, calendarEvent, false);
                    } else if (uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) {
                        calService.savePublicEvent(calendarId, calendarEvent, false);
                    }
                }
            }
        }
        UIEventDetailTab uiDetailTab = (UIEventDetailTab)uiForm.getChildById(TAB_EVENTDETAIL);
        for (org.exoplatform.calendar.service.Attachment att : uiDetailTab.getAttachments()) {
            UIAttachFileForm.removeUploadTemp((UploadService)((UploadService)uiForm.getApplicationComponent(UploadService.class)), (String)att.getResourceId());
        }
    }

    static /* synthetic */ boolean access$000(UIEventForm x0) throws Exception {
        return x0.isReminderValid();
    }

    static /* synthetic */ String access$100(UIEventForm x0) {
        return x0.errorMsg_;
    }

    static /* synthetic */ String access$200(UIEventForm x0) {
        return x0.errorValues;
    }

    static /* synthetic */ String access$300(UIEventForm x0) {
        return x0.confirm_msg;
    }
}

