/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.RepositoryService;

public class ICalServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block12: {
            response.setHeader("Cache-Control", "private max-age=600, s-maxage=120");
            String pathInfo = request.getPathInfo();
            String[] arrayInfo = pathInfo.toString().split("/");
            Session session = null;
            try {
                if (arrayInfo.length < 5) {
                    throw new Exception("Invalid URL");
                }
                String portalName = arrayInfo[1];
                String wsName = arrayInfo[2];
                String userName = arrayInfo[3];
                StringBuffer fileName = new StringBuffer();
                for (int i = 4; i < arrayInfo.length; ++i) {
                    if (fileName.length() > 0) {
                        fileName.append("/");
                    }
                    fileName.append(arrayInfo[i]);
                }
                PortalContainer pcontainer = this.getPortalContainer(portalName);
                PortalContainer.setInstance((PortalContainer)pcontainer);
                RepositoryService repositoryService = (RepositoryService)pcontainer.getComponentInstanceOfType(RepositoryService.class);
                session = repositoryService.getCurrentRepository().getSystemSession(wsName);
                CalendarService calService = (CalendarService)pcontainer.getComponentInstanceOfType(CalendarService.class);
                Node node = calService.getRssHome(userName).getNode(fileName.toString());
                if (node == null) {
                    throw new Exception("Node " + fileName + " not found. ");
                }
                if (node.isNodeType("exo:rssData")) {
                    response.setContentType("text/xml");
                    InputStream is = node.getProperty("exo:content").getStream();
                    byte[] buf = new byte[is.available()];
                    is.read(buf);
                    ServletOutputStream os = response.getOutputStream();
                    os.write(buf);
                    break block12;
                }
                if (node.isNodeType("exo:iCalData")) {
                    response.setContentType("text/calendar");
                    InputStream is = node.getProperty("exo:data").getStream();
                    byte[] buf = new byte[is.available()];
                    is.read(buf);
                    ServletOutputStream os = response.getOutputStream();
                    os.write(buf);
                    break block12;
                }
                throw new Exception("Invalid node type, expected exo:rssData or exo:iCalData type");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServletException((Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                    PortalContainer.setInstance(null);
                }
            }
        }
    }

    private PortalContainer getPortalContainer(String portalName) {
        PortalContainer pcontainer = RootContainer.getInstance().getPortalContainer(portalName);
        return pcontainer;
    }
}

