/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UIRemoteCalendar;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormColorPicker;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIRemoteCalendar.gtmpl", events={@EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIRemoteCalendar
extends UIForm
implements UIPopupComponent {
    private static final String URL = "url".intern();
    private static final String NAME = "name".intern();
    private static final String DESCRIPTION = "description".intern();
    private static final String USE_AUTHENTICATION = "useAuthentication";
    private static final String USERNAME = "username".intern();
    private static final String PASSWORD = "password".intern();
    private static final String COLOR = "color".intern();
    private static final String AUTO_REFRESH = "autoRefresh".intern();
    private static final String LAST_UPDATED = "lastUpdated".intern();
    private String remoteType;
    private boolean isAddNew_ = true;
    private String calendarId_ = null;
    private String lastUpdated_ = null;

    public UIRemoteCalendar() throws Exception {
        UIFormStringInput remoteUrl = new UIFormStringInput(URL, URL, null);
        remoteUrl.addValidator(MandatoryValidator.class, new Object[0]);
        this.addUIFormInput((UIFormInput)remoteUrl);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME, NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(USE_AUTHENTICATION, USE_AUTHENTICATION, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USERNAME, USERNAME, null));
        UIFormStringInput password = new UIFormStringInput(PASSWORD, PASSWORD, null);
        password.setType((short)1);
        this.addUIFormInput((UIFormInput)password);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (String s : Utils.SYNC_PERIOD) {
            options.add(new SelectItemOption(s, (Object)s));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(AUTO_REFRESH, AUTO_REFRESH, options));
        this.addUIFormInput((UIFormInput)new UIFormColorPicker(COLOR, COLOR));
    }

    public void init(String url, String remoteType) {
        this.isAddNew_ = true;
        this.remoteType = remoteType;
        this.setUrl(url);
        this.getUIStringInput(URL).setEditable(false);
        this.setSyncPeriod("auto");
        this.setSelectColor(Calendar.COLORS[new Random().nextInt(Calendar.COLORS.length)]);
        this.setUseAuthentication(Boolean.valueOf(true));
    }

    public void init(Calendar calendar) throws Exception {
        if (calendar == null) {
            return;
        }
        this.isAddNew_ = false;
        this.calendarId_ = calendar.getId();
        String username = CalendarUtils.getCurrentUser();
        CalendarService calService = CalendarUtils.getCalendarService();
        CalendarSetting calSettings = calService.getCalendarSetting(username);
        if (!calService.isRemoteCalendar(username, this.calendarId_)) {
            return;
        }
        this.remoteType = calService.getRemoteCalendarType(username, this.calendarId_);
        this.setUrl(calService.getRemoteCalendarUrl(username, this.calendarId_));
        this.getUIStringInput(URL).setEditable(true);
        this.setCalendarName(calService.getUserCalendar(username, this.calendarId_).getName());
        this.setDescription(calendar.getDescription());
        this.setSelectColor(calendar.getCalendarColor());
        this.setUseAuthentication(Boolean.valueOf(calService.getRemoteCalendarUsername(username, this.calendarId_) != null));
        this.setRemoteUser(calService.getRemoteCalendarUsername(username, this.calendarId_));
        this.setRemotePassword(calService.getRemoteCalendarPassword(username, this.calendarId_));
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(calSettings.getDateFormat() + " " + calSettings.getTimeFormat(), locale);
        df.setTimeZone(TimeZone.getTimeZone(calSettings.getTimeZone()));
        java.util.Calendar lastUpdated = calService.getRemoteCalendarLastUpdated(username, this.calendarId_);
        this.setLastUpdated(df.format(lastUpdated.getTime()));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    protected String getUrl() {
        return (String)this.getUIStringInput(URL).getValue();
    }

    protected void setUrl(String url) {
        this.getUIStringInput(URL).setValue((Object)url);
    }

    protected void setCalendarName(String name) {
        this.getUIStringInput(NAME).setValue((Object)name);
    }

    protected String getCalendarName() {
        return (String)this.getUIStringInput(NAME).getValue();
    }

    protected void setDescription(String description) {
        this.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)description);
    }

    protected String getDescription() {
        return (String)this.getUIFormTextAreaInput(DESCRIPTION).getValue();
    }

    protected String getSyncPeriod() {
        return (String)this.getUIFormSelectBox(AUTO_REFRESH).getValue();
    }

    protected void setSyncPeriod(String value) {
        this.getUIFormSelectBox(AUTO_REFRESH).setValue(value);
    }

    protected String getSelectColor() {
        return (String)((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).getValue();
    }

    protected void setSelectColor(String value) {
        ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setValue(value);
    }

    protected void setRemoteUser(String remoteUser) {
        this.getUIStringInput(USERNAME).setValue((Object)remoteUser);
    }

    protected String getRemoteUser() {
        return (String)this.getUIStringInput(USERNAME).getValue();
    }

    protected void setRemotePassword(String password) {
        this.getUIStringInput(PASSWORD).setValue((Object)password);
    }

    protected String getRemotePassword() {
        return (String)this.getUIStringInput(PASSWORD).getValue();
    }

    protected void setUseAuthentication(Boolean checked) {
        this.getUIFormCheckBoxInput(USE_AUTHENTICATION).setChecked(checked.booleanValue());
    }

    protected Boolean getUseAuthentication() {
        return this.getUIFormCheckBoxInput(USE_AUTHENTICATION).isChecked();
    }

    protected void setLastUpdated(String lastUpdated) {
        this.lastUpdated_ = lastUpdated;
    }

    protected String getLastUpdated() {
        return this.lastUpdated_;
    }

    static /* synthetic */ String access$000(UIRemoteCalendar x0) {
        return x0.remoteType;
    }

    static /* synthetic */ boolean access$100(UIRemoteCalendar x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ String access$200(UIRemoteCalendar x0) {
        return x0.calendarId_;
    }
}

