/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.webui.CalendarView;
import org.exoplatform.calendar.webui.UICalendarContainer;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.UIDayView;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIMonthView;
import org.exoplatform.calendar.webui.UIScheduleView;
import org.exoplatform.calendar.webui.UIWeekView;
import org.exoplatform.calendar.webui.UIYearView;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;

@ComponentConfig(template="app:/templates/calendar/webui/UICalendarViewContainer.gtmpl")
public class UICalendarViewContainer
extends UIContainer {
    public static final String DAY_VIEW = "UIDayView".intern();
    public static final String WEEK_VIEW = "UIWeekView".intern();
    public static final String MONTH_VIEW = "UIMonthView".intern();
    public static final String YEAR_VIEW = "UIYearView".intern();
    public static final String LIST_VIEW = "UIListContainer".intern();
    public static final String SCHEDULE_VIEW = "UIScheduleView".intern();
    public static final String WORKING_VIEW = "UIWorkingView".intern();
    public static final String[] TYPES = new String[]{DAY_VIEW, WEEK_VIEW, MONTH_VIEW, YEAR_VIEW, LIST_VIEW, SCHEDULE_VIEW, WORKING_VIEW};
    private String currentViewType_;

    public UICalendarViewContainer() throws Exception {
        this.initView(null);
    }

    public void initView(String viewType) throws Exception {
        CalendarSetting calendarSetting = new CalendarSetting();
        try {
            calendarSetting = ((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getCalendarSetting();
        }
        catch (Exception e) {
            CalendarService cservice = CalendarUtils.getCalendarService();
            String username = CalendarUtils.getCurrentUser();
            calendarSetting = cservice.getCalendarSetting(username);
        }
        if (viewType == null) {
            viewType = TYPES[Integer.parseInt(calendarSetting.getViewType())];
        }
        this.currentViewType_ = viewType;
        if (DAY_VIEW.equals(viewType)) {
            UIDayView uiView = (UIDayView)this.getChild(UIDayView.class);
            if (uiView == null) {
                uiView = (UIDayView)this.addChild(UIDayView.class, null, null);
            }
            if (this.getRenderedChild() != null) {
                uiView.setCurrentCalendar(((CalendarView)this.getRenderedChild()).getCurrentCalendar());
            }
            this.setRenderedChild(viewType);
        } else if (WEEK_VIEW.equals(viewType)) {
            UIWeekView uiView = (UIWeekView)this.getChild(UIWeekView.class);
            if (uiView == null) {
                uiView = (UIWeekView)this.addChild(UIWeekView.class, null, null);
            }
            uiView.isShowCustomView_ = false;
            if (this.getRenderedChild() != null) {
                uiView.setCurrentCalendar(((CalendarView)this.getRenderedChild()).getCurrentCalendar());
            }
            this.setRenderedChild(viewType);
        } else if (MONTH_VIEW.equals(viewType)) {
            UIMonthView uiView = (UIMonthView)this.getChild(UIMonthView.class);
            if (uiView == null) {
                uiView = (UIMonthView)this.addChild(UIMonthView.class, null, null);
            }
            if (this.getRenderedChild() != null) {
                uiView.setCurrentCalendar(((CalendarView)this.getRenderedChild()).getCurrentCalendar());
            }
            this.setRenderedChild(viewType);
        } else if (YEAR_VIEW.equals(viewType)) {
            UIYearView uiView = (UIYearView)this.getChild(UIYearView.class);
            if (uiView == null) {
                uiView = (UIYearView)this.addChild(UIYearView.class, null, null);
            }
            if (this.getRenderedChild() != null) {
                uiView.setCurrentCalendar(((CalendarView)this.getRenderedChild()).getCurrentCalendar());
            }
            this.setRenderedChild(viewType);
        } else if (LIST_VIEW.equals(viewType)) {
            UIListContainer uiView = (UIListContainer)this.getChild(UIListContainer.class);
            if (uiView == null) {
                uiView = (UIListContainer)this.addChild(UIListContainer.class, null, null);
            }
            UIListView uiListView = (UIListView)uiView.getChild(UIListView.class);
            uiListView.setShowEventAndTask(false);
            uiListView.setCategoryId(null);
            uiListView.refresh();
            uiListView.isShowEvent_ = true;
            if (this.getRenderedChild() != null) {
                uiView.setCurrentCalendar(((CalendarView)this.getRenderedChild()).getCurrentCalendar());
            }
            this.setRenderedChild(viewType);
        } else if (SCHEDULE_VIEW.equals(viewType)) {
            UIScheduleView uiView = (UIScheduleView)this.getChild(UIScheduleView.class);
            if (uiView == null) {
                uiView = (UIScheduleView)this.addChild(UIScheduleView.class, null, null);
            }
            if (this.getRenderedChild() != null) {
                uiView.setCurrentCalendar(((CalendarView)this.getRenderedChild()).getCurrentCalendar());
            }
            this.setRenderedChild(viewType);
        } else if (WORKING_VIEW.equals(viewType)) {
            UIWeekView uiView = (UIWeekView)this.getChild(UIWeekView.class);
            if (uiView == null) {
                uiView = (UIWeekView)this.addChild(UIWeekView.class, null, null);
            }
            uiView.isShowCustomView_ = true;
            if (this.getRenderedChild() != null) {
                uiView.setCurrentCalendar(((CalendarView)this.getRenderedChild()).getCurrentCalendar());
            }
            this.setRenderedChild(WEEK_VIEW);
        }
        this.refresh();
    }

    public String getCurrentViewType() {
        return this.currentViewType_;
    }

    public void setCurrentViewType_(String currentViewType) {
        this.currentViewType_ = currentViewType;
    }

    public void refresh() throws Exception {
        for (UIComponent comp : this.getChildren()) {
            if (!comp.isRendered() || !(comp instanceof CalendarView)) continue;
            ((CalendarView)comp).refresh();
        }
    }

    protected boolean isShowPane() {
        return ((UICalendarContainer)((UICalendarWorkingContainer)this.getAncestorOfType(UICalendarWorkingContainer.class)).getChild(UICalendarContainer.class)).isRendered();
    }

    public UIComponent getRenderedChild() {
        for (UIComponent comp : this.getChildren()) {
            if (!comp.isRendered()) continue;
            return comp;
        }
        return null;
    }

    public void updateCategory() throws Exception {
        for (UIComponent comp : this.getChildren()) {
            if (!(comp instanceof CalendarView)) continue;
            ((CalendarView)comp).update();
        }
    }

    public void applySeting() throws Exception {
        for (UIComponent comp : this.getChildren()) {
            if (!(comp instanceof CalendarView)) continue;
            ((CalendarView)comp).applySeting();
        }
    }
}

