/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.history.impl.jcr;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoricalMessageImpl;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.annotations.JcrName;
import org.jcrom.annotations.JcrNode;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JcrNode(nodeType="lr:conversation")
public class Conversation {
    @JcrName
    private String conversationId;
    @JcrPath
    private String path;
    @JcrProperty(name="lr:conversationlastActiveDate")
    private Date lastActiveDate;
    @JcrProperty(name="lr:conversationstartDate")
    private Date startDate;
    @JcrChildNode
    private List<HistoricalMessageImpl> messageList;

    public Conversation() {
    }

    public Conversation(String conversationId, Date lastActiveDate, Date startDate) {
        this.conversationId = conversationId;
        this.lastActiveDate = lastActiveDate;
        this.startDate = startDate;
        this.messageList = new ArrayList<HistoricalMessageImpl>();
    }

    public void addMessage(HistoricalMessageImpl message) {
        this.messageList.add(message);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public HistoricalMessageImpl getHistoricalMessage(String id) {
        for (HistoricalMessageImpl message : this.messageList) {
            if (!message.getId().equals(id)) continue;
            return message;
        }
        return null;
    }

    public Date getLastActiveDate() {
        return this.lastActiveDate;
    }

    public List<HistoricalMessageImpl> getMessageList() {
        return this.messageList;
    }

    public String getPath() {
        return this.path;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setLastActiveDate(Date lastActiveDate) {
        this.lastActiveDate = lastActiveDate;
    }

    public void setMessageList(List<HistoricalMessageImpl> messageList) {
        this.messageList = messageList;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
}

