/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.ConversationRegistry;

public class LogoutFilter
implements Filter {
    private final Log log = ExoLogger.getLogger((String)"liveroom.chat.LogoutFilter");
    private static final String JBOSS = "jboss";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        HttpSession session;
        J2EEServerInfo info = new J2EEServerInfo();
        String serverName = info.getServerName();
        if (!JBOSS.equalsIgnoreCase(serverName) && (session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
            ConversationRegistry conversationRegistry;
            String sessionId = session.getId();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            if (container instanceof RootContainer) {
                container = RootContainer.getInstance().getPortalContainer("portal");
            }
            if ((conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class)) != null && conversationRegistry.getState((Object)sessionId) != null) {
                this.log.info((Object)("Remove session : " + sessionId));
                session.invalidate();
                this.log.info((Object)("Remove conversation state : " + sessionId));
                conversationRegistry.unregister((Object)sessionId);
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

