/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.uistate.rest;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.uistate.UIStateSession;
import org.exoplatform.services.uistate.bean.UIStateDataBean;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;

public class UIStateService
implements ResourceContainer {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final CacheControl cc = new CacheControl();
    private static String unreadMessageCount;

    @HTTPMethod(value="POST")
    @URITemplate(value="/uistateservice/save/{username}/{unreadMessageCnt}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response saveState(@URIParam(value="username") String userName, @URIParam(value="unreadMessageCnt") String unreadMessageCnt, UIStateDataBean stateData) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            XMPPMessenger messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
            if (messenger != null) {
                UIStateSession uiSession = messenger.getUISateSession(userName);
                stateData = stateData != null ? stateData : new UIStateDataBean();
                uiSession.setUIStateData(stateData);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        unreadMessageCount = unreadMessageCnt;
        UIStateDataBean stateDataBean = new UIStateDataBean("null");
        stateDataBean.setUnreadMessageCnt(unreadMessageCount);
        return Response.Builder.ok((Object)stateDataBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/uistateservice/get/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getState(@URIParam(value="username") String userName) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            XMPPMessenger messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
            if (messenger != null) {
                UIStateSession uiSession = messenger.getUISateSession(userName);
                UIStateDataBean uiStateData = uiSession.getUIStateData();
                uiStateData = uiStateData != null ? uiStateData : new UIStateDataBean();
                return Response.Builder.ok((Object)uiStateData, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UIStateDataBean stateDataBean = new UIStateDataBean();
        return Response.Builder.ok((Object)stateDataBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
    }

    static {
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

