/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.xmpp.bean.ConfigRoomBean;
import org.exoplatform.services.xmpp.bean.ContactBean;
import org.exoplatform.services.xmpp.bean.FormBean;
import org.exoplatform.services.xmpp.bean.FullRoomInfoBean;
import org.exoplatform.services.xmpp.bean.HostedRoomBean;
import org.exoplatform.services.xmpp.bean.InitInfoBean;
import org.exoplatform.services.xmpp.bean.InterlocutorListBean;
import org.exoplatform.services.xmpp.bean.JsResourceBundleBean;
import org.exoplatform.services.xmpp.bean.MessageBean;
import org.exoplatform.services.xmpp.bean.MessageListBean;
import org.exoplatform.services.xmpp.connection.XMPPSession;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.connection.impl.XMPPSessionImpl;
import org.exoplatform.services.xmpp.ext.transport.AIMTransport;
import org.exoplatform.services.xmpp.ext.transport.GtalkTransport;
import org.exoplatform.services.xmpp.ext.transport.ICQTransport;
import org.exoplatform.services.xmpp.ext.transport.MSNTransport;
import org.exoplatform.services.xmpp.ext.transport.YahooTransport;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.exoplatform.services.xmpp.userinfo.UserInfo;
import org.exoplatform.services.xmpp.userinfo.UserInfoService;
import org.exoplatform.services.xmpp.util.PresenceUtil;
import org.exoplatform.services.xmpp.util.TransformUtils;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTXMPPService
implements ResourceContainer,
Startable {
    private static final Map<String, String> jsResourceBundle = new HashMap<String, String>(){
        {
            this.put("chat.message.xmpp.session.is.null", "chat_message_xmpp_session_is_null");
            this.put("chat.message.room.show.config", "chat_message_room_show_config");
            this.put("chat.message.room.default.config.commit", "chat_message_room_default_config_commit");
            this.put("chat.message.room.configuration.error", "chat_message_room_configuration_error");
            this.put("chat.message.room.password.error", "chat_message_room_password_error");
            this.put("chat.message.room.not.unlocked.error", "chat_message_room_not_unlocked_error");
            this.put("chat.message.room.user.not.member", "chat_message_room_user_not_member");
            this.put("chat.message.room.name.is.invalid", "chat_message_room_name_is_invalid");
            this.put("chat.message.room.secret.key.to.access", "chat_message_room_secret_key_to_access");
            this.put("chat.message.room.invite.to.join", "chat_message_room_invite_to_join");
            this.put("chat.message.room.user.left", "chat_message_room_user_left");
            this.put("chat.message.room.user.join", "chat_message_room_user_join");
            this.put("chat.message.confirm.allow.to.see.status", "chat_message_confirm_allow_to_see_status");
            this.put("chat.message.confirm.remove.buddy", "chat_message_confirm_remove_buddy");
            this.put("chat.message.system.info", "chat_message_system_info");
            this.put("chat.message.file.transport.request", "chat_message_file_transport_request");
            this.put("chat.message.file.transport.response.completed", "chat_message_file_transport_response_completed");
            this.put("chat.message.file.transport.response.denied", "chat_message_file_transport_response_denied");
            this.put("chat.message.file.event.time.out", "chat_message_file_event_time_out");
            this.put("chat.message.file.exchange.waiting.for.authorize", "chat_message_file_exchange_waiting_for_authorize");
            this.put("chat.message.file.exchange.uploading.file.to.server", "chat_message_file_exchange_uploading_file_to_server");
        }
    };
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final Log log = ExoLogger.getLogger((String)"lr.RESTXMPPService");
    private final XMPPMessenger messenger;
    private final UserInfoService organization;
    private final ContinuationServiceDelegate delegate;
    private final ResourceBundleService rbs;
    private ResourceBundle rb;
    private static final String BUNDLE_NAME = "locale.message.chat.serverMessage";
    private final HistoryImpl history;
    private static final CacheControl cc = new CacheControl();

    public RESTXMPPService(XMPPMessenger messenger, UserInfoService organization, ContinuationServiceDelegate delegate, HistoryImpl history, ResourceBundleService rbs) {
        this.messenger = messenger;
        this.organization = organization;
        this.delegate = delegate;
        this.history = history;
        this.rbs = rbs;
    }

    public void start() {
        this.loadResourceBundle();
    }

    public void stop() {
    }

    public ResourceBundle loadResourceBundle() {
        this.rb = this.rbs.getResourceBundle(BUNDLE_NAME, Locale.getDefault());
        return this.rb;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/loadJsResourceBundle/{locale}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response loadJsResourceBundle(@URIParam(value="locale") String locale) {
        ResourceBundle jsRb = this.rbs.getResourceBundle(BUNDLE_NAME, new Locale(locale));
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("eXo.communication.chatbar.locale.ResourceBundle = {\n");
            for (Map.Entry<String, String> entry : jsResourceBundle.entrySet()) {
                String value = jsRb != null && jsRb.getString(entry.getKey()) != null ? jsRb.getString(entry.getKey()) : entry.getKey();
                sb.append(entry.getValue() + " : \"").append(value).append("\",\n");
            }
            sb.append("chat_message_finish_load_resource_bundle : \"finish load resource bundle\"\n");
            sb.append("};");
            JsResourceBundleBean jsResourceBundleBean = new JsResourceBundleBean();
            jsResourceBundleBean.setScript(sb.toString());
            return Response.Builder.ok((Object)jsResourceBundleBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/createroom/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response createRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            String roomEscape = StringUtils.escapeNode((String)room.toLowerCase());
            try {
                RoomInfo roomInfo = session.getRoomInfo(roomEscape);
                if (roomInfo != null) {
                    return this.joinRoom(username, room, nickname, null);
                }
            }
            catch (XMPPException e) {
                // empty catch block
            }
            try {
                FormBean formBean = session.createRoom(roomEscape, nickname);
                ArrayList<String> values = new ArrayList<String>();
                values.add(room);
                formBean = TransformUtils.changeFieldForm(formBean, "muc#roomconfig_roomname", values);
                formBean = TransformUtils.changeFieldForm(formBean, "muc#roomconfig_roomdesc", values);
                return Response.Builder.ok((Object)formBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (Exception e) {
                return Response.Builder.withStatus((int)500).errorMessage(this.rb.getString("chat.message.room.creation.error") + "\n" + e.getMessage()).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/muc/configroom/{username}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response configRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room, ConfigRoomBean configRoom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                if (session.getMultiUserChat(room = StringUtils.escapeNode((String)room.toLowerCase())) != null) {
                    session.configRoom(room, configRoom);
                }
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
            }
            return Response.Builder.withStatus((int)500).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
        }
        catch (XMPPException e) {
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.conference.configuration.error") + "\n" + error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/getroomconfig/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRoomConfigForm(@URIParam(value="username") String username, @QueryParam(value="room") String room) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                FormBean formBean = session.getConfigFormRoom(room);
                if (formBean != null) {
                    return Response.Builder.ok((Object)formBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.conference.configuration.error")).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/getroominfo/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRoomInfo(@URIParam(value="username") String username, @QueryParam(value="room") String room) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                FullRoomInfoBean infoBean = session.getRoomInfoBean(room.toLowerCase());
                if (infoBean != null) {
                    return Response.Builder.ok((Object)infoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.conference.info.error") + "\n" + error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/joinedrooms/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getJoinedRooms(@URIParam(value="username") String username) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            try {
                ArrayList<FullRoomInfoBean> joinedRooms = new ArrayList<FullRoomInfoBean>();
                List<String> list = session.getJoinedRooms();
                for (String room : list) {
                    joinedRooms.add(session.getRoomInfoBean(room));
                }
                InitInfoBean bean = new InitInfoBean();
                bean.setJoinedRooms(joinedRooms);
                bean.setTotalJoinedRooms(list.size());
                return Response.Builder.ok((Object)bean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.conference.info.error") + "\n" + error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @Deprecated
    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/rooms-old/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRooms(@URIParam(value="username") String username) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            try {
                XMPPConnection connection = session.getConnection();
                Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
                String mucService = collectionMUCService.toArray()[0].toString();
                ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
                Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
                for (HostedRoom hostedRoom : hostedRooms) {
                    HostedRoomBean roomBean = new HostedRoomBean();
                    RoomInfo roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)connection, (String)hostedRoom.getJid());
                    if (roomInfo != null) {
                        roomBean = new HostedRoomBean(roomInfo);
                    }
                    roomBean.setJid(hostedRoom.getJid());
                    roomBean.setName(hostedRoom.getName());
                    rooms.add(roomBean);
                }
                InitInfoBean infoBean = new InitInfoBean();
                infoBean.setHostedRooms(rooms);
                return Response.Builder.ok((Object)infoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/rooms/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRooms(@URIParam(value="username") String username, @QueryParam(value="from") Integer from, @QueryParam(value="to") Integer to, @QueryParam(value="sort") String sort) {
        XMPPSessionImpl session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = (XMPPSessionImpl)this.messenger.getSession(username)) != null) {
            try {
                return Response.Builder.ok((Object)session.getRooms(from, to, sort), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.conference.info.error") + "\n" + error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/decline/{username}/{inviter}/")
    public Response declineToRoom(@URIParam(value="username") String username, @URIParam(value="inviter") String inviter, @QueryParam(value="room") String room, @QueryParam(value="reason") String reason) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            session.declineRoom(room, inviter, reason);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/destroy/{username}/")
    public Response destroyRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="reason") String reason, @QueryParam(value="altroom") String altRoom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.destroyRoom(room, reason, altRoom).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.not.found")).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.room.destroy.error") + "\n" + error.getMessage()).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/invite/{username}/{invitee}/")
    public Response inviteToRoom(@URIParam(value="username") String username, @URIParam(value="invitee") String invitee, @QueryParam(value="room") String room, @QueryParam(value="reason") String reason) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.inviteToRoom(room, invitee, reason).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                e.printStackTrace();
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.conference.service.error")).build();
            }
        }
        return Response.Builder.withStatus((int)400).cacheControl(cc).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/join/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response joinRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="password") String password) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.joinRoom(room, nickname, password);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 401: {
                        em = this.rb.getString("chat.message.password.private.room.error");
                        break;
                    }
                    case 403: {
                        em = this.rb.getString("chat.message.you.have.been.banned");
                        break;
                    }
                    case 404: {
                        em = this.rb.getString("chat.message.no.room.to.join.error");
                        break;
                    }
                    case 407: {
                        em = this.rb.getString("chat.message.room.user.not.member");
                        break;
                    }
                    case 409: {
                        em = this.rb.getString("chat.message.room.nickname.already.exist");
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(em).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/leaveroom/{username}/")
    public Response leftRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.leaveRoom(room).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/changenickname/{username}/{nickname}/")
    public Response changeNickname(@URIParam(value="username") String username, @QueryParam(value="nickname") String nickname, @QueryParam(value="room") String room) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || nickname == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeNickname(room, nickname);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 409: {
                        em = this.rb.getString("chat.message.room.nickname.already.exist");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(em).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/changestatus/{username}/{mode}/")
    public Response changeAvailabilityStatusInRoom(@URIParam(value="username") String username, @URIParam(value="mode") String mode, @QueryParam(value="room") String room, @QueryParam(value="status") String status) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeAvailabilityStatusInRoom(room, status, mode);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
            }
        }
        return Response.Builder.notFound().errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/changesubject/{username}/")
    public Response changeSubject(@URIParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="subject") String subject) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || subject == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeSubject(room, subject);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.notFound().errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/managerole/{username}/")
    public Response manageRoleRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="role") String role, @QueryParam(value="command") String command) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || nickname == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.manageRole(room, nickname, role, command);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 403: {
                        em = this.rb.getString("chat.message.forbidden.error");
                        break;
                    }
                    case 400: {
                        em = this.rb.getString("chat.message.user.not.found");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(em).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/manageaffiliation/{username}/")
    public Response manageAffilationRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="affiliation") String affiliation, @QueryParam(value="command") String command) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || nickname == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.manageAffiliation(room, nickname, affiliation, command);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 403: {
                        em = this.rb.getString("chat.message.forbidden.error");
                        break;
                    }
                    case 400: {
                        em = this.rb.getString("chat.message.user.not.found");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(em).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.Builder.withStatus((int)404).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/kick/{username}/")
    public Response kickUserFromRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="reason") String reason) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || nickname == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.kickUser(room, nickname, reason);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 405: {
                        em = this.rb.getString("chat.message.not.allowed.error");
                    }
                    case 403: {
                        em = this.rb.getString("chat.message.forbidden.error");
                        break;
                    }
                    case 400: {
                        em = this.rb.getString("chat.message.user.not.found");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(em).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.Builder.withStatus((int)404).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/ban/{username}/")
    public Response banUserFromRoom(@URIParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="name") String name, @QueryParam(value="reason") String reason) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || name == null) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.banUser(room, name, reason);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 405: {
                        em = this.rb.getString("chat.message.not.allowed.error");
                    }
                    case 403: {
                        em = this.rb.getString("chat.message.forbidden.error");
                        break;
                    }
                    case 400: {
                        em = this.rb.getString("chat.message.user.not.found");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(em).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.Builder.withStatus((int)404).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/addtransport/")
    public Response addTransport(@QueryParam(value="username") String username, @QueryParam(value="remoteusername") String remoteUser, @QueryParam(value="remotepassword") String remotePassword, @QueryParam(value="transport") String transport) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String serviceName = session.getConnection().getServiceName();
                if (transport.equalsIgnoreCase("yahoo")) {
                    YahooTransport yahooTransport = new YahooTransport(serviceName);
                    session.addTransport(yahooTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("icq")) {
                    ICQTransport icqTransport = new ICQTransport(serviceName);
                    session.addTransport(icqTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("msn")) {
                    MSNTransport msnTransport = new MSNTransport(serviceName);
                    session.addTransport(msnTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("aim")) {
                    AIMTransport aimTransport = new AIMTransport(serviceName);
                    session.addTransport(aimTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("gtalk")) {
                    GtalkTransport gtalkTransport = new GtalkTransport(serviceName);
                    session.addTransport(gtalkTransport, remoteUser, remotePassword, true);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Wrong transport name!");
                }
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
            }
            return Response.Builder.withStatus((int)403).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)400).errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/add/{username}/{adduser}/")
    public Response addBoddyToRoster(@URIParam(value="username") String username, @URIParam(value="adduser") String adduser, @QueryParam(value="nickname") String nickname, @QueryParam(value="group") String group) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (nickname == null) {
                    nickname = adduser;
                }
                session.addBuddy(adduser, nickname, group);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/update/{username}/{upduser}/")
    public Response updateBoddy(@URIParam(value="username") String username, @URIParam(value="upduser") String upduser, @QueryParam(value="nickname") String nickname, @QueryParam(value="group") String group) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (nickname == null) {
                    nickname = upduser;
                }
                session.updateBuddy(upduser, nickname, group);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/group/{username}/{group}/")
    public Response createGroup(@URIParam(value="username") String username, @URIParam(value="group") String group) {
        XMPPSessionImpl session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = (XMPPSessionImpl)this.messenger.getSession(username)) != null) {
            session.createGroup(group);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)500).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/askforsubscription/{username}/{askuser}/")
    public Response askForSubscription(@URIParam(value="username") String username, @URIParam(value="askuser") String askuser, @QueryParam(value="nickname") String nickname) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            if (session.getBuddy(askuser) == null) {
                return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.user.not.found")).build();
            }
            if (nickname == null) {
                nickname = askuser;
            }
            session.askForSubscription(askuser, nickname);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.Builder.withStatus((int)500).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/rosterclean/{username}/")
    public Response cleanBuddylist(@URIParam(value="username") String username) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.cleanBuddiesList();
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
            }
            return Response.Builder.withStatus((int)500).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{isGroupChat}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getAllHistory(@URIParam(value="usernameto") String usernameto, @URIParam(value="isGroupChat") Boolean isGroupChat, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (usernamefrom == null || usernamefrom.length() == 0) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.history.participant.name.not.set")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                list = session.getAllHistory(usernameto, usernamefrom, isGroupChat);
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (!list.isEmpty()) {
                    for (HistoricalMessage historicalMessage : list) {
                        listBean.add(TransformUtils.messageToBean(historicalMessage));
                    }
                }
                return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{isGroupChat}/{from}/{to}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getHistoryBetweenDate(@URIParam(value="usernameto") String usernameto, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="from") String from, @URIParam(value="to") String to, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (usernamefrom == null || usernamefrom.length() == 0) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.history.participant.name.not.set")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                Date dateFrom = new Date(Long.parseLong(from));
                Date dateTo = new Date(Long.parseLong(to));
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (dateFrom.before(dateTo)) {
                    list = session.getHistoryBetweenDate(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo);
                    if (!list.isEmpty()) {
                        for (HistoricalMessage historicalMessage : list) {
                            listBean.add(TransformUtils.messageToBean(historicalMessage));
                        }
                    }
                    return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{isGroupChat}/{from}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getHistoryFromDateToNow(@URIParam(value="usernameto") String usernameto, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="from") String from, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (usernamefrom == null || usernamefrom.length() == 0) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.history.participant.name.not.set")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                Date dateFrom = new Date(Long.parseLong(from));
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (dateFrom.before(Calendar.getInstance().getTime())) {
                    list = session.getHistoryFromDateToNow(usernameto, usernamefrom, isGroupChat, dateFrom);
                    if (!list.isEmpty()) {
                        for (HistoricalMessage historicalMessage : list) {
                            listBean.add(TransformUtils.messageToBean(historicalMessage));
                        }
                    }
                    return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getinterlocutors/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getInterlocutors(@URIParam(value="username") String username) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                return Response.Builder.ok((Object)new InterlocutorListBean(session.getInterlocutors(username)), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/file/getmessages/{usernameto}/{isGroupChat}/{clientTimezoneOffset}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getAllHistoryFile(@URIParam(value="usernameto") String usernameto, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="clientTimezoneOffset") String clientTimezoneOffset, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (usernamefrom == null || usernamefrom.length() == 0) {
            return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.history.participant.name.not.set")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernamefrom);
            if (session != null) {
                List<Object> list = new ArrayList();
                list = session.getAllHistory(usernameto, usernamefrom, isGroupChat);
                Integer clientTimeZoneOffset = Integer.valueOf(clientTimezoneOffset);
                for (HistoricalMessage historicalMessage : list) {
                    Date dateSend = historicalMessage.getDateSend();
                    dateSend = TransformUtils.convertToClientTime(dateSend, clientTimeZoneOffset);
                    historicalMessage.setDateSend(dateSend);
                }
                InputStream inputStream = this.historyBeanToStream(list);
                return Response.Builder.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", "attachment; filename=" + usernameto + "-" + usernamefrom + ".txt").cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/file/getmessages/{usernameto}/{isGroupChat}/{from}/{clientTimezoneOffset}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getHistoryFromDateToNowFile(@URIParam(value="usernameto") String usernameto, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="from") String from, @URIParam(value="clientTimezoneOffset") String clientTimezoneOffset, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernamefrom);
            if (session != null) {
                List<Object> list = new ArrayList();
                Integer clientTimeZoneOffset = Integer.valueOf(clientTimezoneOffset);
                Date dateFrom = new Date(Long.valueOf(from));
                if (dateFrom.before(Calendar.getInstance().getTime())) {
                    list = session.getHistoryFromDateToNow(usernameto, usernamefrom, isGroupChat, dateFrom);
                    for (HistoricalMessage historicalMessage : list) {
                        Date dateSend = historicalMessage.getDateSend();
                        dateSend = TransformUtils.convertToClientTime(dateSend, clientTimeZoneOffset);
                        historicalMessage.setDateSend(dateSend);
                    }
                    InputStream inputStream = this.historyBeanToStream(list);
                    CacheControl cacheControl = new CacheControl();
                    MultivaluedMetadata headers = new MultivaluedMetadata();
                    headers.putSingle("Content-disposition", "attachment; filename=" + usernameto + "-" + usernamefrom + "(" + from + ").txt");
                    headers.putSingle("Expires", "Sun, 17 Dec 1989 07:30:00 GMT");
                    return Response.Builder.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).headers(headers).cacheControl(cacheControl).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/file/getmessages/{usernameto}/{isGroupChat}/{from}/{to}/{clientTimezoneOffset}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getHistoryBetweenDateFile(@URIParam(value="usernameto") String usernameto, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="from") String from, @URIParam(value="to") String to, @URIParam(value="clientTimezoneOffset") String clientTimezoneOffset, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernamefrom);
            if (session != null) {
                Date dateTo;
                List<Object> list = new ArrayList();
                Integer clientTimeZoneOffset = Integer.valueOf(clientTimezoneOffset);
                Date dateFrom = new Date(Long.valueOf(from));
                if (dateFrom.before(dateTo = new Date(Long.valueOf(to)))) {
                    list = session.getHistoryBetweenDate(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo);
                    for (HistoricalMessage historicalMessage : list) {
                        Date dateSend = historicalMessage.getDateSend();
                        dateSend = TransformUtils.convertToClientTime(dateSend, clientTimeZoneOffset);
                        historicalMessage.setDateSend(dateSend);
                    }
                    InputStream inputStream = this.historyBeanToStream(list);
                    return Response.Builder.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", "attachment; filename=" + usernameto + "-" + usernamefrom + "(" + from + "-" + to + ").txt").cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    private InputStream historyBeanToStream(List<HistoricalMessage> history) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (!history.isEmpty()) {
                for (HistoricalMessage historicalMessage : history) {
                    String buffer = new String();
                    buffer = buffer.concat(StringUtils.parseBareAddress((String)historicalMessage.getFrom()) + "(" + historicalMessage.getDateSend().toString() + ") : " + historicalMessage.getBody() + "\n");
                    outputStream.write(buffer.getBytes());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/getsearchform/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getSearchUsersForm(@URIParam(value="username") String username, @QueryParam(value="searchservice") String searchService) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                Form form = session.getSearchForm(searchService);
                return Response.Builder.ok((Object)TransformUtils.formToFormBean(form), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).cacheControl(cc).errorMessage(this.rb.getString("chat.message.xmppsession.null")).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/getuserinfo/{username}/{needinfo}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUserInfo(@URIParam(value="username") String username, @URIParam(value="needinfo") String needinfo) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                return Response.Builder.ok((Object)session.getUserInfo(needinfo), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.badRequest().errorMessage(this.rb.getString("chat.message.default.error")).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/login2/{forcache}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response login2(@URIParam(value="forcache") String forcache) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            ConversationState curentState = ConversationState.getCurrent();
            String username = curentState.getIdentity().getUserId();
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)("Userid for login : " + username));
            }
            String password = (String)curentState.getIdentity().getSubject().getPrivateCredentials().iterator().next();
            this.messenger.login(username, password, this.organization, this.delegate, this.history, this.rb);
            XMPPSession session = this.messenger.getSession(username);
            XMPPConnection connection = session.getConnection();
            String mainServiceName = session.getConnection().getServiceName();
            List<String> services = session.getSearchServices();
            Form form = session.getSearchForm(services.get(0));
            Roster buddyList = session.getConnection().getRoster();
            session.removeAllTransport();
            Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
            String mucService = collectionMUCService.toArray()[0].toString();
            Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
            ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
            for (HostedRoom hostedRoom : hostedRooms) {
                HostedRoomBean roomBean = new HostedRoomBean();
                roomBean.setJid(hostedRoom.getJid());
                roomBean.setName(hostedRoom.getName());
                rooms.add(roomBean);
            }
            InitInfoBean initInfoBean = new InitInfoBean();
            initInfoBean.setForm(TransformUtils.formToFormBean(form));
            initInfoBean.setMainServiceName(mainServiceName);
            initInfoBean.setMucServicesNames(collectionMUCService);
            initInfoBean.setRoster(TransformUtils.rosterToRosterBean(buddyList));
            try {
                ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                for (ContactBean b : initInfoBean.getRoster()) {
                    UserInfo info = session.getUserInfo(b.getUser().split("@")[0]);
                    b.setFullName(info.getFirstName() + " " + info.getLastName());
                    list.add(b);
                }
                initInfoBean.setRoster(list);
            }
            catch (Exception e) {
                // empty catch block
            }
            initInfoBean.setSearchServicesNames(services);
            initInfoBean.setHostedRooms(rooms);
            initInfoBean.setTotalRooms(rooms.size());
            return Response.Builder.ok((Object)initInfoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).header("Set-Cookie", "userTicket=" + UUID.randomUUID().toString()).build();
        }
        catch (XMPPException e) {
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
        catch (Exception e) {
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/logout/{username}/")
    public Response logout(@URIParam(value="username") String _username) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(_username);
            if (session != null) {
                session.removeAllTransport();
            }
            this.messenger.logout(_username);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/messagereceive/{username}/{messageid}/")
    public Response messageReceive(@URIParam(value="username") String username, @URIParam(value="messageid") String messageId) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.messageReceive(messageId);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/del/{username}/{removeboddy}/")
    public Response removeBuddy(@URIParam(value="username") String username, @URIParam(value="removeboddy") String removeboddy) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                if (session.removeBuddy(removeboddy)) {
                    return Response.Builder.ok().cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)404).errorMessage(this.rb.getString("chat.message.user.not.found")).build();
            }
            return Response.Builder.withStatus((int)403).errorMessage(this.rb.getString("chat.message.xmppsession.null")).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/removetransport/{username}/{transport}/")
    public Response removeTransport(@URIParam(value="username") String username, @URIParam(value="transport") String _transport) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String serviceName = session.getConnection().getServiceName();
                if (_transport.equalsIgnoreCase("yahoo")) {
                    YahooTransport yahooTransport = new YahooTransport(serviceName);
                    session.removeTransport(yahooTransport);
                } else if (_transport.equalsIgnoreCase("icq")) {
                    ICQTransport icqTransport = new ICQTransport(serviceName);
                    session.removeTransport(icqTransport);
                } else if (_transport.equalsIgnoreCase("msn")) {
                    MSNTransport msnTransport = new MSNTransport(serviceName);
                    session.removeTransport(msnTransport);
                } else if (_transport.equalsIgnoreCase("aim")) {
                    AIMTransport aimTransport = new AIMTransport(serviceName);
                    session.removeTransport(aimTransport);
                } else if (_transport.equalsIgnoreCase("gtalk")) {
                    GtalkTransport gtalkTransport = new GtalkTransport(serviceName);
                    session.removeTransport(gtalkTransport);
                }
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).errorMessage("sesion is null").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/searchuser/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response searchUsers(@URIParam(value="username") String username, @QueryParam(value="search") String search, @QueryParam(value="username") Boolean byUsername, @QueryParam(value="name") Boolean byName, @QueryParam(value="email") Boolean byEmail, @QueryParam(value="searchservice") String searchService) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session;
            if (byUsername == null) {
                byUsername = new Boolean(false);
            }
            if (byName == null) {
                byName = new Boolean(false);
            }
            if (byEmail == null) {
                byEmail = new Boolean(false);
            }
            if ((session = this.messenger.getSession(username)) != null) {
                ReportedData reportedData = session.searchUser(search, byUsername, byName, byEmail, searchService);
                return Response.Builder.ok((Object)TransformUtils.reportedSateToSearchResultsBean(reportedData), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).errorMessage("session null").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/sendmessage/{username}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendMessage(@URIParam(value="username") String username, MessageBean messageBean) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            String from = session.getUsername().split("/")[0];
            Message message = new Message(messageBean.getTo(), Message.Type.chat);
            message.setFrom(from);
            message.setBody(messageBean.getBody());
            session.sendMessage(message);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)400).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/muc/sendmessage/{username}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendMUCMessage(@URIParam(value="username") String username, MessageBean messageBean) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            String room = messageBean.getTo();
            String body = messageBean.getBody();
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.sendMessageToMUC(room, body);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(this.rb.getString("chat.message.default.error")).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/sendstatus/{username}/{status}/")
    public Response setUserStatus(@URIParam(value="username") String username, @URIParam(value="status") String status) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            Presence presence = PresenceUtil.getPresence(status);
            if (presence == null) {
                return Response.Builder.withStatus((int)403).errorMessage("Get unknow status.").build();
            }
            session.sendPresence(presence);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/subscribeuser/{username}/{subsuser}/")
    public Response subscribeUser(@URIParam(value="username") String _username, @URIParam(value="subsuser") String _subsuser) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(_username)) != null) {
            session.subscribeUser(_subsuser);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/unsubscribeuser/{username}/{unsubsuser}/")
    public Response unsubscribeUser(@URIParam(value="username") String username, @URIParam(value="unsubsuser") String unsubsuser) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            session.unsubscribeUser(unsubsuser);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/fileexchange/accept/{username}/{uuid}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response acceptFile(@URIParam(value="username") String username, @URIParam(value="uuid") String uuid) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSessionImpl session = (XMPPSessionImpl)this.messenger.getSession(username);
            if (session != null) {
                FileTransferRequest request = session.getFileTransferRequest(uuid);
                String sender = request.getRequestor();
                Presence presence = session.getConnection().getRoster().getPresence(sender);
                if (presence.getType().equals((Object)Presence.Type.available)) {
                    IncomingFileTransfer fileTransfer = request.accept();
                    CacheControl ccIEfixed = new CacheControl();
                    MultivaluedMetadata headers = new MultivaluedMetadata();
                    headers.putSingle("Content-disposition", "attachment; filename=\"" + fileTransfer.getFileName() + "\"");
                    headers.putSingle("Expires", "Sun, 17 Dec 1989 07:30:00 GMT");
                    return Response.Builder.ok((Object)fileTransfer.recieveFile(), (String)DEFAULT_CONTENT_TYPE).headers(headers).contentLenght(fileTransfer.getFileSize()).cacheControl(ccIEfixed).build();
                }
                String errorMessage = this.rb.getString("chat.message.filetransfer.sender.accept.offline");
                session.sendErrorMessage(errorMessage.trim(), sender);
                return Response.Builder.withStatus((int)404).errorMessage(this.rb.getString("chat.message.filetransfer.sender.accept.offline")).build();
            }
            return Response.Builder.withStatus((int)500).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)400).errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/fileexchange/reject/{username}/{uuid}/")
    public Response rejectFile(@URIParam(value="username") String username, @URIParam(value="uuid") String uuid) {
        XMPPSessionImpl session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = (XMPPSessionImpl)this.messenger.getSession(username)) != null) {
            FileTransferRequest request = session.getFileTransferRequest(uuid);
            String sender = request.getRequestor();
            Presence presence = session.getConnection().getRoster().getPresence(sender);
            if (presence.getType().equals((Object)Presence.Type.available)) {
                request.reject();
                return Response.Builder.ok().cacheControl(cc).build();
            }
            String errorMessage = this.rb.getString("chat.message.filetransfer.sender.reject.offline");
            session.sendErrorMessage(errorMessage.trim(), sender);
            return Response.Builder.withStatus((int)404).errorMessage(this.rb.getString("chat.message.filetransfer.sender.reject.offline")).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage(this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    static {
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

