/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.xmpp.ext.transport.AIMTransport;
import org.exoplatform.services.xmpp.ext.transport.GtalkTransport;
import org.exoplatform.services.xmpp.ext.transport.ICQTransport;
import org.exoplatform.services.xmpp.ext.transport.MSNTransport;
import org.exoplatform.services.xmpp.ext.transport.Transport;
import org.exoplatform.services.xmpp.ext.transport.XMPPTransport;
import org.exoplatform.services.xmpp.ext.transport.YahooTransport;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPConnectionUtils {
    private static final Log LOGGER = ExoLogger.getLogger((String)"ConnectionUtils");

    public static DiscoverItems getDiscoverItems(XMPPConnection connection, String entityId) {
        ServiceDiscoveryManager serviceDiscoveryManager = new ServiceDiscoveryManager(connection);
        try {
            return serviceDiscoveryManager.discoverItems(entityId);
        }
        catch (XMPPException e) {
            LOGGER.error((Object)("Can't get discovery items for entityId: " + entityId + " : " + (Object)((Object)e)));
            return new DiscoverItems();
        }
    }

    public static List<Transport> getSupportedTransports(XMPPConnection connection) {
        DiscoverItems discoverItems = XMPPConnectionUtils.getDiscoverItems(connection, connection.getServiceName());
        Iterator iterator = discoverItems.getItems();
        ArrayList<Transport> transports = new ArrayList<Transport>();
        String serviceName = connection.getServiceName();
        while (iterator.hasNext()) {
            String entityName = ((DiscoverItems.Item)iterator.next()).getEntityID();
            if (entityName.startsWith("yahoo.")) {
                transports.add(new YahooTransport(serviceName));
                continue;
            }
            if (entityName.startsWith("icq.")) {
                transports.add(new ICQTransport(serviceName));
                continue;
            }
            if (entityName.startsWith("xmpp.")) {
                transports.add(new XMPPTransport(serviceName));
                continue;
            }
            if (entityName.startsWith("aim.")) {
                transports.add(new AIMTransport(serviceName));
                continue;
            }
            if (entityName.startsWith("gtalk.")) {
                transports.add(new GtalkTransport(serviceName));
                continue;
            }
            if (!entityName.startsWith("msn.")) continue;
            transports.add(new MSNTransport(serviceName));
        }
        return transports;
    }

    public static void registerUser(XMPPConnection connection, String serviceName, String username, String password) throws XMPPException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(serviceName);
        registration.addExtension((PacketExtension)new TransportRegisterExtension());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", username);
        attributes.put("password", password);
        registration.setAttributes(attributes);
        PacketCollector collector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(registration.getPacketID()));
        connection.sendPacket((Packet)registration);
        IQ response = (IQ)collector.nextResult((long)(2 * SmackConfiguration.getPacketReplyTimeout()));
        collector.cancel();
        if (response == null) {
            throw new XMPPException("Server timed out!");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException("Error registering user!", response.getError());
        }
    }

    public static void unregisterUser(XMPPConnection connection, String serviceName) throws XMPPException {
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(serviceName);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("remove", "");
        registration.setAttributes(map);
        PacketCollector collector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(registration.getPacketID()));
        connection.sendPacket((Packet)registration);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("Server timed out!");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException("Error registering user!", response.getError());
        }
    }

    public static boolean isRegistered(XMPPConnection connection, String serviceName) {
        if (!connection.isConnected()) {
            return false;
        }
        ServiceDiscoveryManager discoveryManager = new ServiceDiscoveryManager(connection);
        try {
            DiscoverInfo info = discoveryManager.discoverInfo(serviceName);
            return info.containsFeature("jabber:iq:registered");
        }
        catch (XMPPException e) {
            LOGGER.error((Object)("Error: " + (Object)((Object)e)));
            return false;
        }
    }

    public static String getAddress(String fullJID) {
        return fullJID.split("/")[0];
    }

    public static String getName(String address) {
        return address.split("@")[0];
    }

    static class TransportRegisterExtension
    implements PacketExtension {
        TransportRegisterExtension() {
        }

        public String getElementName() {
            return "x";
        }

        public String getNamespace() {
            return "jabber:iq:gateway:register";
        }

        public String toXML() {
            StringBuffer sb = new StringBuffer();
            sb.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\"/>");
            return sb.toString();
        }
    }
}

