/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.connection.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.xmpp.connection.XMPPSession;
import org.exoplatform.services.xmpp.connection.impl.XMPPSessionImpl;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.exoplatform.services.xmpp.userinfo.UserInfoService;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;

public class XMPPMessenger {
    protected static final Log LOGGER = LogFactory.getLog((String)"XMPPMessenger");
    private static final String PORT = "port";
    private static final String HOST = "host";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 5222;
    private static final int DEFAULT_DISCONNECT_TIME = 10000;
    private static final long DEFAULT_CLOSE_SESSION_TIME = 100000L;
    private static int disconnect_time;
    private static long close_session_time;
    private static int file_send_timeout;
    private static ConnectionConfiguration connectionConfiguration;
    private Map<String, XMPPSession> sessions_ = new HashMap<String, XMPPSession>();

    public XMPPMessenger(InitParams params) {
        PropertiesParam pparams = params.getPropertiesParam("openfire-connection-conf");
        if (pparams != null) {
            String host = pparams.getProperty(HOST) != null ? pparams.getProperty(HOST) : DEFAULT_HOST;
            int port = pparams.getProperty(PORT) != null ? Integer.valueOf(pparams.getProperty(PORT)) : 5222;
            connectionConfiguration = new ConnectionConfiguration(host, port);
        } else {
            LOGGER.info((Object)"Connection params to XMPP server is null.Use default configuration.");
        }
        pparams = params.getPropertiesParam("alive-checker-conf");
        if (pparams != null) {
            disconnect_time = pparams.getProperty("disconnect") != null ? Integer.parseInt(pparams.getProperty("disconnect")) : 10000;
            close_session_time = pparams.getProperty("close") != null ? Long.parseLong(pparams.getProperty("close")) : 100000L;
        } else {
            LOGGER.info((Object)"Connection params to alive-checker-conf server is null.Use default configuration.");
        }
        pparams = params.getPropertiesParam("send-file");
        if (pparams != null) {
            file_send_timeout = pparams.getProperty("timeout") != null ? Integer.parseInt(pparams.getProperty("timeout")) : OutgoingFileTransfer.getResponseTimeout();
        } else {
            LOGGER.info((Object)"Connection params to alive-checker-conf server is null.Use default configuration.");
        }
        OutgoingFileTransfer.setResponseTimeout((int)file_send_timeout);
    }

    public static ConnectionConfiguration getConnectionConfiguration() {
        return connectionConfiguration;
    }

    public static long getCloseSessionTime() {
        return close_session_time;
    }

    public static int getDisconnectTime() {
        return disconnect_time;
    }

    public synchronized void login(String username, String password, UserInfoService userInfoService, ContinuationServiceDelegate delegate, HistoryImpl history, ResourceBundle rb) throws XMPPException {
        try {
            XMPPSession session = this.sessions_.get(username);
            if (session != null && session.getConnection().isConnected() && session.getConnection().isAuthenticated()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)"Client has one opened session!");
                }
            } else {
                XMPPSessionImpl sessionImpl = new XMPPSessionImpl(username, password, userInfoService, delegate, history, rb);
                this.sessions_.put(username, sessionImpl);
            }
        }
        catch (XMPPException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)("Can't create XMPP session for user '" + username + "'. Exception: " + (Object)((Object)e)));
                e.printStackTrace();
            }
            throw new XMPPException(new XMPPError(XMPPError.Condition.remote_server_not_found, "Error login: Openfire server isn't started"));
        }
    }

    public synchronized void logout(String username) {
        XMPPSession session = this.sessions_.remove(username);
        if (session != null) {
            session.close();
        }
    }

    public XMPPSession getSession(String username) {
        XMPPSession session;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info((Object)("Get session for User '" + username + "'."));
        }
        if ((session = this.sessions_.get(username)) == null && LOGGER.isDebugEnabled()) {
            LOGGER.warn((Object)("User '" + username + "' is not registered on the server."));
        }
        return session;
    }

    static {
        Roster.setDefaultSubscriptionMode((Roster.SubscriptionMode)Roster.SubscriptionMode.manual);
        connectionConfiguration = new ConnectionConfiguration(DEFAULT_HOST, 5222);
    }
}

