/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.Connector;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.connection.impl.XMPPSessionImpl;

@Deprecated
public class FileExchangeServlet
extends HttpServlet
implements Connector {
    private final Log log = LogFactory.getLog((String)"ws.FileExchangeServlet");
    private String tmpDir;

    public void init() throws ServletException {
        String tmpdir = this.getInitParameter("tmpdir");
        if (tmpdir != null) {
            this.tmpDir = tmpdir;
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Tmp dir is not set, default " + System.getProperty("java.io.tmpdir")));
            }
            this.tmpDir = System.getProperty("java.io.tmpdir");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String description = req.getParameter("description");
        String username = req.getParameter("username");
        String requestor = req.getParameter("requestor");
        String isRoom = req.getParameter("isroom");
        boolean isMultipart = FileUploadBase.isMultipartContent((HttpServletRequest)req);
        if (isMultipart) {
            DiskFileUpload upload = new DiskFileUpload();
            try {
                List items = upload.parseRequest(req);
                XMPPMessenger messenger = (XMPPMessenger)PortalContainer.getInstance().getComponentInstanceOfType(XMPPMessenger.class);
                for (FileItem fileItem : items) {
                    XMPPSessionImpl session = (XMPPSessionImpl)messenger.getSession(username);
                    String fileName = fileItem.getName();
                    String fileType = fileItem.getContentType();
                    if (session != null) {
                        if (fileName == null) continue;
                        fileName = FilenameUtils.getName((String)fileName);
                        fileType = FilenameUtils.getExtension((String)fileName);
                        File file = new File(this.tmpDir);
                        if (!file.isDirectory()) continue;
                        String uuid = UUID.randomUUID().toString();
                        boolean success = new File(this.tmpDir + "/" + uuid).mkdir();
                        if (success) {
                            int len;
                            String path = this.tmpDir + "/" + uuid + "/" + fileName;
                            File f = new File(path);
                            success = f.createNewFile();
                            if (!success) continue;
                            InputStream inputStream = fileItem.getInputStream();
                            FileOutputStream out = new FileOutputStream(f);
                            byte[] buf = new byte[1024];
                            while ((len = inputStream.read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            ((OutputStream)out).close();
                            inputStream.close();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("File " + path + "is created"));
                            }
                            session.sendFile(requestor, path, description, Boolean.parseBoolean(isRoom));
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)"File already exists");
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("XMPPSession for user " + username + " is null!"));
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                resp.sendError(400, e.getMessage());
            }
        }
    }
}

