/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.presence;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;

public class DefaultPresenceStatus {
    private static final Log log = ExoLogger.getLogger(DefaultPresenceStatus.class);
    public static final String DEFAULT_STATUS = "default_presence_status";
    private String status_ = "default_presence_status";

    public String getStatus_() {
        return this.status_;
    }

    public DefaultPresenceStatus() {
    }

    public DefaultPresenceStatus(InitParams param) {
        PropertiesParam pparam = param.getPropertiesParam("presence-status");
        if (pparam != null) {
            this.status_ = pparam.getProperty("mode") == null ? DEFAULT_STATUS : pparam.getProperty("mode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreviousStatus(String userId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        HistoryImpl history = (HistoryImpl)container.getComponentInstanceOfType(HistoryImpl.class);
        SessionProvider provider = SessionProvider.createSystemProvider();
        String ps = null;
        try {
            ps = history.getPresenceStatusHistory(provider, userId);
            if (ps == null) {
                ps = this.getStatus_();
            }
        }
        finally {
            if (provider != null) {
                provider.close();
            }
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePresenceStatus(String userId, String status) {
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            HistoryImpl history = (HistoryImpl)container.getComponentInstanceOfType(HistoryImpl.class);
            history.savePresenceStatus(provider, userId, status);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error when saving present status!", (Throwable)e);
            }
        }
        finally {
            if (provider != null) {
                provider.close();
            }
        }
    }
}

