/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.connection.impl;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.presence.DefaultPresenceStatus;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.xmpp.connection.XMPPSession;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationLogoutListener
extends Listener<ConversationRegistry, ConversationState> {
    protected static final Log log = ExoLogger.getLogger((String)"chat.AuthenticationLogoutListener");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        XMPPMessenger messenger = null;
        String userId = null;
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
            DefaultPresenceStatus dps = (DefaultPresenceStatus)container.getComponentInstance(DefaultPresenceStatus.class);
            if (messenger != null) {
                ContinuationServiceDelegate delegate;
                userId = ((ConversationState)event.getData()).getIdentity().getUserId();
                XMPPSession session = messenger.getSession(userId);
                if (session != null) {
                    if (dps != null && userId != null && !userId.equals("")) {
                        dps.savePresenceStatus(userId, session.getPresenceStatus_());
                    } else {
                        log.error((Object)"Can not save user chat status");
                    }
                    session.removeAllTransport();
                }
                if ((delegate = (ContinuationServiceDelegate)container.getComponentInstanceOfType(ContinuationServiceDelegate.class)) != null) {
                    delegate.sendMessage(userId, "/eXo/Application/Chat/notification", "session-expired", null);
                }
            }
            if (userId != null && messenger != null) {
                messenger.logout(userId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        finally {
            if (userId != null && messenger != null) {
                messenger.logout(userId);
            }
        }
    }
}

