/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.connection.impl;

import java.util.Queue;
import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class HistoryJob
implements Job {
    private static Log log = ExoLogger.getLogger((String)"job.ChatRecordsJob");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        PortalContainer container = HistoryJob.getPortalContainer(context);
        if (container == null) {
            return;
        }
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RepositoryService repoService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        SessionProvider provider = SessionProvider.createSystemProvider();
        String currentRepo = null;
        try {
            currentRepo = repoService.getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e1) {
            log.warn((Object)"Could not get current repository name", (Throwable)e1);
        }
        try {
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            int logBatchSize = Integer.parseInt(jdatamap.getString("logBatchSize"));
            HistoryImpl historyImpl = (HistoryImpl)container.getComponentInstanceOfType(HistoryImpl.class);
            boolean success = false;
            Queue<HistoricalMessage> logQueue = historyImpl.getLogQueue();
            for (int index = 0; index <= logBatchSize && !logQueue.isEmpty(); ++index) {
                HistoricalMessage message = logQueue.poll();
                if (message == null) continue;
                String repoName = message.getRepository();
                if (repoName != null) {
                    try {
                        repoService.setCurrentRepositoryName(repoName);
                    }
                    catch (RepositoryConfigurationException ex) {
                        log.error((Object)String.format("Could not set current repository name as %s", repoName), (Throwable)ex);
                    }
                }
                if (repoName != null) {
                    success = historyImpl.addHistoricalMessage(message, provider);
                }
                if (success) continue;
                logQueue.add(message);
            }
        }
        catch (Exception e) {
            try {
                log.error((Object)"An exception happened when saving chat message", (Throwable)e);
            }
            catch (Throwable throwable) {
                provider.close();
                if (currentRepo != null) {
                    try {
                        repoService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e2) {
                        log.error((Object)String.format("Could not set current repository name as %s", currentRepo), (Throwable)e2);
                    }
                }
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                throw throwable;
            }
            provider.close();
            if (currentRepo != null) {
                try {
                    repoService.setCurrentRepositoryName(currentRepo);
                }
                catch (RepositoryConfigurationException e3) {
                    log.error((Object)String.format("Could not set current repository name as %s", currentRepo), (Throwable)e3);
                }
            }
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
        provider.close();
        if (currentRepo != null) {
            try {
                repoService.setCurrentRepositoryName(currentRepo);
            }
            catch (RepositoryConfigurationException e) {
                log.error((Object)String.format("Could not set current repository name as %s", currentRepo), (Throwable)e);
            }
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
    }

    private static PortalContainer getPortalContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = context.getJobDetail().getGroup();
        if (portalName == null) {
            return null;
        }
        if (portalName.indexOf(":") > 0) {
            portalName = portalName.substring(0, portalName.indexOf(":"));
        }
        return RootContainer.getInstance().getPortalContainer(portalName);
    }
}

