/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.util;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.Presence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PresenceUtil {
    public static final String ONLINE = "Available";
    public static final String FREE_TO_CHAT = "Free to chat";
    public static final String DO_NOT_DISTURB = "Do not disturb";
    public static final String AWAY = "Away";
    public static final String EXTEND_AWAY = "Extend away";
    private static final List<Presence> PRESENCES = new ArrayList<Presence>();

    public static List<Presence> getPresences() {
        return PRESENCES;
    }

    public static Presence getPresence(String status) {
        for (Presence presence : PRESENCES) {
            if (!presence.getStatus().equalsIgnoreCase(status)) continue;
            return presence;
        }
        return null;
    }

    public static Presence getPresence(String status, String address) {
        for (Presence presence : PRESENCES) {
            if (!presence.getStatus().equalsIgnoreCase(status)) continue;
            presence.setTo(address);
            return presence;
        }
        return null;
    }

    public static String getDefaultStatusMode(Presence.Mode mode) {
        for (Presence presence : PRESENCES) {
            if (!mode.equals((Object)presence.getMode())) continue;
            return presence.getStatus();
        }
        return null;
    }

    static {
        PRESENCES.add(new Presence(Presence.Type.available, ONLINE, 1, Presence.Mode.available));
        PRESENCES.add(new Presence(Presence.Type.available, FREE_TO_CHAT, 1, Presence.Mode.chat));
        PRESENCES.add(new Presence(Presence.Type.available, DO_NOT_DISTURB, 0, Presence.Mode.dnd));
        PRESENCES.add(new Presence(Presence.Type.available, AWAY, 0, Presence.Mode.away));
        PRESENCES.add(new Presence(Presence.Type.available, EXTEND_AWAY, 0, Presence.Mode.xa));
    }
}

